/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.File;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.engine.impl.parameters.ParameterMap;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.parameters.Util;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, name="org.apache.sling.engine.parameters", label="Apache Sling Request Parameter Handling", description="Configures Sling's request parameter handling.")
public class RequestParameterSupportConfigurer {
    static final String PID = "org.apache.sling.engine.parameters";
    private final Logger log = LoggerFactory.getLogger((String)"org.apache.sling.engine.parameters");
    @Property(value={"ISO-8859-1"}, label="Default Parameter Encoding", description="The default request parameter encoding used to decode request parameters into strings. If this property is not set the default encoding is 'ISO-8859-1' as mandated by the Servlet API spec. This default encoding is used if the '_charset_' request parameter is not set to another (supported) character encoding. Applications being sure to always use the same encoding (e.g. UTF-8) can set this default here and may omit the '_charset_' request parameter")
    private static final String PROP_FIX_ENCODING = "sling.default.parameter.encoding";
    @Property(intValue={10000}, label="Maximum POST Parameters", description="The maximum number of parameters supported. To prevent a DOS-style attack with an overrunning number of parameters the number of parameters supported can be limited. This includes all of the query string as well as application/x-www-form-urlencoded and multipart/form-data parameters. The default value is 10000.")
    private static final String PROP_MAX_PARAMS = "sling.default.max.parameters";
    @Property(label="Temporary File Location", description="The size threshold after which the file will be written to disk. The default is null, which means the directory given by the 'java.io.tmpdir' system property.")
    private static final String PROP_FILE_LOCATION = "file.location";
    @Property(longValue={256000L}, label="File Save Threshold", description="The size threshold after which the file will be written to disk. The default is 256KB.")
    private static final String PROP_FILE_SIZE_THRESHOLD = "file.threshold";
    @Property(longValue={-1L}, label="Maximum File Size", description="The maximum size allowed for uploaded files. The default is -1, which means unlimited.")
    private static final String PROP_FILE_SIZE_MAX = "file.max";
    @Property(longValue={-1L}, label="Maximum Request Size", description="The maximum size allowed for multipart/form-data requests. The default is -1, which means unlimited.")
    private static final String PROP_MAX_REQUEST_SIZE = "request.max";
    @Reference
    private SlingSettingsService settignsService;

    @Activate
    @Deactivate
    private void configure(ComponentContext context) {
        Dictionary props = context.getProperties();
        String fixEncoding = PropertiesUtil.toString(props.get(PROP_FIX_ENCODING), (String)"ISO-8859-1");
        int maxParams = PropertiesUtil.toInteger(props.get(PROP_MAX_PARAMS), (int)10000);
        long maxRequestSize = PropertiesUtil.toLong(props.get(PROP_MAX_REQUEST_SIZE), (long)-1L);
        String fileLocation = this.getFileLocation(context, PropertiesUtil.toString(props.get(PROP_FILE_LOCATION), null));
        long maxFileSize = PropertiesUtil.toLong(props.get(PROP_FILE_SIZE_MAX), (long)-1L);
        int fileSizeThreshold = PropertiesUtil.toInteger(props.get(PROP_FILE_SIZE_THRESHOLD), (int)-1);
        if (this.log.isInfoEnabled()) {
            this.log.info("Default Character Encoding: {}", (Object)fixEncoding);
            this.log.info("Parameter Number Limit: {}", maxParams < 0 ? "unlimited" : Integer.valueOf(maxParams));
            this.log.info("Maximum Request Size: {}", maxParams < 0 ? "unlimited" : Long.valueOf(maxRequestSize));
            this.log.info("Temporary File Location: {}", (Object)fileLocation);
            this.log.info("Maximum File Size: {}", (Object)maxFileSize);
            this.log.info("Tempory File Creation Threshold: {}", (Object)fileSizeThreshold);
        }
        Util.setDefaultFixEncoding(fixEncoding);
        ParameterMap.setMaxParameters(maxParams);
        ParameterSupport.configure(maxRequestSize, fileLocation, maxFileSize, fileSizeThreshold);
    }

    private String getFileLocation(ComponentContext context, String fileLocation) {
        if (fileLocation != null) {
            File file = new File(fileLocation);
            if (!file.isAbsolute()) {
                file = new File(this.settignsService.getSlingHomePath(), fileLocation);
                fileLocation = file.getAbsolutePath();
            }
            if (file.exists()) {
                if (!file.isDirectory()) {
                    this.log.error("Configured temporary file location {} exists but is not a directory; using java.io.tmpdir instead", (Object)fileLocation);
                    fileLocation = null;
                }
            } else if (!file.mkdirs()) {
                this.log.error("Cannot create temporary file directory {}; using java.io.tmpdir instead", (Object)fileLocation);
                fileLocation = null;
            }
        }
        return fileLocation;
    }

    protected void bindSettignsService(SlingSettingsService slingSettingsService) {
        this.settignsService = slingSettingsService;
    }

    protected void unbindSettignsService(SlingSettingsService slingSettingsService) {
        if (this.settignsService == slingSettingsService) {
            this.settignsService = null;
        }
    }
}

