/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RecursionTooDeepException;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.request.TooManyCallsException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.engine.impl.SlingHttpServletRequestImpl;
import org.apache.sling.engine.impl.SlingHttpServletResponseImpl;
import org.apache.sling.engine.impl.SlingMainServlet;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.adapter.SlingServletRequestAdapter;
import org.apache.sling.engine.impl.adapter.SlingServletResponseAdapter;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.SlingRequestPathInfo;
import org.apache.sling.engine.impl.request.SlingRequestProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestData {
    private final Logger log = LoggerFactory.getLogger(RequestData.class);
    public static final int DEFAULT_MAX_INCLUSION_COUNTER = 50;
    public static final int DEFAULT_MAX_CALL_COUNTER = 1000;
    public static final String REQUEST_RESOURCE_PATH_ATTR = "$$sling.request.resource$$";
    private static int maxInclusionCounter = 50;
    private static int maxCallCounter = 1000;
    private static String REQUEST_MAX_CALL_OVERRIDE = "sling.max.calls";
    private static SlingMainServlet SLING_MAIN_SERVLET;
    private static SlingHttpServletRequestFactory REQUEST_FACTORY;
    private static ArrayList<StaticResponseHeader> ADDITIONAL_RESPONSE_HEADERS;
    private final SlingRequestProcessorImpl slingRequestProcessor;
    private final long startTimestamp = System.currentTimeMillis();
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private SlingHttpServletRequest slingRequest;
    private SlingHttpServletResponse slingResponse;
    private ParameterSupport parameterSupport;
    private ResourceResolver resourceResolver;
    private RequestProgressTracker requestProgressTracker;
    private ContentData currentContentData;
    private int servletCallCounter;
    private String activeServletName;
    private int recursionDepth;
    private int peakRecusionDepth;

    public static void setMaxCallCounter(int maxCallCounter) {
        RequestData.maxCallCounter = maxCallCounter;
    }

    public static int getMaxCallCounter() {
        return maxCallCounter;
    }

    public static void setMaxIncludeCounter(int maxInclusionCounter) {
        RequestData.maxInclusionCounter = maxInclusionCounter;
    }

    public static int getMaxIncludeCounter() {
        return maxInclusionCounter;
    }

    public static void setSlingMainServlet(SlingMainServlet slingMainServlet) {
        SLING_MAIN_SERVLET = slingMainServlet;
        REQUEST_FACTORY = null;
    }

    public static void setAdditionalResponseHeaders(ArrayList<StaticResponseHeader> mappings) {
        ADDITIONAL_RESPONSE_HEADERS = mappings;
    }

    public static ArrayList<StaticResponseHeader> getAdditionalResponseHeaders() {
        return ADDITIONAL_RESPONSE_HEADERS;
    }

    public RequestData(SlingRequestProcessorImpl slingRequestProcessor, HttpServletRequest request, HttpServletResponse response) {
        this.slingRequestProcessor = slingRequestProcessor;
        this.servletRequest = request;
        this.servletResponse = response;
        this.slingRequest = RequestData.getSlingHttpServletRequestFactory().createRequest(this, this.servletRequest);
        this.slingResponse = new SlingHttpServletResponseImpl(this, this.servletResponse);
        this.requestProgressTracker = new SlingRequestProgressTracker();
        this.requestProgressTracker.log("Method={0}, PathInfo={1}", new Object[]{this.slingRequest.getMethod(), this.slingRequest.getPathInfo()});
    }

    public Resource initResource(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.requestProgressTracker.startTimer("ResourceResolution");
        SlingHttpServletRequest request = this.getSlingRequest();
        StringBuffer requestURL = this.servletRequest.getRequestURL();
        String path = request.getPathInfo();
        if (requestURL.indexOf(";") > -1 && !path.contains(";")) {
            String decodedURL;
            try {
                decodedURL = URLDecoder.decode(requestURL.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)"UTF-8 encoding is not supported");
            }
            path = path.concat(decodedURL.substring(decodedURL.indexOf(59)));
        }
        Resource resource = resourceResolver.resolve((HttpServletRequest)request, path);
        if (request.getAttribute(REQUEST_RESOURCE_PATH_ATTR) == null) {
            request.setAttribute(REQUEST_RESOURCE_PATH_ATTR, (Object)resource.getPath());
        }
        this.requestProgressTracker.logTimer("ResourceResolution", "URI={0} resolves to Resource={1}", new Object[]{this.getServletRequest().getRequestURI(), resource});
        return resource;
    }

    public void initServlet(Resource resource, ServletResolver sr) {
        SlingRequestPathInfo requestPathInfo = new SlingRequestPathInfo(resource);
        ContentData contentData = this.setContent(resource, requestPathInfo);
        this.requestProgressTracker.log("Resource Path Info: {0}", new Object[]{requestPathInfo});
        this.requestProgressTracker.startTimer("ServletResolution");
        Servlet servlet = sr.resolveServlet(this.slingRequest);
        this.requestProgressTracker.logTimer("ServletResolution", "URI={0} handled by Servlet={1}", new Object[]{this.getServletRequest().getRequestURI(), servlet == null ? "-none-" : RequestUtil.getServletName((Servlet)servlet)});
        contentData.setServlet(servlet);
    }

    public SlingRequestProcessorImpl getSlingRequestProcessor() {
        return this.slingRequestProcessor;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public SlingHttpServletRequest getSlingRequest() {
        return this.slingRequest;
    }

    public SlingHttpServletResponse getSlingResponse() {
        return this.slingResponse;
    }

    public static SlingHttpServletRequest unwrap(ServletRequest request) {
        if (request instanceof SlingHttpServletRequest) {
            return (SlingHttpServletRequest)request;
        }
        while (request instanceof ServletRequestWrapper) {
            if (!((request = ((ServletRequestWrapper)request).getRequest()) instanceof SlingHttpServletRequest)) continue;
            return (SlingHttpServletRequest)request;
        }
        throw new IllegalArgumentException("ServletRequest not wrapping SlingHttpServletRequest");
    }

    public static SlingHttpServletRequestImpl unwrap(SlingHttpServletRequest request) {
        while (request instanceof SlingHttpServletRequestWrapper) {
            request = ((SlingHttpServletRequestWrapper)request).getSlingRequest();
        }
        if (request instanceof SlingHttpServletRequestImpl) {
            return (SlingHttpServletRequestImpl)request;
        }
        throw new IllegalArgumentException("SlingHttpServletRequest not of correct type");
    }

    public static SlingHttpServletResponse unwrap(ServletResponse response) {
        if (response instanceof SlingHttpServletResponse) {
            return (SlingHttpServletResponse)response;
        }
        while (response instanceof ServletResponseWrapper) {
            if (!((response = ((ServletResponseWrapper)response).getResponse()) instanceof SlingHttpServletResponse)) continue;
            return (SlingHttpServletResponse)response;
        }
        throw new IllegalArgumentException("ServletResponse not wrapping SlingHttpServletResponse");
    }

    public static SlingHttpServletResponseImpl unwrap(SlingHttpServletResponse response) {
        while (response instanceof SlingHttpServletResponseWrapper) {
            response = ((SlingHttpServletResponseWrapper)response).getSlingResponse();
        }
        if (response instanceof SlingHttpServletResponseImpl) {
            return (SlingHttpServletResponseImpl)response;
        }
        throw new IllegalArgumentException("SlingHttpServletResponse not of correct type");
    }

    public static RequestData getRequestData(ServletRequest request) {
        return RequestData.unwrap(RequestData.unwrap(request)).getRequestData();
    }

    public static RequestData getRequestData(SlingHttpServletRequest request) {
        return RequestData.unwrap(request).getRequestData();
    }

    public static SlingHttpServletRequest toSlingHttpServletRequest(ServletRequest request) {
        SlingHttpServletRequest cRequest = RequestData.unwrap(request);
        RequestData.unwrap(cRequest);
        if (cRequest == request) {
            return cRequest;
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HTTP request");
        }
        return new SlingServletRequestAdapter(cRequest, (HttpServletRequest)request);
    }

    public static SlingHttpServletResponse toSlingHttpServletResponse(ServletResponse response) {
        SlingHttpServletResponse cResponse = RequestData.unwrap(response);
        RequestData.unwrap(cResponse);
        if (cResponse == response) {
            return cResponse;
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Response is not an HTTP response");
        }
        return new SlingServletResponseAdapter(cResponse, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void service(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        RequestData requestData = RequestData.getRequestData(request);
        Servlet servlet = requestData.getContentData().getServlet();
        if (servlet == null) {
            response.sendError(404, "No Servlet to handle request");
        } else {
            String name = RequestUtil.getServletName((Servlet)servlet);
            if (requestData.hasServletMaxCallCount((ServletRequest)request)) {
                throw new TooManyCallsException(name);
            }
            Object oldValue = request.getAttribute("sling.core.current.servletName");
            request.setAttribute("sling.core.current.servletName", (Object)name);
            String timerName = name + "#" + requestData.servletCallCounter;
            ++requestData.servletCallCounter;
            requestData.getRequestProgressTracker().startTimer(timerName);
            try {
                String callerServlet = requestData.setActiveServletName(name);
                servlet.service((ServletRequest)request, (ServletResponse)response);
                requestData.setActiveServletName(callerServlet);
            }
            finally {
                request.setAttribute("sling.core.current.servletName", oldValue);
                requestData.getRequestProgressTracker().logTimer(timerName);
            }
        }
    }

    public ContentData setContent(Resource resource, RequestPathInfo requestPathInfo) {
        if (this.recursionDepth >= maxInclusionCounter) {
            throw new RecursionTooDeepException(requestPathInfo.getResourcePath());
        }
        ++this.recursionDepth;
        if (this.recursionDepth > this.peakRecusionDepth) {
            this.peakRecusionDepth = this.recursionDepth;
        }
        this.currentContentData = new ContentData(resource, requestPathInfo);
        return this.currentContentData;
    }

    public void resetContent(ContentData data) {
        --this.recursionDepth;
        this.currentContentData = data;
    }

    public ContentData getContentData() {
        return this.currentContentData;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public RequestProgressTracker getRequestProgressTracker() {
        return this.requestProgressTracker;
    }

    public int getPeakRecusionDepth() {
        return this.peakRecusionDepth;
    }

    public int getServletCallCount() {
        return this.servletCallCounter;
    }

    private boolean hasServletMaxCallCount(ServletRequest request) {
        this.log.debug("Servlet call counter : {}", (Object)this.getServletCallCount());
        int maxCallCounter = RequestData.getMaxCallCounter();
        Object reqMaxOverride = request.getAttribute(REQUEST_MAX_CALL_OVERRIDE);
        if (reqMaxOverride instanceof Number) {
            maxCallCounter = ((Number)reqMaxOverride).intValue();
        }
        return maxCallCounter >= 0 && this.getServletCallCount() >= maxCallCounter;
    }

    public long getElapsedTimeMsec() {
        return System.currentTimeMillis() - this.startTimestamp;
    }

    public String setActiveServletName(String servletName) {
        String old = this.activeServletName;
        this.activeServletName = servletName;
        return old;
    }

    public String getActiveServletName() {
        return this.activeServletName;
    }

    public <Type> Type adaptTo(Object object, Class<Type> type) {
        return SLING_MAIN_SERVLET.adaptTo(object, type);
    }

    public String getMimeType(String fileName) {
        return SLING_MAIN_SERVLET.getMimeType(fileName);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getReader();
    }

    public ParameterSupport getParameterSupport() {
        if (this.parameterSupport == null) {
            this.parameterSupport = ParameterSupport.getInstance(this.getServletRequest());
        }
        return this.parameterSupport;
    }

    private static SlingHttpServletRequestFactory getSlingHttpServletRequestFactory() {
        SlingHttpServletRequestFactory factory = REQUEST_FACTORY;
        if (factory == null) {
            REQUEST_FACTORY = factory = new SlingHttpServletRequestFactory(){

                @Override
                public SlingHttpServletRequest createRequest(RequestData requestData, HttpServletRequest request) {
                    return new SlingHttpServletRequestImpl(requestData, request);
                }
            };
        }
        return factory;
    }

    private static interface SlingHttpServletRequestFactory {
        public SlingHttpServletRequest createRequest(RequestData var1, HttpServletRequest var2);
    }
}

