/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.engine.impl.log.RequestLoggerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(metatype=true, label="%request.log.name", description="%request.log.description")
@Properties(value={@Property(name="service.description", value={"Request Logger"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class RequestLogger {
    @Property(value={"logs/request.log"})
    public static final String PROP_REQUEST_LOG_OUTPUT = "request.log.output";
    @Property(intValue={0}, options={@PropertyOption(name="0", value="Logger Name"), @PropertyOption(name="1", value="File Name"), @PropertyOption(name="2", value="RequestLog Service")})
    public static final String PROP_REQUEST_LOG_OUTPUT_TYPE = "request.log.outputtype";
    @Property(boolValue={true})
    public static final String PROP_REQUEST_LOG_ENABLED = "request.log.enabled";
    @Property(value={"logs/access.log"})
    public static final String PROP_ACCESS_LOG_OUTPUT = "access.log.output";
    @Property(intValue={0}, options={@PropertyOption(name="0", value="Logger Name"), @PropertyOption(name="1", value="File Name"), @PropertyOption(name="2", value="RequestLog Service")})
    public static final String PROP_ACCESS_LOG_OUTPUT_TYPE = "access.log.outputtype";
    @Property(boolValue={true})
    public static final String PROP_ACCESS_LOG_ENABLED = "access.log.enabled";
    private static final String REQUEST_LOG_ENTRY_FORMAT = "%t [%R] -> %m %U%q %H";
    private static final String REQUEST_LOG_EXIT_FORMAT = "%{end}t [%R] <- %s %{Content-Type}o %Dms";
    private static final String ACCESS_LOG_FORMAT = "%a %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
    private Map<ServiceRegistration, RequestLoggerService> services = new HashMap<ServiceRegistration, RequestLoggerService>();

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> props) {
        String requestLogName = PropertiesUtil.toString((Object)props.get(PROP_REQUEST_LOG_OUTPUT), null);
        boolean requestLogEnabled = PropertiesUtil.toBoolean((Object)props.get(PROP_REQUEST_LOG_ENABLED), (boolean)false);
        if (requestLogName != null && requestLogEnabled) {
            int requestLogType = PropertiesUtil.toInteger((Object)props.get(PROP_REQUEST_LOG_OUTPUT_TYPE), (int)0);
            RequestLogger.createRequestLoggerService(this.services, bundleContext, true, REQUEST_LOG_ENTRY_FORMAT, requestLogName, requestLogType);
            RequestLogger.createRequestLoggerService(this.services, bundleContext, false, REQUEST_LOG_EXIT_FORMAT, requestLogName, requestLogType);
        }
        String accessLogName = PropertiesUtil.toString((Object)props.get(PROP_ACCESS_LOG_OUTPUT), null);
        boolean accessLogEnabled = PropertiesUtil.toBoolean((Object)props.get(PROP_ACCESS_LOG_ENABLED), (boolean)false);
        if (accessLogName != null && accessLogEnabled) {
            int accessLogType = PropertiesUtil.toInteger((Object)props.get(PROP_ACCESS_LOG_OUTPUT_TYPE), (int)0);
            RequestLogger.createRequestLoggerService(this.services, bundleContext, false, ACCESS_LOG_FORMAT, accessLogName, accessLogType);
        }
    }

    @Deactivate
    protected void deactivate() {
        for (Map.Entry<ServiceRegistration, RequestLoggerService> entry : this.services.entrySet()) {
            entry.getKey().unregister();
            entry.getValue().shutdown();
        }
        this.services.clear();
    }

    private static void createRequestLoggerService(Map<ServiceRegistration, RequestLoggerService> services, BundleContext bundleContext, boolean onEntry, Object format, String output, Object outputType) {
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        config.put("request.log.service.onentry", onEntry ? Boolean.TRUE : Boolean.FALSE);
        config.put("request.log.service.format", format);
        config.put("request.log.service.output", output);
        config.put("request.log.service.outputtype", outputType);
        RequestLoggerService service = new RequestLoggerService(bundleContext, config);
        ServiceRegistration reg = bundleContext.registerService(service.getClass().getName(), (Object)service, config);
        services.put(reg, service);
    }
}

