/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.engine.impl.RequestProcessorMBeanImpl;
import org.apache.sling.engine.impl.SlingHttpContext;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.WebConsoleConfigPrinter;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.apache.sling.engine.impl.helper.ClientAbortException;
import org.apache.sling.engine.impl.helper.RequestListenerManager;
import org.apache.sling.engine.impl.helper.SlingServletContext;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.RequestHistoryConsolePlugin;
import org.apache.sling.engine.jmx.RequestProcessorMBean;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.http.context.ServletContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="%sling.name", description="%sling.description")
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Sling Servlet"})})
@References(value={@Reference(name="ErrorHandler", referenceInterface=ErrorHandler.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, bind="setErrorHandler", unbind="unsetErrorHandler"), @Reference(name="ServletResolver", referenceInterface=ServletResolver.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, bind="setServletResolver", unbind="unsetServletResolver"), @Reference(name="MimeTypeService", referenceInterface=MimeTypeService.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, bind="setMimeTypeService", unbind="unsetMimeTypeService"), @Reference(name="AuthenticationSupport", referenceInterface=AuthenticationSupport.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, bind="setAuthenticationSupport", unbind="unsetAuthenticationSupport")})
public class SlingMainServlet
extends GenericServlet {
    @Property(intValue={1000})
    public static final String PROP_MAX_CALL_COUNTER = "sling.max.calls";
    @Property(intValue={50})
    public static final String PROP_MAX_INCLUSION_COUNTER = "sling.max.inclusions";
    public static final boolean DEFAULT_ALLOW_TRACE = false;
    @Property(boolValue={false})
    public static final String PROP_ALLOW_TRACE = "sling.trace.allow";
    @Property(intValue={20})
    private static final String PROP_MAX_RECORD_REQUESTS = "sling.max.record.requests";
    @Property(unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_TRACK_PATTERNS_REQUESTS = "sling.store.pattern.requests";
    private static final String PROP_DEFAULT_PARAMETER_ENCODING = "sling.default.parameter.encoding";
    @Property
    private static final String PROP_SERVER_INFO = "sling.serverinfo";
    @Property(value={"X-Content-Type-Options=nosniff", "X-Frame-Options=SAMEORIGIN"}, label="Additional response headers", description="Provides mappings for additional response headers Each entry is of the form 'bundleId [ \":\" responseHeaderName ] \"=\" responseHeaderValue' ", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_ADDITIONAL_RESPONSE_HEADERS = "sling.additional.response.headers";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile AdapterManager adapterManager;
    private final Logger log = LoggerFactory.getLogger(SlingMainServlet.class);
    private static final String SLING_ROOT = "/";
    public static final String SERVLET_CONTEXT_NAME = "org.apache.sling";
    static String PRODUCT_NAME = "ApacheSling";
    private SlingServletContext slingServletContext;
    private String productInfo = PRODUCT_NAME;
    private String serverInfo = PRODUCT_NAME;
    private RequestListenerManager requestListenerManager;
    private boolean allowTrace = false;
    private Object printerRegistration;
    private SlingHttpContext slingHttpContext = new SlingHttpContext();
    private ServletFilterManager filterManager;
    private final SlingRequestProcessorImpl requestProcessor = new SlingRequestProcessorImpl();
    private ServiceRegistration<SlingRequestProcessor> requestProcessorRegistration;
    private ServiceRegistration<RequestProcessorMBean> requestProcessorMBeanRegistration;
    private ServiceRegistration<ServletContextHelper> contextRegistration;
    private ServiceRegistration<Servlet> servletRegistration;
    private String configuredServerInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            String threadName = this.setThreadName(request);
            this.requestListenerManager.sendEvent(request, SlingRequestEvent.EventType.EVENT_INIT);
            ResourceResolver resolver = null;
            try {
                if (!this.allowTrace && "TRACE".equals(request.getMethod())) {
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.setStatus(405);
                    response.setHeader("Allow", "GET, HEAD, POST, PUT, DELETE, OPTIONS");
                    return;
                }
                Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
                resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
                this.requestProcessor.doProcessRequest(request, (HttpServletResponse)res, resolver);
            }
            catch (ClientAbortException cae) {
                this.log.debug("service: ClientAbortException, probable cause is client aborted request or network problem", (Throwable)cae);
            }
            catch (Throwable t) {
                this.log.error("service: Uncaught Problem handling the request", t);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
                this.requestListenerManager.sendEvent(request, SlingRequestEvent.EventType.EVENT_DESTROY);
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
            }
        } else {
            throw new ServletException("Apache Sling must be run in an HTTP servlet environment.");
        }
    }

    private void setProductInfo(BundleContext bundleContext) {
        Dictionary props = bundleContext.getBundle().getHeaders();
        Version bundleVersion = Version.parseVersion((String)((String)props.get("Bundle-Version")));
        String productVersion = bundleVersion.getMajor() + "." + bundleVersion.getMinor();
        this.productInfo = PRODUCT_NAME + SLING_ROOT + productVersion;
        this.setServerInfo();
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    private void setServerInfo() {
        if (this.configuredServerInfo != null) {
            this.serverInfo = this.configuredServerInfo;
        } else {
            String containerProductInfo;
            if (this.getServletConfig() == null || this.getServletContext() == null) {
                containerProductInfo = "unregistered";
            } else {
                String containerInfo = this.getServletContext().getServerInfo();
                if (containerInfo != null && containerInfo.length() > 0) {
                    int lbrace = containerInfo.indexOf(40);
                    if (lbrace < 0) {
                        lbrace = containerInfo.length();
                    }
                    containerProductInfo = containerInfo.substring(0, lbrace).trim();
                } else {
                    containerProductInfo = "unknown";
                }
            }
            this.serverInfo = String.format("%s (%s, %s %s, %s %s %s)", this.productInfo, containerProductInfo, System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        }
        if (this.requestProcessor != null) {
            this.requestProcessor.setServerInfo(this.serverInfo);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> componentConfig) {
        String[] props = PropertiesUtil.toStringArray((Object)componentConfig.get(PROP_ADDITIONAL_RESPONSE_HEADERS));
        ArrayList<StaticResponseHeader> mappings = new ArrayList<StaticResponseHeader>(props.length);
        for (String prop : props) {
            if (prop == null || prop.trim().length() <= 0) continue;
            try {
                StaticResponseHeader mapping = new StaticResponseHeader(prop.trim());
                mappings.add(mapping);
            }
            catch (IllegalArgumentException iae) {
                this.log.info("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
            }
        }
        RequestData.setAdditionalResponseHeaders(mappings);
        this.configuredServerInfo = PropertiesUtil.toString((Object)componentConfig.get(PROP_SERVER_INFO), null);
        this.setProductInfo(bundleContext);
        Hashtable<String, Object> configuration = new Hashtable<String, Object>(componentConfig);
        if (!(configuration.get("servlet-name") instanceof String)) {
            configuration.put("servlet-name", this.productInfo);
        }
        this.allowTrace = PropertiesUtil.toBoolean((Object)componentConfig.get(PROP_ALLOW_TRACE), (boolean)false);
        RequestData.setMaxIncludeCounter(PropertiesUtil.toInteger((Object)componentConfig.get(PROP_MAX_INCLUSION_COUNTER), (int)50));
        RequestData.setMaxCallCounter(PropertiesUtil.toInteger((Object)componentConfig.get(PROP_MAX_CALL_COUNTER), (int)1000));
        RequestData.setSlingMainServlet(this);
        if (componentConfig.get(PROP_DEFAULT_PARAMETER_ENCODING) != null) {
            this.log.warn("Please configure the default request parameter encoding using the 'org.apache.sling.engine.parameters' configuration PID; the property sling.default.parameter.encoding=" + componentConfig.get(PROP_DEFAULT_PARAMETER_ENCODING) + " is obsolete and ignored");
        }
        Hashtable<String, String> contextProperties = new Hashtable<String, String>();
        ((Dictionary)contextProperties).put("osgi.http.whiteboard.context.name", SERVLET_CONTEXT_NAME);
        ((Dictionary)contextProperties).put("osgi.http.whiteboard.context.path", SLING_ROOT);
        ((Dictionary)contextProperties).put("service.description", "Apache Sling Engine Servlet Context Helper");
        ((Dictionary)contextProperties).put("service.vendor", "The Apache Software Foundation");
        this.contextRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)this.slingHttpContext, contextProperties);
        Dictionary<String, String> servletConfig = this.toStringConfig(configuration);
        servletConfig.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.apache.sling)");
        servletConfig.put("osgi.http.whiteboard.servlet.pattern", SLING_ROOT);
        servletConfig.put("service.description", "Apache Sling Engine Main Servlet");
        servletConfig.put("service.vendor", "The Apache Software Foundation");
        this.servletRegistration = bundleContext.registerService(Servlet.class, (Object)this, servletConfig);
        this.log.info("{} ready to serve requests", (Object)this.getServerInfo());
        this.slingServletContext = new SlingServletContext(bundleContext, this);
        this.filterManager = new ServletFilterManager(bundleContext, this.slingServletContext);
        this.filterManager.open();
        this.requestProcessor.setFilterManager(this.filterManager);
        this.requestListenerManager = new RequestListenerManager(bundleContext, this.slingServletContext);
        this.printerRegistration = WebConsoleConfigPrinter.register(bundleContext, this.filterManager);
        try {
            int maxRequests = PropertiesUtil.toInteger((Object)componentConfig.get(PROP_MAX_RECORD_REQUESTS), (int)20);
            String[] patterns = PropertiesUtil.toStringArray((Object)componentConfig.get(PROP_TRACK_PATTERNS_REQUESTS), (String[])new String[0]);
            ArrayList<Pattern> compiledPatterns = new ArrayList<Pattern>(patterns.length);
            for (String pattern : patterns) {
                if (pattern == null || pattern.trim().length() <= 0) continue;
                compiledPatterns.add(Pattern.compile(pattern));
            }
            RequestHistoryConsolePlugin.initPlugin(bundleContext, maxRequests, compiledPatterns);
        }
        catch (Throwable t) {
            this.log.debug("Unable to register web console request recorder plugin.", t);
        }
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
            ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=engine,service=RequestProcessor");
            RequestProcessorMBeanImpl mbean = new RequestProcessorMBeanImpl();
            this.requestProcessorMBeanRegistration = bundleContext.registerService(RequestProcessorMBean.class, (Object)mbean, mbeanProps);
            this.requestProcessor.setMBean(mbean);
        }
        catch (Throwable t) {
            this.log.debug("Unable to register mbean");
        }
        Hashtable<String, String> srpProps = new Hashtable<String, String>();
        srpProps.put("service.vendor", "The Apache Software Foundation");
        srpProps.put("service.description", "Sling Request Processor");
        this.requestProcessorRegistration = bundleContext.registerService(SlingRequestProcessor.class, (Object)this.requestProcessor, srpProps);
    }

    public void init() {
        this.setServerInfo();
    }

    @Deactivate
    protected void deactivate() {
        if (this.requestProcessorRegistration != null) {
            this.requestProcessorRegistration.unregister();
            this.requestProcessorRegistration = null;
        }
        if (this.requestProcessorMBeanRegistration != null) {
            this.requestProcessorMBeanRegistration.unregister();
            this.requestProcessorMBeanRegistration = null;
        }
        try {
            RequestHistoryConsolePlugin.destroyPlugin();
        }
        catch (Throwable t) {
            this.log.debug("Problem unregistering web console request recorder plugin.", t);
        }
        if (this.printerRegistration != null) {
            WebConsoleConfigPrinter.unregister(this.printerRegistration);
            this.printerRegistration = null;
        }
        if (this.filterManager != null) {
            this.requestProcessor.setFilterManager(null);
            this.filterManager.close();
        }
        if (this.contextRegistration != null) {
            this.contextRegistration.unregister();
            this.contextRegistration = null;
        }
        if (this.slingServletContext != null) {
            this.slingServletContext.dispose();
            this.slingServletContext = null;
        }
        if (this.servletRegistration != null) {
            this.servletRegistration.unregister();
            this.servletRegistration = null;
        }
        if (this.requestListenerManager != null) {
            this.requestListenerManager.dispose();
            this.requestListenerManager = null;
        }
        RequestData.setSlingMainServlet(null);
        this.log.info(this.getServerInfo() + " shut down");
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.setErrorHandler(errorHandler);
    }

    void unsetErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.unsetErrorHandler(errorHandler);
    }

    public void setServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.setServletResolver(servletResolver);
    }

    public void unsetServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.unsetServletResolver(servletResolver);
    }

    public void setMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.setMimeTypeService(mimeTypeService);
    }

    public void unsetMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.unsetMimeTypeService(mimeTypeService);
    }

    public void setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.setAuthenticationSupport(authenticationSupport);
    }

    public void unsetAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.unsetAuthenticationSupport(authenticationSupport);
    }

    private Dictionary<String, String> toStringConfig(Dictionary<?, ?> config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration<?> ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    public String getMimeType(String name) {
        return this.slingHttpContext.getMimeType(name);
    }

    public <Type> Type adaptTo(Object object, Class<Type> type) {
        AdapterManager adapterManager = this.adapterManager;
        if (adapterManager != null) {
            return (Type)adapterManager.getAdapter(object, type);
        }
        return null;
    }

    private String setThreadName(HttpServletRequest request) {
        Thread thread = Thread.currentThread();
        String oldThreadName = thread.getName();
        StringBuilder buf = new StringBuilder();
        buf.append(request.getRemoteAddr());
        buf.append(" [").append(System.currentTimeMillis()).append("] ");
        buf.append(request.getMethod()).append(' ');
        buf.append(request.getRequestURI()).append(' ');
        buf.append(request.getProtocol());
        thread.setName(buf.toString());
        return oldThreadName;
    }

    protected void bindAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    protected void unbindAdapterManager(AdapterManager adapterManager) {
        if (this.adapterManager == adapterManager) {
            this.adapterManager = null;
        }
    }
}

