/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.engine.impl.filter.FilterProcessorMBeanImpl;

public class FilterHandle
implements Comparable<FilterHandle> {
    private final Filter filter;
    private final Pattern regex;
    private final Long filterId;
    private final int order;
    private final String orderSource;
    private AtomicLong calls;
    private AtomicLong time;
    FilterProcessorMBeanImpl mbean;

    FilterHandle(Filter filter, String pattern, Long filterId, int order, String orderSource, FilterProcessorMBeanImpl mbean) {
        this.filter = filter;
        this.regex = pattern != null && pattern.length() > 0 ? Pattern.compile(pattern) : null;
        this.filterId = filterId;
        this.order = order;
        this.orderSource = orderSource;
        this.calls = new AtomicLong();
        this.time = new AtomicLong();
        this.mbean = mbean;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public int getOrder() {
        return this.order;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    boolean select(SlingHttpServletRequest slingHttpServletRequest) {
        boolean select = true;
        if (this.regex != null) {
            String uri = slingHttpServletRequest.getPathInfo();
            if (uri == null) {
                uri = "/";
            }
            select = this.regex.matcher(uri).matches();
        }
        return select;
    }

    public long getCalls() {
        return this.calls.get();
    }

    public long getTime() {
        return this.time.get();
    }

    public long getTimePerCall() {
        return this.getCalls() > 0L ? 1000L * this.getTime() / this.getCalls() : -1L;
    }

    void track() {
        this.calls.incrementAndGet();
    }

    void trackTime(long time) {
        this.time.addAndGet(time);
        if (this.mbean != null) {
            this.mbean.addFilterHandle(this);
        }
    }

    @Override
    public int compareTo(FilterHandle other) {
        int comp;
        if (this == other || this.equals(other)) {
            return 0;
        }
        if (this.order > other.order) {
            return -1;
        }
        if (this.order < other.order) {
            return 1;
        }
        if (this.filterId != null && other.filterId != null && (comp = this.filterId.compareTo(other.filterId)) != 0) {
            return comp;
        }
        return 0;
    }

    public int hashCode() {
        if (this.filter == null) {
            return 0;
        }
        return this.filter.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilterHandle) {
            FilterHandle other = (FilterHandle)obj;
            return this.getFilter().equals(other.getFilter());
        }
        return false;
    }
}

