/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.FilterProcessorMBeanImpl;
import org.apache.sling.engine.impl.filter.SlingFilterChainHelper;
import org.apache.sling.engine.impl.helper.SlingFilterConfig;
import org.apache.sling.engine.impl.helper.SlingServletContext;
import org.apache.sling.engine.jmx.FilterProcessorMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletFilterManager
extends ServiceTracker<Filter, Filter> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SlingServletContext servletContext;
    private final SlingFilterChainHelper[] filterChains;
    private Map<Long, ServiceRegistration<FilterProcessorMBean>> mbeanMap;

    public ServletFilterManager(BundleContext context, SlingServletContext servletContext) {
        super(context, Filter.class, null);
        this.servletContext = servletContext;
        this.filterChains = new SlingFilterChainHelper[FilterChainType.values().length];
        this.filterChains[FilterChainType.REQUEST.ordinal()] = new SlingFilterChainHelper();
        this.filterChains[FilterChainType.ERROR.ordinal()] = new SlingFilterChainHelper();
        this.filterChains[FilterChainType.INCLUDE.ordinal()] = new SlingFilterChainHelper();
        this.filterChains[FilterChainType.FORWARD.ordinal()] = new SlingFilterChainHelper();
        this.filterChains[FilterChainType.COMPONENT.ordinal()] = new SlingFilterChainHelper();
        this.mbeanMap = new HashMap<Long, ServiceRegistration<FilterProcessorMBean>>();
    }

    public SlingFilterChainHelper getFilterChain(FilterChainType chain) {
        return this.filterChains[chain.ordinal()];
    }

    public FilterHandle[] getFilters(FilterChainType chain) {
        return this.getFilterChain(chain).getFilters();
    }

    public Filter addingService(ServiceReference<Filter> reference) {
        if (this.excludeFilter(reference)) {
            return null;
        }
        Filter service = (Filter)super.addingService(reference);
        if (service != null) {
            this.initFilter(reference, service);
        }
        return service;
    }

    public void modifiedService(ServiceReference<Filter> reference, Filter service) {
        this.destroyFilter(reference, service);
        if (!this.excludeFilter(reference)) {
            this.initFilter(reference, service);
        }
    }

    public void removedService(ServiceReference<Filter> reference, Filter service) {
        if (service != null) {
            this.destroyFilter(reference, service);
            super.removedService(reference, (Object)service);
        }
    }

    private boolean excludeFilter(ServiceReference<Filter> reference) {
        String filterName;
        boolean exclude = true;
        if (reference.getProperty("sling.filter.scope") != null || reference.getProperty("filter.scope") != null) {
            exclude = false;
        }
        if (!exclude && (filterName = SlingFilterConfig.getName(reference)) == null) {
            this.log.error("initFilter: Missing name for filter {}", reference);
            exclude = true;
        }
        return exclude;
    }

    private void initFilter(ServiceReference<Filter> reference, Filter filter) {
        String filterName = SlingFilterConfig.getName(reference);
        try {
            String orderSource;
            FilterProcessorMBeanImpl mbean;
            Long serviceId = (Long)reference.getProperty("service.id");
            try {
                Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
                ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=engine-filter,service=" + filterName);
                mbean = new FilterProcessorMBeanImpl();
                ServiceRegistration filterProcessorMBeanRegistration = this.context.registerService(FilterProcessorMBean.class, (Object)mbean, mbeanProps);
                this.mbeanMap.put(serviceId, (ServiceRegistration<FilterProcessorMBean>)filterProcessorMBeanRegistration);
            }
            catch (Throwable t) {
                this.log.debug("Unable to register mbean", t);
                mbean = null;
            }
            SlingFilterConfig config = new SlingFilterConfig(this.servletContext, reference, filterName);
            filter.init((FilterConfig)config);
            Object orderObj = reference.getProperty("service.ranking");
            if (orderObj == null) {
                orderObj = reference.getProperty("filter.order");
                if (orderObj != null) {
                    this.log.warn("Filter service {} is using deprecated property {}. Use {} instead.", new Object[]{reference, "filter.order", "service.ranking"});
                    orderSource = "filter.order=" + orderObj;
                    orderObj = -1 * OsgiUtil.toInteger((Object)orderObj, (int)0);
                } else {
                    orderSource = "none";
                }
            } else {
                orderSource = "service.ranking=" + orderObj;
            }
            int order = orderObj instanceof Integer ? (Integer)orderObj : 0;
            String[] scopes = OsgiUtil.toStringArray((Object)reference.getProperty("sling.filter.scope"), null);
            String pattern = OsgiUtil.toString((Object)reference.getProperty("sling.filter.pattern"), (String)"");
            if (scopes == null) {
                scopes = OsgiUtil.toStringArray((Object)reference.getProperty("filter.scope"), null);
                this.log.warn("Filter service {} is using deprecated property {}. Use {} instead.", new Object[]{reference, "filter.scope", "sling.filter.scope"});
            }
            if (scopes != null && scopes.length > 0) {
                for (String scope : scopes) {
                    scope = scope.toUpperCase();
                    try {
                        FilterChainType type = FilterChainType.valueOf(scope.toString());
                        this.getFilterChain(type).addFilter(filter, pattern, serviceId, order, orderSource, mbean);
                        if (type != FilterChainType.COMPONENT) continue;
                        this.getFilterChain(FilterChainType.INCLUDE).addFilter(filter, pattern, serviceId, order, orderSource, mbean);
                        this.getFilterChain(FilterChainType.FORWARD).addFilter(filter, pattern, serviceId, order, orderSource, mbean);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            } else {
                this.log.warn(String.format("A Filter (Service ID %s) has been registered without a filter.scope property.", reference.getProperty("service.id")));
                this.getFilterChain(FilterChainType.REQUEST).addFilter(filter, pattern, serviceId, order, orderSource, mbean);
            }
        }
        catch (ServletException ce) {
            this.log.error("Filter " + filterName + " failed to initialize", (Throwable)ce);
        }
        catch (Throwable t) {
            this.log.error("Unexpected Problem initializing ComponentFilter ", t);
        }
    }

    private void destroyFilter(ServiceReference<Filter> reference, Filter filter) {
        Object serviceId = reference.getProperty("service.id");
        ServiceRegistration<FilterProcessorMBean> mbean = this.mbeanMap.remove(serviceId);
        if (mbean != null) {
            mbean.unregister();
        }
        boolean removed = false;
        for (SlingFilterChainHelper filterChain : this.filterChains) {
            removed |= filterChain.removeFilterById(serviceId);
        }
        if (removed) {
            try {
                filter.destroy();
            }
            catch (Throwable t) {
                this.log.error("Unexpected problem destroying Filter {}", (Object)filter, (Object)t);
            }
        }
    }

    public static enum FilterChainType {
        REQUEST("Request"),
        ERROR("Error"),
        INCLUDE("Include"),
        FORWARD("Forward"),
        COMPONENT("Component");

        private final String message;

        private FilterChainType(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

