/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.JobProcessor;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;
import org.apache.sling.event.impl.JobEventHandler;
import org.osgi.service.event.Event;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventUtil {
    public static final String PROPERTY_DISTRIBUTE = "event.distribute";
    public static final String PROPERTY_APPLICATION = "event.application";
    public static final String PROPERTY_JOB_TOPIC = "event.job.topic";
    public static final String PROPERTY_JOB_ID = "event.job.id";
    public static final String PROPERTY_JOB_PARALLEL = "event.job.parallel";
    public static final String PROPERTY_JOB_RUN_LOCAL = "event.job.run.local";
    public static final String PROPERTY_JOB_RETRY_COUNT = "event.job.retrycount";
    public static final String PROPERTY_JOB_RETRIES = "event.job.retries";
    public static final String PROPERTY_JOB_RETRY_DELAY = "event.job.retrydelay";
    public static final String PROPERTY_JOB_QUEUE_NAME = "event.job.queuename";
    public static final String PROPERTY_JOB_QUEUE_ORDERED = "event.job.queueordered";
    public static final String TOPIC_JOB = "org/apache/sling/event/job";
    public static final String TOPIC_TIMED_EVENT = "org/apache/sling/event/timed";
    public static final String PROPERTY_TIMED_EVENT_TOPIC = "event.topic.timed";
    public static final String PROPERTY_TIMED_EVENT_ID = "event.timed.id";
    public static final String PROPERTY_TIMED_EVENT_SCHEDULE = "event.timed.scheduler";
    public static final String PROPERTY_TIMED_EVENT_PERIOD = "event.timed.period";
    public static final String PROPERTY_TIMED_EVENT_DATE = "event.timed.date";

    public static Event createDistributableEvent(String topic, Dictionary<String, Object> properties) {
        Hashtable<String, Object> newProperties = new Hashtable<String, Object>();
        if (properties != null) {
            Enumeration<String> e = properties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                ((Dictionary)newProperties).put(key, properties.get(key));
            }
        }
        ((Dictionary)newProperties).put(PROPERTY_DISTRIBUTE, "");
        return new Event(topic, newProperties);
    }

    public static boolean shouldDistribute(Event event) {
        return event.getProperty(PROPERTY_DISTRIBUTE) != null;
    }

    public static boolean isLocal(Event event) {
        String appId = EventUtil.getApplicationId(event);
        return appId == null || appId.equals(AbstractRepositoryEventHandler.APPLICATION_ID);
    }

    public static String getApplicationId(Event event) {
        return (String)event.getProperty(PROPERTY_APPLICATION);
    }

    public static boolean isJobEvent(Event event) {
        return event.getProperty(PROPERTY_JOB_TOPIC) != null;
    }

    private static JobStatusNotifier.NotifierContext getNotifierContext(Event job) {
        if (!EventUtil.isJobEvent(job)) {
            return null;
        }
        JobStatusNotifier.NotifierContext ctx = (JobStatusNotifier.NotifierContext)job.getProperty(JobStatusNotifier.CONTEXT_PROPERTY_NAME);
        if (ctx == null) {
            throw new IllegalArgumentException("JobStatusNotifier context is not available in event properties.");
        }
        return ctx;
    }

    public static void finishedJob(Event job) {
        JobStatusNotifier.NotifierContext ctx = EventUtil.getNotifierContext(job);
        if (ctx != null) {
            ctx.notifier.finishedJob(job, ctx.eventNodePath, false);
        }
    }

    public static boolean rescheduleJob(Event job) {
        JobStatusNotifier.NotifierContext ctx = EventUtil.getNotifierContext(job);
        if (ctx != null) {
            return ctx.notifier.finishedJob(job, ctx.eventNodePath, true);
        }
        return false;
    }

    public static void processJob(final Event job, final JobProcessor processor) {
        boolean notify = true;
        JobStatusNotifier.NotifierContext ctx = EventUtil.getNotifierContext(job);
        if (ctx != null && !ctx.notifier.sendAcknowledge(job, ctx.eventNodePath)) {
            LoggerFactory.getLogger(EventUtil.class).info("Someone else is already processing job {}.", (Object)job);
            notify = false;
        }
        final boolean notifyResult = notify;
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block7: {
                    boolean result = false;
                    try {
                        try {
                            result = processor.process(job);
                        }
                        catch (Throwable t) {
                            LoggerFactory.getLogger(EventUtil.class).error("Unhandled error occured in job processor " + t.getMessage() + " while processing job " + job, t);
                            result = true;
                            Object var4_3 = null;
                            if (!notifyResult) return;
                            if (result) {
                                EventUtil.finishedJob(job);
                                return;
                            }
                            EventUtil.rescheduleJob(job);
                            return;
                        }
                        Object var4_2 = null;
                        if (!notifyResult) return;
                        if (!result) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (!notifyResult) throw throwable;
                        if (result) {
                            EventUtil.finishedJob(job);
                            throw throwable;
                        }
                        EventUtil.rescheduleJob(job);
                        throw throwable;
                    }
                    EventUtil.finishedJob(job);
                    return;
                }
                EventUtil.rescheduleJob(job);
            }
        };
        if (JobEventHandler.JOB_THREAD_POOL != null) {
            JobEventHandler.JOB_THREAD_POOL.execute(task);
        } else {
            new Thread(task).start();
        }
    }

    @Deprecated
    public static void addProperties(Node node, Map<String, Object> properties, String[] ignoreProps, String binPropertyName) throws RepositoryException {
        EventUtil.addProperties(node, new EventPropertiesMap(properties), ignoreProps, binPropertyName);
    }

    @Deprecated
    public static void addProperties(Node node, EventPropertiesMap properties, String[] ignoreProps, String binPropertyName) throws RepositoryException {
        if (properties != null) {
            List<String> ignorePropList = ignoreProps == null ? null : Arrays.asList(ignoreProps);
            ArrayList<String> propsAsBlob = new ArrayList<String>();
            for (Map.Entry<String, Object> current : properties.entrySet()) {
                if (ignorePropList != null && ignorePropList.contains(current.getKey()) || current.getValue() == null || EventUtil.setProperty(current.getKey(), current.getValue(), node)) continue;
                propsAsBlob.add(current.getKey());
            }
            if (propsAsBlob.size() > 0) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeInt(propsAsBlob.size());
                    for (String propName : propsAsBlob) {
                        oos.writeObject(propName);
                        try {
                            oos.writeObject(properties.get(propName));
                        }
                        catch (IOException ioe) {
                            throw new RepositoryException("Unable to serialize property " + propName, (Throwable)ioe);
                        }
                    }
                    oos.close();
                    node.setProperty(binPropertyName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                }
                catch (IOException ioe) {
                    throw new RepositoryException("Unable to serialize properties " + properties, (Throwable)ioe);
                }
            }
        }
    }

    @Deprecated
    public static EventPropertiesMap readProperties(Node node, String binPropertyName, String[] ignorePrefixes) throws RepositoryException, ClassNotFoundException {
        Object value;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (node.hasProperty(binPropertyName)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(node.getProperty(binPropertyName).getStream(), Thread.currentThread().getContextClassLoader());
                int length = ois.readInt();
                for (int i = 0; i < length; ++i) {
                    String key = (String)ois.readObject();
                    value = ois.readObject();
                    properties.put(key, value);
                }
            }
            catch (InvalidClassException ice) {
                throw new ClassNotFoundException("Found invalid class.", ice);
            }
            catch (IOException ioe) {
                throw new RepositoryException("Unable to deserialize event properties.", (Throwable)ioe);
            }
        }
        PropertyIterator pI = node.getProperties();
        while (pI.hasNext()) {
            Property p = pI.nextProperty();
            boolean ignore = p.getName().startsWith("jcr:");
            if (!ignore && ignorePrefixes != null) {
                for (int index = 0; !ignore && index < ignorePrefixes.length; ++index) {
                    ignore = p.getName().startsWith(ignorePrefixes[index]);
                }
            }
            if (ignore) continue;
            String name = ISO9075.decode(p.getName());
            if (p.getDefinition().isMultiple()) {
                Value[] values = p.getValues();
                if (values.length <= 0) continue;
                Object firstObject = EventUtil.getPropertyValue(values[0]);
                Object[] array = firstObject instanceof Boolean ? new Boolean[values.length] : (firstObject instanceof Calendar ? new Calendar[values.length] : (firstObject instanceof Double ? new Double[values.length] : (firstObject instanceof Long ? new Long[values.length] : new String[values.length])));
                array[0] = firstObject;
                for (int index = 1; index < values.length; ++index) {
                    array[index] = EventUtil.getPropertyValue(values[index]);
                }
                properties.put(name, array);
                continue;
            }
            value = p.getValue();
            Object o = EventUtil.getPropertyValue((Value)value);
            properties.put(name, o);
        }
        return new EventPropertiesMap(properties);
    }

    @Deprecated
    public static String getNodePropertyName(String name) {
        if (name.indexOf(58) != -1) {
            return null;
        }
        return ISO9075.encode(name);
    }

    @Deprecated
    public static Value getNodePropertyValue(ValueFactory valueFactory, Object eventValue) {
        Object val = eventValue instanceof Calendar ? valueFactory.createValue((Calendar)eventValue) : (eventValue instanceof Long ? valueFactory.createValue(((Long)eventValue).longValue()) : (eventValue instanceof Double ? valueFactory.createValue(((Double)eventValue).doubleValue()) : (eventValue instanceof Boolean ? valueFactory.createValue(((Boolean)eventValue).booleanValue()) : (eventValue instanceof String ? valueFactory.createValue((String)eventValue) : null))));
        return val;
    }

    @Deprecated
    private static Object getPropertyValue(Value value) throws RepositoryException {
        Object o;
        switch (value.getType()) {
            case 6: {
                o = value.getBoolean();
                break;
            }
            case 5: {
                o = value.getDate();
                break;
            }
            case 4: {
                o = value.getDouble();
                break;
            }
            case 3: {
                o = value.getLong();
                break;
            }
            case 1: {
                o = value.getString();
                break;
            }
            default: {
                o = value.getString();
            }
        }
        return o;
    }

    @Deprecated
    private static boolean setProperty(String name, Object value, Node node) throws RepositoryException {
        String propName = EventUtil.getNodePropertyName(name);
        if (propName == null) {
            return false;
        }
        ValueFactory fac = node.getSession().getValueFactory();
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            Value[] values = new Value[array.length];
            int index = 0;
            for (Object v : array) {
                values[index] = EventUtil.getNodePropertyValue(fac, v);
                if (values[index] == null) {
                    return false;
                }
                if (index > 0 && !values[index - 1].getClass().equals(values[index].getClass())) {
                    return false;
                }
                ++index;
            }
            node.setProperty(propName, values);
            return true;
        }
        Value val = EventUtil.getNodePropertyValue(fac, value);
        if (val != null) {
            node.setProperty(propName, val);
            return true;
        }
        return false;
    }

    public static String toString(Event e) {
        if (e == null) {
            return "<null>";
        }
        StringBuilder buffer = new StringBuilder(e.getClass().getName());
        buffer.append(" [topic=");
        buffer.append(e.getTopic());
        buffer.append(", properties=");
        String[] names = e.getPropertyNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(names[i]);
                buffer.append('=');
                buffer.append(e.getProperty(names[i]));
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectInputStream
    extends java.io.ObjectInputStream {
        private ClassLoader classloader;

        public ObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classloader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.classloader != null) {
                return Class.forName(classDesc.getName(), true, this.classloader);
            }
            return super.resolveClass(classDesc);
        }
    }

    public static interface JobStatusNotifier {
        public static final String CONTEXT_PROPERTY_NAME = JobStatusNotifier.class.getName();

        public boolean sendAcknowledge(Event var1, String var2);

        public boolean finishedJob(Event var1, String var2, boolean var3);

        public static final class NotifierContext {
            public final JobStatusNotifier notifier;
            public final String eventNodePath;

            public NotifierContext(JobStatusNotifier n, String path) {
                this.notifier = n;
                this.eventNodePath = path;
            }
        }
    }
}

