/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.util.Calendar;
import java.util.Dictionary;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.SlingSettingsService;
import org.apache.sling.event.ThreadPool;
import org.apache.sling.event.impl.EventHelper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryEventHandler
implements EventHandler,
EventListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String CONFIG_PROPERTY_REPO_PATH = "repository.path";
    private static final String DEFAULT_PROPERTY_REPO_PATH = "/sling/events";
    protected SlingRepository repository;
    protected EventAdmin eventAdmin;
    protected String applicationId;
    protected Session writerSession;
    protected String repositoryPath;
    protected volatile boolean running;
    protected final BlockingQueue<EventInfo> queue = new LinkedBlockingQueue<EventInfo>();
    protected final BlockingQueue<Event> writeQueue = new LinkedBlockingQueue<Event>();
    protected DynamicClassLoaderManager classLoaderManager;
    protected ThreadPool threadPool;
    protected SlingSettingsService settingsService;
    public static String APPLICATION_ID;

    protected void activate(ComponentContext context) throws Exception {
        APPLICATION_ID = this.applicationId = this.settingsService.getSlingId();
        this.repositoryPath = OsgiUtil.toString(context.getProperties().get(CONFIG_PROPERTY_REPO_PATH), (String)DEFAULT_PROPERTY_REPO_PATH);
        this.running = true;
        this.threadPool.execute(new Runnable(){

            public void run() {
                try {
                    AbstractRepositoryEventHandler.this.startWriterSession();
                }
                catch (RepositoryException e) {
                    AbstractRepositoryEventHandler.this.logger.error("Error during session starting.", (Throwable)e);
                    AbstractRepositoryEventHandler.this.running = false;
                }
                try {
                    AbstractRepositoryEventHandler.this.processWriteQueue();
                }
                catch (Throwable t) {
                    AbstractRepositoryEventHandler.this.logger.error("Writer thread stopped with exception: " + t.getMessage(), t);
                    AbstractRepositoryEventHandler.this.running = false;
                }
                AbstractRepositoryEventHandler.this.stopWriterSession();
            }
        });
        this.threadPool.execute(new Runnable(){

            public void run() {
                try {
                    AbstractRepositoryEventHandler.this.runInBackground();
                }
                catch (Throwable t) {
                    AbstractRepositoryEventHandler.this.logger.error("Background thread stopped with exception: " + t.getMessage(), t);
                    AbstractRepositoryEventHandler.this.running = false;
                }
            }
        });
    }

    protected abstract void runInBackground() throws RepositoryException;

    protected abstract void processWriteQueue();

    protected void deactivate(ComponentContext context) {
        this.running = false;
        try {
            this.writeQueue.put(new Event("some", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        try {
            this.queue.put(new EventInfo());
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
    }

    protected Session createSession() throws RepositoryException {
        SlingRepository repo = this.repository;
        if (repo == null) {
            throw new RepositoryException("Repository is currently not available.");
        }
        return repo.loginAdministrative(null);
    }

    protected void startWriterSession() throws RepositoryException {
        this.writerSession = this.createSession();
        if (this.repositoryPath != null) {
            this.ensureRepositoryPath();
        }
    }

    protected void stopWriterSession() {
        if (this.writerSession != null) {
            try {
                this.writerSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                this.logger.warn("Unable to remove event listener.", (Throwable)e);
            }
            this.writerSession.logout();
            this.writerSession = null;
        }
    }

    protected Node ensureRepositoryPath() throws RepositoryException {
        Node node = JcrResourceUtil.createPath((String)this.repositoryPath, (String)"sling:Folder", (String)"sling:OrderedFolder", (Session)this.writerSession, (boolean)true);
        return node;
    }

    protected String getEventNodeType() {
        return "slingevent:Event";
    }

    protected Node writeEvent(Event e, String suggestedName) throws RepositoryException {
        String nodeName;
        Node rootNode = this.ensureRepositoryPath();
        String nodeType = this.getEventNodeType();
        if (suggestedName != null) {
            nodeName = suggestedName;
        } else {
            Calendar now = Calendar.getInstance();
            int sepPos = nodeType.indexOf(58);
            nodeName = nodeType.substring(sepPos + 1) + "-" + this.applicationId + "-" + now.getTime().getTime();
        }
        Node eventNode = JcrResourceUtil.createPath((Node)rootNode, (String)nodeName, (String)"sling:Folder", (String)nodeType, (boolean)false);
        eventNode.setProperty("slingevent:created", Calendar.getInstance());
        eventNode.setProperty("slingevent:topic", e.getTopic());
        eventNode.setProperty("slingevent:application", this.applicationId);
        EventHelper.writeEventProperties(eventNode, e);
        this.addNodeProperties(eventNode, e);
        rootNode.save();
        return eventNode;
    }

    protected Event readEvent(Node eventNode) throws RepositoryException, ClassNotFoundException {
        String topic = eventNode.getProperty("slingevent:topic").getString();
        Dictionary<String, Object> eventProps = EventHelper.readEventProperties(eventNode, this.classLoaderManager.getDynamicClassLoader());
        eventProps.put("slingevent:eventId", eventNode.getPath());
        this.addEventProperties(eventNode, eventProps);
        try {
            Event event = new Event(topic, eventProps);
            return event;
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("Unable to read event: " + iae.getMessage(), (Throwable)iae);
        }
    }

    protected void addEventProperties(Node eventNode, Dictionary<String, Object> properties) throws RepositoryException {
    }

    protected void addNodeProperties(Node eventNode, Event event) throws RepositoryException {
    }

    protected void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignore exception " + e.getMessage(), (Throwable)e);
        }
    }

    protected void bindThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    protected void unbindThreadPool(ThreadPool threadPool) {
        if (this.threadPool == threadPool) {
            this.threadPool = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.classLoaderManager == dynamicClassLoaderManager) {
            this.classLoaderManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected static final class EventInfo {
        public String nodePath;
        public Event event;

        protected EventInfo() {
        }
    }
}

