/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.event.ThreadPool;
import org.osgi.service.component.ComponentContext;

public class EventingThreadPool
implements ThreadPool {
    protected ThreadPoolManager threadPoolManager;
    private org.apache.sling.commons.threads.ThreadPool threadPool;
    private static final String PROPERTY_MIN_POOL_SIZE = "minPoolSize";
    private static final String PROPERTY_MAX_POOL_SIZE = "maxPoolSize";
    private static final String PROPERTY_QUEUEL_SIZE = "queueSize";
    private static final int DEFAULT_MIN_POOL_SIZE = 35;
    private static final int DEFAULT_MAX_POOL_SIZE = 50;
    private static final int DEFAULT_QUEUE_SIZE = -1;

    protected void activate(ComponentContext ctx) throws Exception {
        if (this.threadPoolManager == null) {
            throw new Exception("No ThreadPoolManager found.");
        }
        ThreadPoolConfig config = new ThreadPoolConfig();
        config.setMinPoolSize(OsgiUtil.toInteger(ctx.getProperties().get(PROPERTY_MIN_POOL_SIZE), (int)35));
        config.setMaxPoolSize(OsgiUtil.toInteger(ctx.getProperties().get(PROPERTY_MAX_POOL_SIZE), (int)50));
        config.setQueueSize(OsgiUtil.toInteger(ctx.getProperties().get(PROPERTY_QUEUEL_SIZE), (int)-1));
        config.setShutdownGraceful(true);
        this.threadPoolManager.create("SLING_EVENTING", config);
        this.threadPool = this.threadPoolManager.get("SLING_EVENTING");
        if (this.threadPool == null) {
            throw new Exception("No thread pool with name SLING_EVENTING found.");
        }
    }

    protected void deactivate(ComponentContext context) {
        this.threadPool = null;
    }

    public void execute(Runnable runnable) {
        this.threadPool.execute(runnable);
    }

    public ThreadPoolConfig getConfiguration() {
        return this.threadPool.getConfiguration();
    }

    public String getName() {
        return this.threadPool.getName();
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }
}

