/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.JobStatusProvider;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;
import org.apache.sling.event.impl.EventHelper;
import org.apache.sling.event.impl.JobBlockingQueue;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEventHandler
extends AbstractRepositoryEventHandler
implements EventUtil.JobStatusNotifier,
JobStatusProvider,
Runnable {
    private final Map<String, Boolean> processingMap = new HashMap<String, Boolean>();
    private final Map<String, JobBlockingQueue> jobQueues = new HashMap<String, JobBlockingQueue>();
    private static final long DEFAULT_SLEEP_TIME = 30L;
    private static final String CONFIG_PROPERTY_SLEEP_TIME = "sleep.time";
    private static final int DEFAULT_MAX_JOB_RETRIES = 10;
    private static final String CONFIG_PROPERTY_MAX_JOB_RETRIES = "max.job.retries";
    private static final long DEFAULT_WAIT_FOR_ACK = 90L;
    private static final String CONFIG_PROPERTY_MAXIMUM_PARALLEL_JOBS = "max.parallel.jobs";
    private static final long DEFAULT_MAXIMUM_PARALLEL_JOBS = 15L;
    private static final String CONFIG_PROPERTY_WAIT_FOR_ACK = "wait.for.ack";
    private long sleepTime;
    private int maxJobRetries;
    private long waitForAckMs;
    private long maximumParallelJobs;
    private Session backgroundSession;
    private Set<String> unloadedJobs = new HashSet<String>();
    private Set<String> deletedJobs = new HashSet<String>();
    private static final int DEFAULT_CLEANUP_PERIOD = 5;
    private static final String CONFIG_PROPERTY_CLEANUP_PERIOD = "cleanup.period";
    private int cleanupPeriod = 5;
    private Scheduler scheduler;
    private ComponentContext componentContext;
    private final Map<String, StartedJobInfo> processingEventsList = new HashMap<String, StartedJobInfo>();
    public static ThreadPool JOB_THREAD_POOL;
    private final Object writeLock = new Object();
    private final Object backgroundLock = new Object();
    private long parallelJobCount;

    @Override
    protected void activate(ComponentContext context) throws Exception {
        Dictionary props = context.getProperties();
        this.cleanupPeriod = OsgiUtil.toInteger(props.get(CONFIG_PROPERTY_CLEANUP_PERIOD), (int)5);
        this.sleepTime = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_SLEEP_TIME), (long)30L);
        this.maxJobRetries = OsgiUtil.toInteger(props.get(CONFIG_PROPERTY_MAX_JOB_RETRIES), (int)10);
        this.waitForAckMs = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_WAIT_FOR_ACK), (long)90L) * 1000L;
        this.maximumParallelJobs = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_MAXIMUM_PARALLEL_JOBS), (long)15L);
        this.componentContext = context;
        super.activate(context);
        JOB_THREAD_POOL = this.threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
        Object object = this.jobQueues;
        synchronized (object) {
            for (JobBlockingQueue jbq : this.jobQueues.values()) {
                if (jbq.isWaiting()) {
                    Object object2 = jbq.getLock();
                    synchronized (object2) {
                        jbq.notifyFinish(null);
                    }
                }
                try {
                    jbq.put(new AbstractRepositoryEventHandler.EventInfo());
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
        }
        if (this.backgroundSession != null) {
            object = this.backgroundLock;
            synchronized (object) {
                try {
                    this.backgroundSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Unable to remove event listener.", (Throwable)e);
                }
                this.backgroundSession.logout();
                this.backgroundSession = null;
            }
        }
        this.componentContext = null;
        if (JOB_THREAD_POOL == this.threadPool) {
            JOB_THREAD_POOL = null;
        }
    }

    private String getCleanUpQueryString() {
        Calendar deleteBefore = Calendar.getInstance();
        deleteBefore.add(12, -this.cleanupPeriod);
        String dateString = ISO8601.format(deleteBefore);
        StringBuilder buffer = new StringBuilder("/jcr:root");
        buffer.append(this.repositoryPath);
        buffer.append("//element(*, ");
        buffer.append(this.getEventNodeType());
        buffer.append(")[@");
        buffer.append("slingevent:finished");
        buffer.append(" < xs:dateTime('");
        buffer.append(dateString);
        buffer.append("')]");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            Query q;
            long tooOld = System.currentTimeMillis() - this.waitForAckMs;
            ArrayList<StartedJobInfo> restartJobs = new ArrayList<StartedJobInfo>();
            Map<String, StartedJobInfo> map = this.processingEventsList;
            synchronized (map) {
                for (Map.Entry<String, StartedJobInfo> entry : this.processingEventsList.entrySet()) {
                    if (entry.getValue().started > tooOld) continue;
                    restartJobs.add(entry.getValue());
                }
            }
            if (this.cleanupPeriod > 0) {
                this.logger.debug("Cleaning up repository, removing all finished jobs older than {} minutes.", (Object)this.cleanupPeriod);
                String queryString = this.getCleanUpQueryString();
                Session s = null;
                try {
                    s = this.createSession();
                    Node parentNode = (Node)s.getItem(this.repositoryPath);
                    this.logger.debug("Executing query {}", (Object)queryString);
                    q = s.getWorkspace().getQueryManager().createQuery(queryString, "xpath");
                    NodeIterator iter = q.execute().getNodes();
                    int count = 0;
                    while (iter.hasNext()) {
                        Node eventNode = iter.nextNode();
                        eventNode.remove();
                        ++count;
                    }
                    parentNode.save();
                    this.logger.debug("Removed {} entries from the repository.", (Object)count);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Exception during repository cleanup.", (Throwable)e);
                }
                finally {
                    if (s != null) {
                        s.logout();
                    }
                }
            }
            if (restartJobs.size() > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
            for (StartedJobInfo info : restartJobs) {
                boolean process = false;
                q = this.processingEventsList;
                synchronized (q) {
                    process = this.processingEventsList.remove(info.nodePath) != null;
                }
                if (!process) continue;
                this.logger.info("No acknowledge received for job {} stored at {}. Requeueing job.", (Object)info.event, (Object)info.nodePath);
                this.finishedJob(info.event, info.nodePath, true);
            }
            Map<String, JobBlockingQueue> map2 = this.jobQueues;
            synchronized (map2) {
                Iterator<Map.Entry<String, JobBlockingQueue>> i = this.jobQueues.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, JobBlockingQueue> current = i.next();
                    JobBlockingQueue jbq = current.getValue();
                    if (jbq.size() != 0) continue;
                    if (jbq.isMarkedForCleanUp()) {
                        jbq.setFinished(true);
                        try {
                            jbq.put(new AbstractRepositoryEventHandler.EventInfo());
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                        }
                        i.remove();
                        continue;
                    }
                    jbq.markForCleanUp();
                }
            }
        }
    }

    @Override
    protected void processWriteQueue() {
        while (this.running) {
            AbstractRepositoryEventHandler.EventInfo info;
            block20: {
                org.osgi.service.event.Event event = null;
                try {
                    event = (org.osgi.service.event.Event)this.writeQueue.take();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
                if (event == null || !this.running) continue;
                this.logger.debug("Persisting job {}", (Object)event);
                try {
                    this.writerSession.refresh(false);
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
                info = new AbstractRepositoryEventHandler.EventInfo();
                info.event = event;
                String jobId = (String)event.getProperty("event.job.id");
                String jobTopic = (String)event.getProperty("event.job.topic");
                String nodePath = this.getNodePath(jobTopic, jobId);
                if (jobId == null) {
                    try {
                        Node eventNode = this.writeEvent(event, nodePath);
                        info.nodePath = eventNode.getPath();
                    }
                    catch (RepositoryException re) {
                        this.logger.error("Exception during writing new job '" + EventUtil.toString(event) + "' to repository at " + nodePath, (Throwable)re);
                    }
                } else {
                    try {
                        Node parentNode = this.ensureRepositoryPath();
                        Node foundNode = null;
                        if (parentNode.hasNode(nodePath)) {
                            foundNode = parentNode.getNode(nodePath);
                        }
                        if (foundNode != null) {
                            if (foundNode.isLocked()) break block20;
                            try {
                                if (!foundNode.hasProperty("slingevent:finished")) {
                                    info.nodePath = foundNode.getPath();
                                }
                                break block20;
                            }
                            catch (RepositoryException re) {}
                            break block20;
                        }
                        try {
                            Node eventNode = this.writeEvent(event, nodePath);
                            info.nodePath = eventNode.getPath();
                        }
                        catch (ItemExistsException iee) {}
                    }
                    catch (RepositoryException re) {
                        this.logger.error("Exception during writing new job '" + event + "' to repository at " + nodePath, (Throwable)re);
                    }
                }
            }
            if (info.nodePath == null) continue;
            try {
                this.queue.put(info);
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInBackground() throws RepositoryException {
        this.backgroundSession = this.createSession();
        this.backgroundSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 10, this.repositoryPath, true, null, new String[]{this.getEventNodeType()}, true);
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        if (this.running) {
            this.loadJobs();
        } else {
            ComponentContext ctx = this.componentContext;
            if (ctx != null) {
                this.logger.info("Deactivating component {} due to errors during startup.", ctx.getProperties().get("service.id"));
                String name = (String)this.componentContext.getProperties().get("component.name");
                ctx.disableComponent(name);
            }
        }
        while (this.running) {
            AbstractRepositoryEventHandler.EventInfo info = null;
            try {
                info = (AbstractRepositoryEventHandler.EventInfo)this.queue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (info == null || !this.running) continue;
            String appId = (String)info.event.getProperty("event.application");
            if (info.event.getProperty("event.job.run.local") != null && appId != null && !this.applicationId.equals(appId)) {
                info = null;
            }
            if (info != null && info.event.getProperty("event.job.queuename") != null) {
                final String queueName = (String)info.event.getProperty("event.job.queuename");
                Map<String, JobBlockingQueue> map = this.jobQueues;
                synchronized (map) {
                    BlockingQueue jobQueue = this.jobQueues.get(queueName);
                    if (jobQueue == null) {
                        final JobBlockingQueue jq = new JobBlockingQueue();
                        jobQueue = jq;
                        this.jobQueues.put(queueName, jq);
                        this.threadPool.execute(new Runnable(){

                            public void run() {
                                while (JobEventHandler.this.running && !jq.isFinished()) {
                                    JobEventHandler.this.logger.info("Starting job queue {}", (Object)queueName);
                                    try {
                                        JobEventHandler.this.runJobQueue(queueName, jq);
                                    }
                                    catch (Throwable t) {
                                        JobEventHandler.this.logger.error("Job queue stopped with exception: " + t.getMessage() + ". Restarting.", t);
                                    }
                                }
                            }
                        });
                    }
                    try {
                        jobQueue.put(info);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                }
                info = null;
            }
            if (info == null) continue;
            this.executeJob(info, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobQueue(String queueName, final JobBlockingQueue jobQueue) {
        AbstractRepositoryEventHandler.EventInfo info = null;
        while (this.running && !jobQueue.isFinished()) {
            if (info == null) {
                try {
                    info = (AbstractRepositoryEventHandler.EventInfo)jobQueue.take();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
            if (info == null || !this.running || jobQueue.isFinished()) continue;
            Object object = jobQueue.getLock();
            synchronized (object) {
                AbstractRepositoryEventHandler.EventInfo processInfo = info;
                info = null;
                if (this.executeJob(processInfo, jobQueue)) {
                    AbstractRepositoryEventHandler.EventInfo newInfo = null;
                    try {
                        newInfo = jobQueue.waitForFinish();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                    if (newInfo != null) {
                        boolean orderedQueue;
                        final AbstractRepositoryEventHandler.EventInfo newEventInfo = newInfo;
                        org.osgi.service.event.Event job = newInfo.event;
                        boolean bl = orderedQueue = job.getProperty("event.job.queueordered") != null;
                        if (orderedQueue) {
                            if (job.getProperty("event.job.retrydelay") != null) {
                                long delay = (Long)job.getProperty("event.job.retrydelay");
                                jobQueue.setSleeping(true, Thread.currentThread());
                                try {
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException e) {
                                    this.ignoreException(e);
                                }
                                finally {
                                    jobQueue.setSleeping(false);
                                }
                            }
                            info = newInfo;
                        } else if (job.getProperty("event.job.retrydelay") != null) {
                            long delay = (Long)job.getProperty("event.job.retrydelay");
                            Date fireDate = new Date();
                            fireDate.setTime(System.currentTimeMillis() + delay);
                            final String schedulerJobName = "Waiting:" + queueName;
                            Runnable t = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    jobQueue.setSleeping(true, schedulerJobName);
                                    try {
                                        jobQueue.put(newEventInfo);
                                    }
                                    catch (InterruptedException e) {
                                        JobEventHandler.this.ignoreException(e);
                                    }
                                    finally {
                                        jobQueue.setSleeping(false);
                                    }
                                }
                            };
                            try {
                                this.scheduler.fireJobAt(schedulerJobName, (Object)t, null, fireDate);
                            }
                            catch (Exception e) {
                                this.ignoreException(e);
                                t.run();
                            }
                        } else {
                            try {
                                jobQueue.put(newInfo);
                            }
                            catch (InterruptedException e) {
                                this.ignoreException(e);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean executeJob(AbstractRepositoryEventHandler.EventInfo info, BlockingQueue<AbstractRepositoryEventHandler.EventInfo> jobQueue) {
        boolean putback = false;
        boolean wait = false;
        Object object = this.backgroundLock;
        synchronized (object) {
            block45: {
                try {
                    boolean parallelProcessing;
                    this.backgroundSession.refresh(false);
                    if (!this.backgroundSession.itemExists(info.nodePath) || this.backgroundSession.itemExists(info.nodePath + "/" + "slingevent:finished")) break block45;
                    org.osgi.service.event.Event event = info.event;
                    String jobTopic = (String)event.getProperty("event.job.topic");
                    boolean process = parallelProcessing = event.getProperty("event.job.queuename") != null || event.getProperty("event.job.parallel") != null;
                    if (!parallelProcessing) {
                        Map<String, Boolean> map = this.processingMap;
                        synchronized (map) {
                            Boolean value = this.processingMap.get(jobTopic);
                            if (value == null || !value.booleanValue()) {
                                this.processingMap.put(jobTopic, Boolean.TRUE);
                                process = true;
                            }
                        }
                    } else if (jobQueue == null && this.parallelJobCount >= this.maximumParallelJobs) {
                        process = false;
                        wait = true;
                    }
                    if (process) {
                        boolean unlock = true;
                        try {
                            Object eventNode = (Node)this.backgroundSession.getItem(info.nodePath);
                            if (eventNode.isLocked()) break block45;
                            try {
                                eventNode.lock(false, true);
                            }
                            catch (RepositoryException re) {
                                process = false;
                            }
                            if (process) {
                                unlock = false;
                                this.processJob(info.event, (Node)eventNode, jobQueue == null);
                                boolean bl = true;
                                return bl;
                            }
                            break block45;
                        }
                        catch (RepositoryException e) {
                            this.ignoreException((Exception)((Object)e));
                            break block45;
                        }
                        finally {
                            if (unlock && !parallelProcessing) {
                                Map<String, Boolean> map = this.processingMap;
                                synchronized (map) {
                                    this.processingMap.put(jobTopic, Boolean.FALSE);
                                }
                            }
                        }
                    }
                    try {
                        Node eventNode = (Node)this.backgroundSession.getItem(info.nodePath);
                        if (!eventNode.isLocked() && !eventNode.hasProperty("slingevent:finished")) {
                            putback = true;
                        }
                    }
                    catch (RepositoryException e) {
                        this.ignoreException((Exception)((Object)e));
                    }
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
            }
        }
        if (wait) {
            try {
                Thread.sleep(this.sleepTime * 1000L);
            }
            catch (InterruptedException ie) {
                this.ignoreException(ie);
            }
        }
        if (putback) {
            final AbstractRepositoryEventHandler.EventInfo eInfo = info;
            Date fireDate = new Date();
            fireDate.setTime(System.currentTimeMillis() + this.sleepTime * 1000L);
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        JobEventHandler.this.queue.put(eInfo);
                    }
                    catch (InterruptedException e) {
                        JobEventHandler.this.ignoreException(e);
                    }
                }
            };
            try {
                this.scheduler.fireJobAt(null, (Object)r, null, fireDate);
            }
            catch (Exception e) {
                this.ignoreException(e);
                try {
                    Thread.sleep(this.sleepTime * 1000L);
                }
                catch (InterruptedException ie) {
                    this.ignoreException(ie);
                }
                r.run();
            }
        }
        return false;
    }

    @Override
    protected String getEventNodeType() {
        return "slingevent:Job";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(org.osgi.service.event.Event event) {
        this.logger.debug("Receiving event {}", (Object)event);
        if (EventUtil.isLocal(event)) {
            if (event.getTopic().equals("org/apache/sling/event/job")) {
                this.logger.debug("Handling local job {}", (Object)event);
                String jobTopic = (String)event.getProperty("event.job.topic");
                if (jobTopic != null) {
                    try {
                        this.writeQueue.put(event);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                } else {
                    this.logger.warn("Event does not contain job topic: {}", (Object)event);
                }
            } else {
                boolean doIt = false;
                Set<String> e = this.unloadedJobs;
                synchronized (e) {
                    if (this.unloadedJobs.size() > 0) {
                        doIt = true;
                    }
                }
                if (doIt) {
                    Runnable t = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Set set = JobEventHandler.this.unloadedJobs;
                            synchronized (set) {
                                Session s = null;
                                HashSet<String> newUnloadedJobs = new HashSet<String>();
                                newUnloadedJobs.addAll(JobEventHandler.this.unloadedJobs);
                                try {
                                    s = JobEventHandler.this.createSession();
                                    for (String path : JobEventHandler.this.unloadedJobs) {
                                        newUnloadedJobs.remove(path);
                                        try {
                                            Node eventNode;
                                            if (!s.itemExists(path) || (eventNode = (Node)s.getItem(path)).isLocked()) continue;
                                            try {
                                                AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                                                info.event = JobEventHandler.this.readEvent(eventNode);
                                                info.nodePath = path;
                                                try {
                                                    JobEventHandler.this.queue.put(info);
                                                }
                                                catch (InterruptedException e) {
                                                    JobEventHandler.this.ignoreException(e);
                                                }
                                            }
                                            catch (ClassNotFoundException cnfe) {
                                                newUnloadedJobs.add(path);
                                                JobEventHandler.this.ignoreException(cnfe);
                                            }
                                        }
                                        catch (RepositoryException re) {
                                            newUnloadedJobs.add(path);
                                            JobEventHandler.this.ignoreException((Exception)((Object)re));
                                        }
                                    }
                                }
                                catch (RepositoryException re) {
                                    JobEventHandler.this.ignoreException((Exception)((Object)re));
                                }
                                finally {
                                    if (s != null) {
                                        s.logout();
                                    }
                                    JobEventHandler.this.unloadedJobs.clear();
                                    JobEventHandler.this.unloadedJobs.addAll(newUnloadedJobs);
                                }
                            }
                        }
                    };
                    this.threadPool.execute(t);
                }
            }
        }
    }

    private String getNodePath(String jobTopic, String jobId) {
        StringBuilder sb = new StringBuilder(jobTopic.replace('/', '.'));
        sb.append('/');
        if (jobId != null) {
            String md5 = EventHelper.md5(jobId);
            sb.append(md5.substring(0, 2));
            sb.append('/');
            sb.append(md5.substring(2, 4));
            sb.append('/');
            sb.append(md5.substring(4, 6));
            sb.append('/');
            sb.append(EventHelper.filter(jobId));
        } else {
            String uuid = UUID.randomUUID().toString();
            sb.append(uuid.substring(0, 2));
            sb.append('/');
            sb.append(uuid.substring(2, 4));
            sb.append('/');
            sb.append(uuid.substring(5, 7));
            sb.append("/Job_");
            sb.append(uuid.substring(8, 17));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJob(org.osgi.service.event.Event event, Node eventNode, boolean isMainQueue) {
        block28: {
            boolean parallelProcessing = event.getProperty("event.job.queuename") != null || event.getProperty("event.job.parallel") != null;
            String jobTopic = (String)event.getProperty("event.job.topic");
            boolean unlock = true;
            try {
                if (isMainQueue && !parallelProcessing) {
                    ++this.parallelJobCount;
                }
                String nodePath = eventNode.getPath();
                org.osgi.service.event.Event jobEvent = this.getJobEvent(event, nodePath);
                eventNode.setProperty("slingevent:processor", this.applicationId);
                eventNode.save();
                EventAdmin localEA = this.eventAdmin;
                if (localEA != null) {
                    StartedJobInfo jobInfo = new StartedJobInfo(jobEvent, nodePath, System.currentTimeMillis());
                    Map<String, StartedJobInfo> map = this.processingEventsList;
                    synchronized (map) {
                        this.processingEventsList.put(nodePath, jobInfo);
                    }
                    localEA.postEvent(jobEvent);
                    unlock = false;
                    break block28;
                }
                this.logger.error("Job event can't be sent as no event admin is available.");
            }
            catch (RepositoryException re) {
                this.logger.error("Exception during job processing.", (Throwable)re);
            }
            finally {
                if (unlock) {
                    if (isMainQueue && !parallelProcessing) {
                        --this.parallelJobCount;
                    }
                    if (!parallelProcessing) {
                        Map<String, Boolean> re = this.processingMap;
                        synchronized (re) {
                            this.processingMap.put(jobTopic, Boolean.FALSE);
                        }
                    }
                    try {
                        eventNode.unlock();
                    }
                    catch (RepositoryException e) {
                        this.ignoreException((Exception)((Object)e));
                    }
                }
            }
        }
    }

    private org.osgi.service.event.Event getJobEvent(org.osgi.service.event.Event e, String nodePath) {
        String eventTopic = (String)e.getProperty("event.job.topic");
        EventPropertiesMap properties = new EventPropertiesMap(e);
        ((Dictionary)properties).put(EventUtil.JobStatusNotifier.CONTEXT_PROPERTY_NAME, new EventUtil.JobStatusNotifier.NotifierContext(this, nodePath));
        return new org.osgi.service.event.Event(eventTopic, (Dictionary)properties);
    }

    @Override
    protected void addNodeProperties(Node eventNode, org.osgi.service.event.Event event) throws RepositoryException {
        super.addNodeProperties(eventNode, event);
        eventNode.setProperty("slingevent:topic", (String)event.getProperty("event.job.topic"));
        String jobId = (String)event.getProperty("event.job.id");
        if (jobId != null) {
            eventNode.setProperty("slingevent:id", jobId);
        }
        long retryCount = OsgiUtil.toLong((Object)event.getProperty("event.job.retrycount"), (long)0L);
        long retries = OsgiUtil.toLong((Object)event.getProperty("event.job.retries"), (long)this.maxJobRetries);
        eventNode.setProperty("event.job.retrycount", retryCount);
        eventNode.setProperty("event.job.retries", retries);
    }

    @Override
    protected void addEventProperties(Node eventNode, Dictionary<String, Object> properties) throws RepositoryException {
        super.addEventProperties(eventNode, properties);
        if (properties.get("event.job.retries") != null) {
            properties.put("event.job.retries", Integer.valueOf(properties.get("event.job.retries").toString()));
        }
        if (properties.get("event.job.retrycount") != null) {
            properties.put("event.job.retrycount", Integer.valueOf(properties.get("event.job.retrycount").toString()));
        }
        properties.put("event.application", eventNode.getProperty("slingevent:application").getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator iter) {
        Session s = null;
        try {
            s = this.createSession();
            while (iter.hasNext()) {
                Event event = iter.nextEvent();
                if (event.getType() != 16 && event.getType() != 8) continue;
                try {
                    Node eventNode;
                    String propPath = event.getPath();
                    int pos = propPath.lastIndexOf(47);
                    String nodePath = propPath.substring(0, pos);
                    String propertyName = propPath.substring(pos + 1);
                    if (!"jcr:lockOwner".equals(propertyName)) continue;
                    boolean doNotProcess = false;
                    Set<String> set = this.deletedJobs;
                    synchronized (set) {
                        doNotProcess = this.deletedJobs.remove(nodePath);
                    }
                    if (doNotProcess || (eventNode = (Node)s.getItem(nodePath)).isLocked() || eventNode.hasProperty("slingevent:finished")) continue;
                    try {
                        AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                        info.event = this.readEvent(eventNode);
                        info.nodePath = nodePath;
                        try {
                            this.queue.put(info);
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        Set<String> set2 = this.unloadedJobs;
                        synchronized (set2) {
                            this.unloadedJobs.add(nodePath);
                        }
                        this.ignoreException(cnfe);
                    }
                }
                catch (RepositoryException re) {
                    this.logger.error("Exception during jcr event processing.", (Throwable)re);
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to create a session.", (Throwable)re);
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobs() {
        try {
            QueryManager qManager = this.backgroundSession.getWorkspace().getQueryManager();
            StringBuilder buffer = new StringBuilder("/jcr:root");
            buffer.append(this.repositoryPath);
            buffer.append("//element(*, ");
            buffer.append(this.getEventNodeType());
            buffer.append(") order by @");
            buffer.append("slingevent:created");
            buffer.append(" ascending");
            Query q = qManager.createQuery(buffer.toString(), "xpath");
            NodeIterator result = q.execute().getNodes();
            while (result.hasNext()) {
                Node eventNode = result.nextNode();
                if (eventNode.isLocked() || eventNode.hasProperty("slingevent:finished")) continue;
                String nodePath = eventNode.getPath();
                try {
                    org.osgi.service.event.Event event = this.readEvent(eventNode);
                    AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                    info.event = event;
                    info.nodePath = nodePath;
                    try {
                        this.queue.put(info);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    Set<String> set = this.unloadedJobs;
                    synchronized (set) {
                        this.unloadedJobs.add(nodePath);
                    }
                    this.ignoreException(cnfe);
                }
                catch (RepositoryException re) {
                    this.logger.error("Unable to load stored job from " + nodePath, (Throwable)re);
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Exception during initial loading of stored jobs.", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendAcknowledge(org.osgi.service.event.Event job, String eventNodePath) {
        Map<String, StartedJobInfo> map = this.processingEventsList;
        synchronized (map) {
            StartedJobInfo ack = this.processingEventsList.remove(eventNodePath);
            return ack != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean finishedJob(org.osgi.service.event.Event job, String eventNodePath, boolean shouldReschedule) {
        Object newProperties;
        Map<String, StartedJobInfo> map = this.processingEventsList;
        synchronized (map) {
            this.processingEventsList.remove(eventNodePath);
        }
        boolean reschedule = shouldReschedule;
        if (shouldReschedule) {
            int retries = this.maxJobRetries;
            if (job.getProperty("event.job.retries") != null) {
                retries = (Integer)job.getProperty("event.job.retries");
            }
            int retryCount = 0;
            if (job.getProperty("event.job.retrycount") != null) {
                retryCount = (Integer)job.getProperty("event.job.retrycount");
            }
            if (retries != -1 && ++retryCount > retries) {
                reschedule = false;
            }
            if (reschedule) {
                newProperties = new EventPropertiesMap(job);
                ((Dictionary)newProperties).put("event.job.retrycount", retryCount);
                ((Dictionary)newProperties).put("event.job.retries", retries);
                job = new org.osgi.service.event.Event(job.getTopic(), (Dictionary)newProperties);
            }
        }
        boolean parallelProcessing = job.getProperty("event.job.queuename") != null || job.getProperty("event.job.parallel") != null;
        AbstractRepositoryEventHandler.EventInfo putback = null;
        newProperties = this.backgroundLock;
        synchronized (newProperties) {
            block72: {
                if (this.backgroundSession == null) {
                    this.checkForNotify(job, null);
                    return false;
                }
                try {
                    Node eventNode;
                    block70: {
                        Object jobTopic2222;
                        boolean unlock;
                        block68: {
                            this.backgroundSession.refresh(false);
                            if (!this.backgroundSession.itemExists(eventNodePath)) {
                                this.checkForNotify(job, null);
                                return true;
                            }
                            eventNode = (Node)this.backgroundSession.getItem(eventNodePath);
                            unlock = true;
                            try {
                                block67: {
                                    if (reschedule) break block67;
                                    Set<String> set = this.deletedJobs;
                                    synchronized (set) {
                                        this.deletedJobs.add(eventNodePath);
                                    }
                                    try {
                                        eventNode.unlock();
                                    }
                                    catch (RepositoryException e) {
                                        this.ignoreException((Exception)((Object)e));
                                    }
                                    unlock = false;
                                    String jobId = (String)job.getProperty("event.job.id");
                                    if (jobId == null) {
                                        Node parentNode = eventNode.getParent();
                                        eventNode.remove();
                                        parentNode.save();
                                        break block67;
                                    }
                                    eventNode.setProperty("slingevent:finished", Calendar.getInstance());
                                    eventNode.save();
                                }
                                Object var13_23 = null;
                                if (parallelProcessing) break block68;
                            }
                            catch (Throwable throwable) {
                                Object jobTopic2222;
                                Object var13_25 = null;
                                if (!parallelProcessing) {
                                    jobTopic2222 = (String)job.getProperty("event.job.topic");
                                    Map<String, Boolean> map2 = this.processingMap;
                                    synchronized (map2) {
                                        this.processingMap.put((String)jobTopic2222, Boolean.FALSE);
                                    }
                                } else if (job.getProperty("event.job.queuename") == null) {
                                    --this.parallelJobCount;
                                }
                                if (unlock) {
                                    jobTopic2222 = this.deletedJobs;
                                    synchronized (jobTopic2222) {
                                        this.deletedJobs.add(eventNodePath);
                                    }
                                    try {
                                        eventNode.unlock();
                                    }
                                    catch (RepositoryException e) {
                                        this.ignoreException((Exception)((Object)e));
                                    }
                                }
                                throw throwable;
                            }
                            jobTopic2222 = (String)job.getProperty("event.job.topic");
                            Map<String, Boolean> map3 = this.processingMap;
                            synchronized (map3) {
                                this.processingMap.put((String)jobTopic2222, Boolean.FALSE);
                            }
                        }
                        if (job.getProperty("event.job.queuename") == null) {
                            --this.parallelJobCount;
                        }
                        if (unlock) {
                            jobTopic2222 = this.deletedJobs;
                            synchronized (jobTopic2222) {
                                this.deletedJobs.add(eventNodePath);
                            }
                            try {
                                eventNode.unlock();
                            }
                            catch (RepositoryException e) {
                                this.ignoreException((Exception)((Object)e));
                            }
                        }
                        break block70;
                        {
                            catch (RepositoryException re) {
                                Object jobTopic2222;
                                this.logger.error("Exception during job finishing.", (Throwable)re);
                                Object var13_24 = null;
                                if (!parallelProcessing) {
                                    jobTopic2222 = (String)job.getProperty("event.job.topic");
                                    Map<String, Boolean> map4 = this.processingMap;
                                    synchronized (map4) {
                                        this.processingMap.put((String)jobTopic2222, Boolean.FALSE);
                                    }
                                } else if (job.getProperty("event.job.queuename") == null) {
                                    --this.parallelJobCount;
                                }
                                if (!unlock) break block70;
                                jobTopic2222 = this.deletedJobs;
                                synchronized (jobTopic2222) {
                                    this.deletedJobs.add(eventNodePath);
                                }
                                try {
                                    eventNode.unlock();
                                }
                                catch (RepositoryException e) {
                                    this.ignoreException((Exception)((Object)e));
                                }
                            }
                        }
                    }
                    if (reschedule) {
                        try {
                            eventNode.setProperty("event.job.retries", (long)((Integer)job.getProperty("event.job.retries")).intValue());
                            eventNode.setProperty("event.job.retrycount", (long)((Integer)job.getProperty("event.job.retrycount")).intValue());
                            eventNode.save();
                        }
                        catch (RepositoryException re) {
                            this.logger.error("Exception during job updating job rescheduling information.", (Throwable)re);
                        }
                        AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                        try {
                            info.event = job;
                            info.nodePath = eventNode.getPath();
                        }
                        catch (RepositoryException e) {
                            this.ignoreException((Exception)((Object)e));
                        }
                        if (job.getProperty("event.job.queuename") != null) {
                            this.checkForNotify(job, info);
                        } else if (job.getProperty("event.job.retrydelay") != null) {
                            putback = info;
                        } else {
                            try {
                                this.queue.put(info);
                            }
                            catch (InterruptedException e) {
                                this.ignoreException(e);
                            }
                        }
                        break block72;
                    }
                    this.checkForNotify(job, null);
                }
                catch (RepositoryException re) {
                    this.logger.error("Unable to create new session.", (Throwable)re);
                    return false;
                }
            }
        }
        if (putback != null) {
            final AbstractRepositoryEventHandler.EventInfo info = putback;
            long delay = (Long)job.getProperty("event.job.retrydelay");
            Date fireDate = new Date();
            fireDate.setTime(System.currentTimeMillis() + delay);
            Runnable t = new Runnable(){

                public void run() {
                    try {
                        JobEventHandler.this.queue.put(info);
                    }
                    catch (InterruptedException e) {
                        JobEventHandler.this.ignoreException(e);
                    }
                }
            };
            try {
                this.scheduler.fireJobAt(null, (Object)t, null, fireDate);
            }
            catch (Exception e) {
                this.ignoreException(e);
                t.run();
            }
        }
        if (!shouldReschedule) {
            return true;
        }
        return reschedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNotify(org.osgi.service.event.Event job, AbstractRepositoryEventHandler.EventInfo info) {
        if (job.getProperty("event.job.queuename") != null) {
            JobBlockingQueue jobQueue;
            Object object = this.jobQueues;
            synchronized (object) {
                jobQueue = this.jobQueues.get(job.getProperty("event.job.queuename"));
            }
            object = jobQueue.getLock();
            synchronized (object) {
                jobQueue.notifyFinish(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<org.osgi.service.event.Event> queryJobs(String topic, Boolean locked, Map<String, Object> ... filterProps) {
        Session s = null;
        ArrayList<org.osgi.service.event.Event> jobs = new ArrayList<org.osgi.service.event.Event>();
        try {
            try {
                s = this.createSession();
                QueryManager qManager = s.getWorkspace().getQueryManager();
                StringBuilder buffer = new StringBuilder("/jcr:root");
                buffer.append(this.repositoryPath);
                if (topic != null) {
                    buffer.append('/');
                    buffer.append(topic.replace('/', '.'));
                }
                buffer.append("//element(*, ");
                buffer.append(this.getEventNodeType());
                buffer.append(") [not(@");
                buffer.append("slingevent:finished");
                buffer.append(")");
                if (locked != null) {
                    if (locked.booleanValue()) {
                        buffer.append(" and @jcr:lockOwner");
                    } else {
                        buffer.append(" and not(@jcr:lockOwner)");
                    }
                }
                if (filterProps != null && filterProps.length > 0) {
                    buffer.append(" and (");
                    int index = 0;
                    Map<String, Object>[] arr$ = filterProps;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++index, ++i$) {
                        Map<String, Object> template = arr$[i$];
                        if (index > 0) {
                            buffer.append(" or ");
                        }
                        buffer.append('(');
                        Iterator<Map.Entry<String, Object>> i = template.entrySet().iterator();
                        boolean first = true;
                        while (i.hasNext()) {
                            Value value;
                            Map.Entry<String, Object> current = i.next();
                            String propName = EventHelper.getNodePropertyName(current.getKey());
                            if (propName == null || (value = EventHelper.getNodePropertyValue(s.getValueFactory(), current.getValue())) == null) continue;
                            if (first) {
                                first = false;
                                buffer.append('@');
                            } else {
                                buffer.append(" and @");
                            }
                            buffer.append(propName);
                            buffer.append(" = '");
                            buffer.append(current.getValue());
                            buffer.append("'");
                        }
                        buffer.append(')');
                    }
                    buffer.append(')');
                }
                buffer.append("]");
                buffer.append(" order by @");
                buffer.append("slingevent:created");
                buffer.append(" ascending");
                String queryString = buffer.toString();
                this.logger.debug("Executing job query {}.", (Object)queryString);
                Query q = qManager.createQuery(queryString, "xpath");
                NodeIterator iter = q.execute().getNodes();
                while (iter.hasNext()) {
                    Node eventNode = iter.nextNode();
                    try {
                        org.osgi.service.event.Event event = this.readEvent(eventNode);
                        jobs.add(event);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.ignoreException(cnfe);
                    }
                }
                Object var19_23 = null;
                if (s == null) return jobs;
            }
            catch (RepositoryException e) {
                this.ignoreException((Exception)((Object)e));
                Object var19_24 = null;
                if (s == null) return jobs;
                s.logout();
                return jobs;
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (s == null) throw throwable;
            s.logout();
            throw throwable;
        }
        s.logout();
        return jobs;
    }

    @Override
    public Collection<org.osgi.service.event.Event> getCurrentJobs(String topic) {
        return this.getCurrentJobs(topic, null);
    }

    @Override
    public Collection<org.osgi.service.event.Event> scheduledJobs(String topic) {
        return this.getScheduledJobs(topic);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getScheduledJobs(String topic) {
        return this.getScheduledJobs(topic, null);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getCurrentJobs(String topic, Map<String, Object> ... filterProps) {
        return this.queryJobs(topic, true, filterProps);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getScheduledJobs(String topic, Map<String, Object> ... filterProps) {
        return this.queryJobs(topic, false, filterProps);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getAllJobs(String topic, Map<String, Object> ... filterProps) {
        return this.queryJobs(topic, null, filterProps);
    }

    @Override
    public void cancelJob(String topic, String jobId) {
        if (jobId != null && topic != null) {
            this.cancelJob(this.getNodePath(topic, jobId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelJob(String jobId) {
        if (jobId != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writerSession.refresh(false);
                }
                catch (RepositoryException e) {
                    this.ignoreException((Exception)((Object)e));
                }
                try {
                    if (this.writerSession.itemExists(jobId)) {
                        Item item = this.writerSession.getItem(jobId);
                        Node parentNode = item.getParent();
                        item.remove();
                        parentNode.save();
                    }
                }
                catch (RepositoryException e) {
                    this.logger.error("Error during cancelling job at " + jobId, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUpJobQueue(String jobQueueName) {
        if (jobQueueName != null) {
            Map<String, JobBlockingQueue> map = this.jobQueues;
            synchronized (map) {
                JobBlockingQueue queue = this.jobQueues.get(jobQueueName);
                if (queue != null && queue.isSleeping()) {
                    String schedulerJobName = queue.getSchedulerJobName();
                    Thread thread = queue.getSleepingThread();
                    if (schedulerJobName != null) {
                        this.scheduler.removeJob(schedulerJobName);
                    }
                    if (thread != null) {
                        thread.interrupt();
                    }
                }
            }
        }
    }

    private static final class StartedJobInfo {
        public final org.osgi.service.event.Event event;
        public final String nodePath;
        public final long started;

        public StartedJobInfo(org.osgi.service.event.Event e, String path, long started) {
            this.event = e;
            this.nodePath = path;
            this.started = started;
        }
    }
}

