/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.TimedEventStatusProvider;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;
import org.apache.sling.event.impl.EventHelper;
import org.osgi.service.event.EventAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedJobHandler
extends AbstractRepositoryEventHandler
implements Job,
TimedEventStatusProvider {
    protected static final String JOB_TOPIC = "topic";
    protected static final String JOB_CONFIG = "config";
    protected static final String JOB_SCHEDULE_INFO = "info";
    protected Scheduler scheduler;
    protected Set<String> unloadedEvents = new HashSet<String>();
    private final Object writeLock = new Object();

    @Override
    protected void startWriterSession() throws RepositoryException {
        super.startWriterSession();
        this.loadEvents();
        this.writerSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 24, this.repositoryPath, true, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processWriteQueue() {
        while (this.running) {
            org.osgi.service.event.Event event = null;
            try {
                event = (org.osgi.service.event.Event)this.writeQueue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (!this.running || event == null) continue;
            ScheduleInfo scheduleInfo = null;
            try {
                scheduleInfo = new ScheduleInfo(event);
            }
            catch (IllegalArgumentException iae) {
                this.logger.error(iae.getMessage());
            }
            if (scheduleInfo == null) continue;
            AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
            info.event = event;
            Object object = this.writeLock;
            synchronized (object) {
                info.nodePath = this.persistEvent(info.event, scheduleInfo);
            }
            if (info.nodePath == null) continue;
            try {
                this.queue.put(info);
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInBackground() {
        while (this.running) {
            AbstractRepositoryEventHandler.EventInfo info = null;
            try {
                info = (AbstractRepositoryEventHandler.EventInfo)this.queue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (info == null || !this.running) continue;
            Object object = this.writeLock;
            synchronized (object) {
                block16: {
                    ScheduleInfo scheduleInfo = null;
                    try {
                        scheduleInfo = new ScheduleInfo(info.event);
                    }
                    catch (IllegalArgumentException iae) {
                        this.logger.error(iae.getMessage());
                    }
                    if (scheduleInfo != null) {
                        try {
                            Node eventNode;
                            this.writerSession.refresh(true);
                            if (!this.writerSession.itemExists(info.nodePath) || (eventNode = (Node)this.writerSession.getItem(info.nodePath)).isLocked()) break block16;
                            Lock lock = null;
                            try {
                                lock = eventNode.lock(false, true);
                            }
                            catch (RepositoryException re) {
                                // empty catch block
                            }
                            if (lock != null && !this.processEvent(info.event, scheduleInfo)) {
                                try {
                                    this.queue.put(info);
                                }
                                catch (InterruptedException e) {
                                    this.ignoreException(e);
                                }
                            }
                        }
                        catch (RepositoryException e) {
                            this.ignoreException((Exception)((Object)e));
                        }
                    }
                }
            }
        }
    }

    protected String persistEvent(org.osgi.service.event.Event event, ScheduleInfo scheduleInfo) {
        try {
            Node parentNode = this.ensureRepositoryPath();
            String nodeName = scheduleInfo.jobId;
            Node foundNode = parentNode.hasNode(nodeName) ? parentNode.getNode(nodeName) : null;
            Lock lock = null;
            if (scheduleInfo.isStopEvent()) {
                if (foundNode != null) {
                    try {
                        foundNode.remove();
                        parentNode.save();
                    }
                    catch (LockException le) {
                        // empty catch block
                    }
                }
                this.processEvent(event, scheduleInfo);
            } else {
                if (foundNode != null) {
                    try {
                        foundNode.remove();
                        parentNode.save();
                    }
                    catch (LockException le) {
                        // empty catch block
                    }
                    this.processEvent(event, scheduleInfo.getStopInfo());
                }
                if (EventUtil.isLocal(event)) {
                    Node eventNode = this.writeEvent(event, nodeName);
                    lock = eventNode.lock(false, true);
                }
            }
            if (lock != null && !this.processEvent(event, scheduleInfo)) {
                String path = lock.getNode().getPath();
                lock.getNode().unlock();
                return path;
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Exception during writing new job to repository.", (Throwable)re);
        }
        return null;
    }

    protected boolean processEvent(org.osgi.service.event.Event event, ScheduleInfo scheduleInfo) {
        Scheduler localScheduler = this.scheduler;
        if (localScheduler != null) {
            if (scheduleInfo.isStopEvent()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Stopping timed event " + event.getProperty("event.topic.timed") + "(" + scheduleInfo.jobId + ")");
                }
                try {
                    localScheduler.removeJob(scheduleInfo.jobId);
                }
                catch (NoSuchElementException nsee) {
                    // empty catch block
                }
                return true;
            }
            if (!EventUtil.isLocal(event)) {
                return true;
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            config.put(JOB_TOPIC, (String)event.getProperty("event.topic.timed"));
            String[] names = event.getPropertyNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    properties.put(names[i], event.getProperty(names[i]));
                }
            }
            config.put(JOB_CONFIG, properties);
            config.put(JOB_SCHEDULE_INFO, scheduleInfo);
            try {
                if (scheduleInfo.expression != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Adding timed event " + config.get(JOB_TOPIC) + "(" + scheduleInfo.jobId + ")" + " with cron expression " + scheduleInfo.expression);
                    }
                    localScheduler.addJob(scheduleInfo.jobId, (Object)this, config, scheduleInfo.expression, false);
                } else if (scheduleInfo.period != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Adding timed event " + config.get(JOB_TOPIC) + "(" + scheduleInfo.jobId + ")" + " with period " + scheduleInfo.period);
                    }
                    localScheduler.addPeriodicJob(scheduleInfo.jobId, (Object)this, config, scheduleInfo.period.longValue(), false);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Adding timed event " + config.get(JOB_TOPIC) + "(" + scheduleInfo.jobId + ")" + " with date " + scheduleInfo.date);
                    }
                    localScheduler.fireJobAt(scheduleInfo.jobId, (Object)this, config, scheduleInfo.date);
                }
                return true;
            }
            catch (Exception e) {
                this.ignoreException(e);
            }
        } else {
            this.logger.error("No scheduler available to start timed event " + event);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator iter) {
        Session s = null;
        try {
            s = this.createSession();
            while (iter.hasNext()) {
                Event event = iter.nextEvent();
                if (event.getType() != 16 && event.getType() != 8) continue;
                String propPath = event.getPath();
                int pos = propPath.lastIndexOf(47);
                String nodePath = propPath.substring(0, pos);
                String propertyName = propPath.substring(pos + 1);
                if (!"jcr:lockOwner".equals(propertyName)) continue;
                try {
                    Node eventNode = (Node)s.getItem(nodePath);
                    if (eventNode.isLocked()) continue;
                    try {
                        AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                        info.event = this.readEvent(eventNode);
                        info.nodePath = nodePath;
                        try {
                            this.queue.put(info);
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        Set<String> set = this.unloadedEvents;
                        synchronized (set) {
                            this.unloadedEvents.add(nodePath);
                        }
                        this.ignoreException(cnfe);
                    }
                }
                catch (RepositoryException re) {
                    this.logger.error("Exception during jcr event processing.", (Throwable)re);
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to create a session.", (Throwable)re);
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(org.osgi.service.event.Event event) {
        if (event.getTopic().equals("org/apache/sling/event/timed")) {
            try {
                this.writeQueue.put(event);
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
        } else {
            boolean doIt = false;
            Set<String> set = this.unloadedEvents;
            synchronized (set) {
                if (this.unloadedEvents.size() > 0) {
                    doIt = true;
                }
            }
            if (doIt) {
                Runnable t = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Set<String> set = TimedJobHandler.this.unloadedEvents;
                        synchronized (set) {
                            Session s = null;
                            HashSet<String> newUnloadedEvents = new HashSet<String>();
                            newUnloadedEvents.addAll(TimedJobHandler.this.unloadedEvents);
                            try {
                                s = TimedJobHandler.this.createSession();
                                for (String path : TimedJobHandler.this.unloadedEvents) {
                                    newUnloadedEvents.remove(path);
                                    try {
                                        Node eventNode;
                                        if (!s.itemExists(path) || (eventNode = (Node)s.getItem(path)).isLocked()) continue;
                                        try {
                                            AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                                            info.event = TimedJobHandler.this.readEvent(eventNode);
                                            info.nodePath = path;
                                            try {
                                                TimedJobHandler.this.queue.put(info);
                                            }
                                            catch (InterruptedException e) {
                                                TimedJobHandler.this.ignoreException(e);
                                            }
                                        }
                                        catch (ClassNotFoundException cnfe) {
                                            newUnloadedEvents.add(path);
                                            TimedJobHandler.this.ignoreException(cnfe);
                                        }
                                    }
                                    catch (RepositoryException re) {
                                        newUnloadedEvents.add(path);
                                        TimedJobHandler.this.ignoreException((Exception)((Object)re));
                                    }
                                }
                            }
                            catch (RepositoryException re) {
                                TimedJobHandler.this.ignoreException((Exception)((Object)re));
                            }
                            finally {
                                if (s != null) {
                                    s.logout();
                                }
                                TimedJobHandler.this.unloadedEvents.clear();
                                TimedJobHandler.this.unloadedEvents.addAll(newUnloadedEvents);
                            }
                        }
                    }
                };
                this.threadPool.execute(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobContext context) {
        String topic = (String)context.getConfiguration().get(JOB_TOPIC);
        Dictionary properties = (Dictionary)context.getConfiguration().get(JOB_CONFIG);
        EventAdmin ea = this.eventAdmin;
        if (ea != null) {
            try {
                ea.postEvent(new org.osgi.service.event.Event(topic, properties));
            }
            catch (IllegalArgumentException iae) {
                this.logger.error("Scheduled event has illegal topic: " + topic, (Throwable)iae);
            }
        } else {
            this.logger.warn("Unable to send timed event as no event admin service is available.");
        }
        ScheduleInfo info = (ScheduleInfo)context.getConfiguration().get(JOB_SCHEDULE_INFO);
        if (info.date != null) {
            Session s = null;
            try {
                s = this.createSession();
                if (s.itemExists(this.repositoryPath)) {
                    String nodeName;
                    Node eventNode;
                    Node parentNode = (Node)s.getItem(this.repositoryPath);
                    Node node = eventNode = parentNode.hasNode(nodeName = info.jobId) ? parentNode.getNode(nodeName) : null;
                    if (eventNode != null) {
                        try {
                            eventNode.remove();
                            parentNode.save();
                        }
                        catch (RepositoryException re) {
                            this.ignoreException((Exception)((Object)re));
                        }
                    }
                }
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to create a session.", (Throwable)re);
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEvents() {
        try {
            QueryManager qManager = this.writerSession.getWorkspace().getQueryManager();
            StringBuffer buffer = new StringBuffer("/jcr:root");
            buffer.append(this.repositoryPath);
            buffer.append("//element(*, ");
            buffer.append(this.getEventNodeType());
            buffer.append(")");
            Query q = qManager.createQuery(buffer.toString(), "xpath");
            NodeIterator result = q.execute().getNodes();
            while (result.hasNext()) {
                Node eventNode = result.nextNode();
                if (eventNode.isLocked()) continue;
                String nodePath = eventNode.getPath();
                try {
                    org.osgi.service.event.Event event = this.readEvent(eventNode);
                    AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                    info.event = event;
                    info.nodePath = nodePath;
                    try {
                        this.queue.put(info);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    Set<String> set = this.unloadedEvents;
                    synchronized (set) {
                        this.unloadedEvents.add(nodePath);
                    }
                    this.ignoreException(cnfe);
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Exception during initial loading of stored timed events.", (Throwable)re);
        }
    }

    @Override
    protected void addNodeProperties(Node eventNode, org.osgi.service.event.Event event) throws RepositoryException {
        super.addNodeProperties(eventNode, event);
        eventNode.setProperty("slingevent:topic", (String)event.getProperty("event.topic.timed"));
        ScheduleInfo info = new ScheduleInfo(event);
        if (info.date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(info.date);
            eventNode.setProperty("slingevent:date", c);
        }
        if (info.expression != null) {
            eventNode.setProperty("slingevent:expression", info.expression);
        }
        if (info.period != null) {
            eventNode.setProperty("slingevent:period", info.period.longValue());
        }
    }

    @Override
    protected String getEventNodeType() {
        return "slingevent:TimedEvent";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.osgi.service.event.Event getScheduledEvent(String topic, String eventId, String jobId) {
        Session s = null;
        try {
            s = this.createSession();
            if (s.itemExists(this.repositoryPath)) {
                String nodeName;
                Node eventNode;
                Node parentNode = (Node)s.getItem(this.repositoryPath);
                Node node = eventNode = parentNode.hasNode(nodeName = ScheduleInfo.getJobId(topic, eventId, jobId)) ? parentNode.getNode(nodeName) : null;
                if (eventNode != null) {
                    org.osgi.service.event.Event event = this.readEvent(eventNode);
                    return event;
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to create a session.", (Throwable)re);
        }
        catch (ClassNotFoundException e) {
            this.ignoreException(e);
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<org.osgi.service.event.Event> getScheduledEvents(String topic, Map<String, Object> ... filterProps) {
        Session s = null;
        ArrayList<org.osgi.service.event.Event> jobs = new ArrayList<org.osgi.service.event.Event>();
        try {
            s = this.createSession();
            QueryManager qManager = s.getWorkspace().getQueryManager();
            StringBuffer buffer = new StringBuffer("/jcr:root");
            buffer.append(this.repositoryPath);
            if (topic != null) {
                buffer.append('/');
                buffer.append(topic.replace('/', '.'));
            }
            buffer.append("//element(*, ");
            buffer.append(this.getEventNodeType());
            buffer.append(")");
            if (filterProps != null && filterProps.length > 0) {
                buffer.append(" [");
                int index = 0;
                for (Map<String, Object> template : filterProps) {
                    if (index > 0) {
                        buffer.append(" or ");
                    }
                    buffer.append('(');
                    Iterator<Map.Entry<String, Object>> i = template.entrySet().iterator();
                    boolean first = true;
                    while (i.hasNext()) {
                        Value value;
                        Map.Entry<String, Object> current = i.next();
                        String propName = EventHelper.getNodePropertyName(current.getKey());
                        if (propName == null || (value = EventHelper.getNodePropertyValue(s.getValueFactory(), current.getValue())) == null) continue;
                        if (first) {
                            first = false;
                            buffer.append('@');
                        } else {
                            buffer.append(" and @");
                        }
                        buffer.append(propName);
                        buffer.append(" = '");
                        buffer.append(current.getValue());
                        buffer.append("'");
                    }
                    buffer.append(')');
                    ++index;
                }
                buffer.append(']');
            }
            String queryString = buffer.toString();
            this.logger.debug("Executing job query {}.", (Object)queryString);
            Query q = qManager.createQuery(queryString, "xpath");
            NodeIterator iter = q.execute().getNodes();
            while (iter.hasNext()) {
                Node eventNode = iter.nextNode();
                try {
                    org.osgi.service.event.Event event = this.readEvent(eventNode);
                    jobs.add(event);
                }
                catch (ClassNotFoundException cnfe) {
                    this.ignoreException(cnfe);
                }
            }
        }
        catch (RepositoryException e) {
            this.ignoreException((Exception)((Object)e));
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimedEvent(String jobId) {
        Object object = this.writeLock;
        synchronized (object) {
            Scheduler localScheduler;
            try {
                Item foundNode;
                Item item = foundNode = this.writerSession.itemExists(jobId) ? this.writerSession.getItem(jobId) : null;
                if (foundNode != null) {
                    Node parentNode = foundNode.getParent();
                    try {
                        foundNode.remove();
                        parentNode.save();
                    }
                    catch (LockException le) {}
                }
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to cancel timed event: " + jobId, (Throwable)re);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Stopping timed event " + jobId);
            }
            if ((localScheduler = this.scheduler) != null) {
                try {
                    localScheduler.removeJob(jobId);
                }
                catch (NoSuchElementException nsee) {
                    // empty catch block
                }
            }
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected static final class ScheduleInfo
    implements Serializable {
        public final String expression;
        public final Long period;
        public final Date date;
        public final String jobId;

        public ScheduleInfo(org.osgi.service.event.Event event) throws IllegalArgumentException {
            this.expression = (String)event.getProperty("event.timed.scheduler");
            this.period = (Long)event.getProperty("event.timed.period");
            this.date = (Date)event.getProperty("event.timed.date");
            int count = 0;
            if (this.expression != null) {
                ++count;
            }
            if (this.period != null) {
                ++count;
            }
            if (this.date != null) {
                ++count;
            }
            if (count > 1) {
                throw new IllegalArgumentException("Only one configuration property from event.timed.scheduler, event.timed.period, or event.timed.date should be used.");
            }
            String topic = (String)event.getProperty("event.topic.timed");
            if (topic == null) {
                throw new IllegalArgumentException("Timed event does not contain required property event.topic.timed");
            }
            String id = (String)event.getProperty("event.timed.id");
            String jId = (String)event.getProperty("event.job.id");
            this.jobId = ScheduleInfo.getJobId(topic, id, jId);
        }

        private ScheduleInfo(String jobId) {
            this.expression = null;
            this.period = null;
            this.date = null;
            this.jobId = jobId;
        }

        public ScheduleInfo getStopInfo() {
            return new ScheduleInfo(this.jobId);
        }

        public boolean isStopEvent() {
            return this.expression == null && this.period == null && this.date == null;
        }

        public static String getJobId(String topic, String timedEventId, String jobId) {
            return topic.replace('/', '.') + "/TimedEvent " + (timedEventId != null ? EventHelper.filter(timedEventId) : "") + '_' + (jobId != null ? EventHelper.filter(jobId) : "");
        }
    }
}

