/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventHelper {
    public static final String EVENT_PREFIX = "slingevent:";
    public static final String NODE_PROPERTY_TOPIC = "slingevent:topic";
    public static final String NODE_PROPERTY_APPLICATION = "slingevent:application";
    public static final String NODE_PROPERTY_CREATED = "slingevent:created";
    public static final String NODE_PROPERTY_PROPERTIES = "slingevent:properties";
    public static final String NODE_PROPERTY_PROCESSOR = "slingevent:processor";
    public static final String NODE_PROPERTY_JOBID = "slingevent:id";
    public static final String NODE_PROPERTY_FINISHED = "slingevent:finished";
    public static final String NODE_PROPERTY_TE_EXPRESSION = "slingevent:expression";
    public static final String NODE_PROPERTY_TE_DATE = "slingevent:date";
    public static final String NODE_PROPERTY_TE_PERIOD = "slingevent:period";
    public static final String EVENT_NODE_TYPE = "slingevent:Event";
    public static final String JOB_NODE_TYPE = "slingevent:Job";
    public static final String TIMED_EVENT_NODE_TYPE = "slingevent:TimedEvent";
    public static final String NODETYPE_FOLDER = "sling:Folder";
    public static final String NODETYPE_ORDERED_FOLDER = "sling:OrderedFolder";
    private static final String ALLOWED_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789_,.-+*#!\ufffd$%&()=[]?";
    private static final char REPLACEMENT_CHAR = '_';
    private static final String[] IGNORE_PROPERTIES = new String[]{"event.distribute", "event.application", "slingevent:eventId", EventUtil.JobStatusNotifier.CONTEXT_PROPERTY_NAME};
    private static final String[] IGNORE_PREFIXES = new String[]{"slingevent:"};
    public static final char[] hexTable = "0123456789abcdef".toCharArray();

    public static String filter(String nodeName) {
        StringBuffer sb = new StringBuffer();
        int lastAdded = 0;
        for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            int toAdd = c;
            if (ALLOWED_CHARS.indexOf(c) < 0) {
                if (lastAdded == 95) continue;
                toAdd = 95;
            } else if (i == 0 && Character.isDigit(c)) {
                sb.append('_');
            }
            sb.append((char)toAdd);
            lastAdded = toAdd;
        }
        if (sb.length() == 0) {
            sb.append('_');
        }
        return sb.toString();
    }

    public static String md5(String data) {
        try {
            return EventHelper.digest("MD5", data.getBytes("utf-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 digest not available???");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("UTF8 digest not available???");
        }
    }

    private static String digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] digest = md.digest(data);
        StringBuffer res = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            res.append(hexTable[b >> 4 & 0xF]);
            res.append(hexTable[b & 0xF]);
        }
        return res.toString();
    }

    private static boolean ignoreProperty(String name) {
        for (String prop : IGNORE_PROPERTIES) {
            if (!prop.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void writeEventProperties(Node node, Event event) throws RepositoryException {
        String[] propNames;
        if (event != null && (propNames = event.getPropertyNames()) != null && propNames.length > 0) {
            ArrayList<String> propsAsBlob = new ArrayList<String>();
            for (String name : propNames) {
                Object value;
                if (EventHelper.ignoreProperty(name) || (value = event.getProperty(name)) == null || EventHelper.setProperty(name, value, node)) continue;
                propsAsBlob.add(name);
            }
            if (propsAsBlob.size() > 0) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeInt(propsAsBlob.size());
                    for (String propName : propsAsBlob) {
                        oos.writeObject(propName);
                        try {
                            oos.writeObject(event.getProperty(propName));
                        }
                        catch (IOException ioe) {
                            throw new RepositoryException("Unable to serialize property " + propName, (Throwable)ioe);
                        }
                    }
                    oos.close();
                    node.setProperty(NODE_PROPERTY_PROPERTIES, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                }
                catch (IOException ioe) {
                    throw new RepositoryException("Unable to serialize event " + EventUtil.toString(event), (Throwable)ioe);
                }
            }
        }
    }

    public static Dictionary<String, Object> readEventProperties(Node node, ClassLoader objectClassLoader) throws RepositoryException, ClassNotFoundException {
        Object value;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (node.hasProperty(NODE_PROPERTY_PROPERTIES)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(node.getProperty(NODE_PROPERTY_PROPERTIES).getStream(), objectClassLoader);
                int length = ois.readInt();
                for (int i = 0; i < length; ++i) {
                    String key = (String)ois.readObject();
                    value = ois.readObject();
                    ((Dictionary)properties).put(key, value);
                }
            }
            catch (InvalidClassException ice) {
                throw new ClassNotFoundException("Found invalid class.", ice);
            }
            catch (IOException ioe) {
                throw new RepositoryException("Unable to deserialize event properties.", (Throwable)ioe);
            }
        }
        PropertyIterator pI = node.getProperties();
        while (pI.hasNext()) {
            Property p = pI.nextProperty();
            boolean ignore = p.getName().startsWith("jcr:");
            if (!ignore) {
                for (int index = 0; !ignore && index < IGNORE_PREFIXES.length; ++index) {
                    ignore = p.getName().startsWith(IGNORE_PREFIXES[index]);
                }
            }
            if (ignore) continue;
            String name = ISO9075.decode((String)p.getName());
            if (p.getDefinition().isMultiple()) {
                Value[] values = p.getValues();
                if (values.length <= 0) continue;
                Object firstObject = EventHelper.getPropertyValue(values[0]);
                Object[] array = firstObject instanceof Boolean ? new Boolean[values.length] : (firstObject instanceof Calendar ? new Calendar[values.length] : (firstObject instanceof Double ? new Double[values.length] : (firstObject instanceof Long ? new Long[values.length] : new String[values.length])));
                array[0] = firstObject;
                for (int index = 1; index < values.length; ++index) {
                    array[index] = EventHelper.getPropertyValue(values[index]);
                }
                ((Dictionary)properties).put(name, array);
                continue;
            }
            value = p.getValue();
            Object o = EventHelper.getPropertyValue((Value)value);
            ((Dictionary)properties).put(name, o);
        }
        return properties;
    }

    public static String getNodePropertyName(String name) {
        if (name.indexOf(58) != -1) {
            return null;
        }
        return ISO9075.encode((String)name);
    }

    public static Value getNodePropertyValue(ValueFactory valueFactory, Object eventValue) {
        Object val = eventValue instanceof Calendar ? valueFactory.createValue((Calendar)eventValue) : (eventValue instanceof Long ? valueFactory.createValue(((Long)eventValue).longValue()) : (eventValue instanceof Double ? valueFactory.createValue(((Double)eventValue).doubleValue()) : (eventValue instanceof Boolean ? valueFactory.createValue(((Boolean)eventValue).booleanValue()) : (eventValue instanceof String ? valueFactory.createValue((String)eventValue) : null))));
        return val;
    }

    private static Object getPropertyValue(Value value) throws RepositoryException {
        Object o;
        switch (value.getType()) {
            case 6: {
                o = value.getBoolean();
                break;
            }
            case 5: {
                o = value.getDate();
                break;
            }
            case 4: {
                o = value.getDouble();
                break;
            }
            case 3: {
                o = value.getLong();
                break;
            }
            case 1: {
                o = value.getString();
                break;
            }
            default: {
                o = value.getString();
            }
        }
        return o;
    }

    private static boolean setProperty(String name, Object value, Node node) throws RepositoryException {
        String propName = EventHelper.getNodePropertyName(name);
        if (propName == null) {
            return false;
        }
        ValueFactory fac = node.getSession().getValueFactory();
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            Value[] values = new Value[array.length];
            int index = 0;
            for (Object v : array) {
                values[index] = EventHelper.getNodePropertyValue(fac, v);
                if (values[index] == null) {
                    return false;
                }
                if (index > 0 && !values[index - 1].getClass().equals(values[index].getClass())) {
                    return false;
                }
                ++index;
            }
            node.setProperty(propName, values);
            return true;
        }
        Value val = EventHelper.getNodePropertyValue(fac, value);
        if (val != null) {
            node.setProperty(propName, val);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectInputStream
    extends java.io.ObjectInputStream {
        private ClassLoader classloader;

        public ObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classloader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.classloader != null) {
                return Class.forName(classDesc.getName(), true, this.classloader);
            }
            return super.resolveClass(classDesc);
        }
    }
}

