/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobBlockingQueue
extends LinkedBlockingQueue<AbstractRepositoryEventHandler.EventInfo> {
    private volatile AbstractRepositoryEventHandler.EventInfo eventInfo;
    private final Object lock = new Object();
    private volatile boolean isWaiting = false;
    private volatile boolean markForCleanUp = false;
    private volatile boolean finished = false;
    private volatile boolean isSleeping = false;
    private volatile String schedulerJobName;
    private volatile Thread sleepingThread;

    public AbstractRepositoryEventHandler.EventInfo waitForFinish() throws InterruptedException {
        this.isWaiting = true;
        this.markForCleanUp = false;
        this.lock.wait();
        this.isWaiting = false;
        AbstractRepositoryEventHandler.EventInfo object = this.eventInfo;
        this.eventInfo = null;
        return object;
    }

    public void markForCleanUp() {
        if (!this.isWaiting) {
            this.markForCleanUp = true;
        }
    }

    public boolean isMarkedForCleanUp() {
        return !this.isWaiting && this.markForCleanUp;
    }

    public void notifyFinish(AbstractRepositoryEventHandler.EventInfo i) {
        this.eventInfo = i;
        this.lock.notify();
    }

    public Object getLock() {
        return this.lock;
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean flag) {
        this.finished = flag;
    }

    public void setSleeping(boolean flag) {
        this.isSleeping = flag;
        if (!flag) {
            this.schedulerJobName = null;
            this.sleepingThread = null;
        }
    }

    public void setSleeping(boolean flag, String schedulerJobName) {
        this.schedulerJobName = schedulerJobName;
        this.setSleeping(flag);
    }

    public void setSleeping(boolean flag, Thread sleepingThread) {
        this.sleepingThread = sleepingThread;
        this.setSleeping(flag);
    }

    public String getSchedulerJobName() {
        return this.schedulerJobName;
    }

    public Thread getSleepingThread() {
        return this.sleepingThread;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }
}

