/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.sling.event.JobProcessor;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;
import org.apache.sling.event.impl.JobEventHandler;
import org.apache.sling.event.impl.job.JobStatusNotifier;
import org.osgi.service.event.Event;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventUtil {
    public static final String PROPERTY_DISTRIBUTE = "event.distribute";
    public static final String PROPERTY_APPLICATION = "event.application";
    public static final String PROPERTY_JOB_TOPIC = "event.job.topic";
    public static final String PROPERTY_JOB_ID = "event.job.id";
    public static final String PROPERTY_JOB_PARALLEL = "event.job.parallel";
    public static final String PROPERTY_JOB_RUN_LOCAL = "event.job.run.local";
    public static final String PROPERTY_JOB_RETRY_COUNT = "event.job.retrycount";
    public static final String PROPERTY_JOB_RETRIES = "event.job.retries";
    public static final String PROPERTY_JOB_RETRY_DELAY = "event.job.retrydelay";
    public static final String PROPERTY_JOB_QUEUE_NAME = "event.job.queuename";
    public static final String PROPERTY_JOB_QUEUE_ORDERED = "event.job.queueordered";
    public static final String TOPIC_JOB = "org/apache/sling/event/job";
    public static final String TOPIC_TIMED_EVENT = "org/apache/sling/event/timed";
    public static final String PROPERTY_TIMED_EVENT_TOPIC = "event.topic.timed";
    public static final String PROPERTY_TIMED_EVENT_ID = "event.timed.id";
    public static final String PROPERTY_TIMED_EVENT_SCHEDULE = "event.timed.scheduler";
    public static final String PROPERTY_TIMED_EVENT_PERIOD = "event.timed.period";
    public static final String PROPERTY_TIMED_EVENT_DATE = "event.timed.date";
    public static final String TOPIC_JOB_STARTED = "org/apache/sling/event/notification/job/START";
    public static final String TOPIC_JOB_FINISHED = "org/apache/sling/event/notification/job/FINISHED";
    public static final String TOPIC_JOB_FAILED = "org/apache/sling/event/notification/job/FAILED";
    public static final String TOPIC_JOB_CANCELLED = "org/apache/sling/event/notification/job/CANCELLED";
    public static final String PROPERTY_NOTIFICATION_JOB = "event.notification.job";

    public static Event createDistributableEvent(String topic, Dictionary<String, Object> properties) {
        Hashtable<String, Object> newProperties = new Hashtable<String, Object>();
        if (properties != null) {
            Enumeration<String> e = properties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                ((Dictionary)newProperties).put(key, properties.get(key));
            }
        }
        ((Dictionary)newProperties).put(PROPERTY_DISTRIBUTE, "");
        return new Event(topic, newProperties);
    }

    public static boolean shouldDistribute(Event event) {
        return event.getProperty(PROPERTY_DISTRIBUTE) != null;
    }

    public static boolean isLocal(Event event) {
        String appId = EventUtil.getApplicationId(event);
        return appId == null || appId.equals(AbstractRepositoryEventHandler.APPLICATION_ID);
    }

    public static String getApplicationId(Event event) {
        return (String)event.getProperty(PROPERTY_APPLICATION);
    }

    public static boolean isJobEvent(Event event) {
        return event.getProperty(PROPERTY_JOB_TOPIC) != null;
    }

    private static JobStatusNotifier.NotifierContext getNotifierContext(Event job) {
        if (!EventUtil.isJobEvent(job)) {
            return null;
        }
        JobStatusNotifier.NotifierContext ctx = (JobStatusNotifier.NotifierContext)job.getProperty(JobStatusNotifier.CONTEXT_PROPERTY_NAME);
        if (ctx == null) {
            throw new IllegalArgumentException("JobStatusNotifier context is not available in event properties.");
        }
        return ctx;
    }

    public static boolean acknowledgeJob(Event job) {
        JobStatusNotifier.NotifierContext ctx = EventUtil.getNotifierContext(job);
        if (ctx != null) {
            if (!ctx.notifier.sendAcknowledge(job, ctx.eventNodePath)) {
                LoggerFactory.getLogger(EventUtil.class).info("Someone else is already processing job {}.", (Object)job);
                return false;
            }
            return true;
        }
        return false;
    }

    public static void finishedJob(Event job) {
        JobStatusNotifier.NotifierContext ctx = EventUtil.getNotifierContext(job);
        if (ctx != null) {
            ctx.notifier.finishedJob(job, ctx.eventNodePath, false);
        }
    }

    public static boolean rescheduleJob(Event job) {
        JobStatusNotifier.NotifierContext ctx = EventUtil.getNotifierContext(job);
        if (ctx != null) {
            return ctx.notifier.finishedJob(job, ctx.eventNodePath, true);
        }
        return false;
    }

    public static void processJob(final Event job, final JobProcessor processor) {
        boolean notify = true;
        JobStatusNotifier.NotifierContext ctx = EventUtil.getNotifierContext(job);
        if (ctx != null && !ctx.notifier.sendAcknowledge(job, ctx.eventNodePath)) {
            LoggerFactory.getLogger(EventUtil.class).info("Someone else is already processing job {}.", (Object)job);
            notify = false;
        }
        final boolean notifyResult = notify;
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block7: {
                    boolean result = false;
                    try {
                        try {
                            result = processor.process(job);
                        }
                        catch (Throwable t) {
                            LoggerFactory.getLogger(EventUtil.class).error("Unhandled error occured in job processor " + t.getMessage() + " while processing job " + job, t);
                            result = true;
                            Object var4_3 = null;
                            if (!notifyResult) return;
                            if (result) {
                                EventUtil.finishedJob(job);
                                return;
                            }
                            EventUtil.rescheduleJob(job);
                            return;
                        }
                        Object var4_2 = null;
                        if (!notifyResult) return;
                        if (!result) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (!notifyResult) throw throwable;
                        if (result) {
                            EventUtil.finishedJob(job);
                            throw throwable;
                        }
                        EventUtil.rescheduleJob(job);
                        throw throwable;
                    }
                    EventUtil.finishedJob(job);
                    return;
                }
                EventUtil.rescheduleJob(job);
            }
        };
        if (JobEventHandler.JOB_THREAD_POOL != null) {
            JobEventHandler.JOB_THREAD_POOL.execute(task);
        } else {
            new Thread(task).start();
        }
    }

    public static String toString(Event e) {
        if (e == null) {
            return "<null>";
        }
        StringBuilder buffer = new StringBuilder(e.getClass().getName());
        buffer.append('(');
        buffer.append(e.hashCode());
        buffer.append(") [topic=");
        buffer.append(e.getTopic());
        buffer.append(", properties=");
        String[] names = e.getPropertyNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(names[i]);
                buffer.append('=');
                buffer.append(e.getProperty(names[i]));
            }
        }
        buffer.append("]");
        return buffer.toString();
    }
}

