/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.JobStatusProvider;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;
import org.apache.sling.event.impl.EventHelper;
import org.apache.sling.event.impl.job.JobBlockingQueue;
import org.apache.sling.event.impl.job.JobStatusNotifier;
import org.apache.sling.event.impl.job.JobUtil;
import org.apache.sling.event.impl.job.ParallelInfo;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEventHandler
extends AbstractRepositoryEventHandler
implements JobStatusNotifier,
JobStatusProvider,
Runnable {
    private final Map<String, Boolean> processingMap = new HashMap<String, Boolean>();
    private final Map<String, Integer> parallelProcessingMap = new HashMap<String, Integer>();
    private final Map<String, JobBlockingQueue> jobQueues = new HashMap<String, JobBlockingQueue>();
    private static final long DEFAULT_SLEEP_TIME = 30L;
    private static final int DEFAULT_MAX_JOB_RETRIES = 10;
    private static final String CONFIG_PROPERTY_SLEEP_TIME = "sleep.time";
    private static final String CONFIG_PROPERTY_MAX_JOB_RETRIES = "max.job.retries";
    private static final long DEFAULT_WAIT_FOR_ACK = 90L;
    private static final long DEFAULT_MAXIMUM_PARALLEL_JOBS = 15L;
    private static final int DEFAULT_MAXIMUM_JOB_QUEUES = 10;
    private static final String CONFIG_PROPERTY_MAXIMUM_PARALLEL_JOBS = "max.parallel.jobs";
    private static final String CONFIG_PROPERTY_WAIT_FOR_ACK = "wait.for.ack";
    private static final String CONFIG_PROPERTY_MAXIMUM_JOB_QUEUES = "max.job.queues";
    private long sleepTime;
    private int maxJobRetries;
    private long waitForAckMs;
    private long maximumParallelJobs;
    protected Session backgroundSession;
    private Set<String> unloadedJobs = new HashSet<String>();
    private Set<String> deletedJobs = new HashSet<String>();
    private static final int DEFAULT_CLEANUP_PERIOD = 5;
    private static final String CONFIG_PROPERTY_CLEANUP_PERIOD = "cleanup.period";
    private int cleanupPeriod = 5;
    protected Scheduler scheduler;
    private ComponentContext componentContext;
    private final Map<String, StartedJobInfo> processingEventsList = new HashMap<String, StartedJobInfo>();
    public static volatile ThreadPool JOB_THREAD_POOL;
    private final Object writeLock = new Object();
    private final Object backgroundLock = new Object();
    private volatile long parallelJobCount;
    private long maxLoadJobs;
    private int maxJobQueues;
    private static final long DEFAULT_MAXIMUM_LOAD_JOBS = 1000L;
    private static final String CONFIG_PROPERTY_MAX_LOAD_JOBS = "max.load.jobs";
    private long loadThreshold;
    private static final long DEFAULT_LOAD_THRESHOLD = 400L;
    private static final String CONFIG_PROPERTY_LOAD_THREASHOLD = "load.threshold";
    private long backgroundLoadDelay;
    private static final long DEFAULT_BACKGROUND_LOAD_DELAY = 30L;
    private static final String CONFIG_PROPERTY_BACKGROUND_LOAD_DELAY = "load.delay";
    private long backgroundCheckDelay;
    private static final long DEFAULT_BACKGROUND_CHECK_DELAY = 240L;
    private static final String CONFIG_PROPERTY_BACKGROUND_CHECK_DELAY = "load.checkdelay";
    private long startTime;

    @Override
    protected void activate(ComponentContext context) throws Exception {
        Dictionary props = context.getProperties();
        this.cleanupPeriod = OsgiUtil.toInteger(props.get(CONFIG_PROPERTY_CLEANUP_PERIOD), (int)5);
        this.sleepTime = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_SLEEP_TIME), (long)30L);
        this.maxJobRetries = OsgiUtil.toInteger(props.get(CONFIG_PROPERTY_MAX_JOB_RETRIES), (int)10);
        this.waitForAckMs = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_WAIT_FOR_ACK), (long)90L) * 1000L;
        this.maximumParallelJobs = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_MAXIMUM_PARALLEL_JOBS), (long)15L);
        this.maxLoadJobs = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_MAX_LOAD_JOBS), (long)1000L);
        this.loadThreshold = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_LOAD_THREASHOLD), (long)400L);
        this.backgroundLoadDelay = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_BACKGROUND_LOAD_DELAY), (long)30L);
        this.backgroundCheckDelay = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_BACKGROUND_CHECK_DELAY), (long)240L);
        this.maxJobQueues = OsgiUtil.toInteger(props.get(CONFIG_PROPERTY_MAXIMUM_JOB_QUEUES), (int)10);
        this.componentContext = context;
        super.activate(context);
        JOB_THREAD_POOL = this.threadPool;
        this.startTime = System.currentTimeMillis();
        this.threadPool.execute(new Runnable(){

            public void run() {
                JobEventHandler.this.loadJobsInTheBackground();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
        Object object = this.jobQueues;
        synchronized (object) {
            for (JobBlockingQueue jbq : this.jobQueues.values()) {
                this.logger.debug("Shutting down job queue {}", (Object)jbq.getName());
                this.logger.debug("Waking up sleeping queue {}", (Object)jbq.getName());
                this.wakeUpJobQueue(jbq);
                if (jbq.isWaiting()) {
                    this.logger.debug("Waking up waiting queue {}", (Object)jbq.getName());
                    Object object2 = jbq.getLock();
                    synchronized (object2) {
                        jbq.notifyFinish(null);
                    }
                }
                try {
                    jbq.put(new AbstractRepositoryEventHandler.EventInfo());
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
                this.logger.info("Stopped job queue {}", (Object)jbq.getName());
            }
        }
        if (this.backgroundSession != null) {
            object = this.backgroundLock;
            synchronized (object) {
                this.logger.debug("Shutting down background session.");
                this.backgroundLock.notify();
                try {
                    this.backgroundSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Unable to remove event listener.", (Throwable)e);
                }
                this.backgroundSession.logout();
                this.backgroundSession = null;
            }
        }
        this.componentContext = null;
        if (JOB_THREAD_POOL == this.threadPool) {
            JOB_THREAD_POOL = null;
        }
    }

    private String getCleanUpQueryString() {
        Calendar deleteBefore = Calendar.getInstance();
        deleteBefore.add(12, -this.cleanupPeriod);
        String dateString = ISO8601.format(deleteBefore);
        StringBuilder buffer = new StringBuilder("/jcr:root");
        buffer.append(this.repositoryPath);
        buffer.append("//element(*, ");
        buffer.append(this.getEventNodeType());
        buffer.append(")[@");
        buffer.append("slingevent:finished");
        buffer.append(" < xs:dateTime('");
        buffer.append(dateString);
        buffer.append("')]");
        return buffer.toString();
    }

    private void loadJobsInTheBackground() {
        try {
            Thread.sleep(1000L * this.backgroundLoadDelay);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        if (this.running) {
            this.logger.debug("Starting background loading.");
            long loadSince = -1L;
            do {
                loadSince = this.loadJobs(loadSince);
                if (!this.running || loadSince <= -1L) continue;
                do {
                    try {
                        Thread.sleep(1000L * this.backgroundCheckDelay);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                } while (this.running && (long)this.queue.size() > this.loadThreshold);
            } while (this.running && loadSince > -1L);
            this.logger.debug("Finished background loading.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            Query q;
            long tooOld = System.currentTimeMillis() - this.waitForAckMs;
            ArrayList<StartedJobInfo> restartJobs = new ArrayList<StartedJobInfo>();
            Map<String, StartedJobInfo> map = this.processingEventsList;
            synchronized (map) {
                for (Map.Entry<String, StartedJobInfo> entry : this.processingEventsList.entrySet()) {
                    if (entry.getValue().started > tooOld) continue;
                    restartJobs.add(entry.getValue());
                }
            }
            if (this.cleanupPeriod > 0) {
                this.logger.debug("Cleaning up repository, removing all finished jobs older than {} minutes.", (Object)this.cleanupPeriod);
                String queryString = this.getCleanUpQueryString();
                Session s = null;
                try {
                    s = this.createSession();
                    Node parentNode = (Node)s.getItem(this.repositoryPath);
                    this.logger.debug("Executing query {}", (Object)queryString);
                    q = s.getWorkspace().getQueryManager().createQuery(queryString, "xpath");
                    NodeIterator iter = q.execute().getNodes();
                    int count = 0;
                    while (iter.hasNext()) {
                        Node eventNode = iter.nextNode();
                        eventNode.remove();
                        ++count;
                    }
                    parentNode.save();
                    this.logger.debug("Removed {} entries from the repository.", (Object)count);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Exception during repository cleanup.", (Throwable)e);
                }
                finally {
                    if (s != null) {
                        s.logout();
                    }
                }
            }
            if (restartJobs.size() > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
            for (StartedJobInfo info : restartJobs) {
                boolean process = false;
                q = this.processingEventsList;
                synchronized (q) {
                    process = this.processingEventsList.remove(info.nodePath) != null;
                }
                if (!process) continue;
                this.logger.info("No acknowledge received for job {} stored at {}. Requeueing job.", (Object)EventUtil.toString(info.event), (Object)info.nodePath);
                this.finishedJob(info.event, info.nodePath, true);
            }
            Map<String, JobBlockingQueue> map2 = this.jobQueues;
            synchronized (map2) {
                Iterator<Map.Entry<String, JobBlockingQueue>> i = this.jobQueues.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, JobBlockingQueue> current = i.next();
                    JobBlockingQueue jbq = current.getValue();
                    if (jbq.size() != 0) continue;
                    if (jbq.isMarkedForCleanUp()) {
                        jbq.setFinished(true);
                        try {
                            jbq.put(new AbstractRepositoryEventHandler.EventInfo());
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                        }
                        i.remove();
                        continue;
                    }
                    jbq.markForCleanUp();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processWriteQueue() {
        while (this.running) {
            Object object;
            org.osgi.service.event.Event event = null;
            try {
                event = (org.osgi.service.event.Event)this.writeQueue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (event == null || !this.running) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Persisting job {}", (Object)EventUtil.toString(event));
            }
            AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
            info.event = event;
            String jobId = (String)event.getProperty("event.job.id");
            String jobTopic = (String)event.getProperty("event.job.topic");
            String nodePath = JobUtil.getUniquePath(jobTopic, jobId);
            if (jobId == null) {
                try {
                    object = this.writeLock;
                    synchronized (object) {
                        Node eventNode = this.writeEvent(event, nodePath);
                        info.nodePath = eventNode.getPath();
                    }
                }
                catch (RepositoryException re) {
                    this.logger.error("Exception during writing new job '" + EventUtil.toString(event) + "' to repository at " + nodePath, (Throwable)re);
                }
            } else {
                object = this.writeLock;
                synchronized (object) {
                    block26: {
                        try {
                            this.writerSession.refresh(false);
                        }
                        catch (RepositoryException re) {
                            this.ignoreException((Exception)((Object)re));
                        }
                        try {
                            Node parentNode = this.getWriterRootNode();
                            Node foundNode = null;
                            if (parentNode.hasNode(nodePath)) {
                                foundNode = parentNode.getNode(nodePath);
                            }
                            if (foundNode != null) {
                                if (foundNode.isLocked()) break block26;
                                try {
                                    if (!foundNode.hasProperty("slingevent:finished")) {
                                        info.nodePath = foundNode.getPath();
                                    }
                                    break block26;
                                }
                                catch (RepositoryException re) {}
                                break block26;
                            }
                            try {
                                Node eventNode = this.writeEvent(event, nodePath);
                                info.nodePath = eventNode.getPath();
                            }
                            catch (ItemExistsException iee) {}
                        }
                        catch (RepositoryException re) {
                            this.logger.error("Exception during writing new job '" + EventUtil.toString(event) + "' to repository at " + nodePath, (Throwable)re);
                        }
                    }
                }
            }
            if (info.nodePath == null) continue;
            this.queueJob(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueJob(AbstractRepositoryEventHandler.EventInfo info) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received new job {}", (Object)EventUtil.toString(info.event));
        }
        String appId = (String)info.event.getProperty("event.application");
        if (info.event.getProperty("event.job.run.local") != null && appId != null && !this.applicationId.equals(appId)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Discarding job {} : local job for a different application node.", (Object)EventUtil.toString(info.event));
            }
        } else {
            boolean queued = false;
            if (info.event.getProperty("event.job.queuename") != null) {
                final String queueName = (String)info.event.getProperty("event.job.queuename");
                Map<String, JobBlockingQueue> map = this.jobQueues;
                synchronized (map) {
                    BlockingQueue jobQueue = this.jobQueues.get(queueName);
                    if (jobQueue == null) {
                        if (this.jobQueues.size() >= this.maxJobQueues) {
                            this.logger.warn("Unable to create new job queue named {} as there are already {} job queues. Try to increase the maximum number of job queues!", (Object)queueName, (Object)this.jobQueues.size());
                        } else {
                            final boolean orderedQueue = info.event.getProperty("event.job.queueordered") != null;
                            final JobBlockingQueue jq = new JobBlockingQueue(queueName, orderedQueue, this.logger);
                            jobQueue = jq;
                            this.jobQueues.put(queueName, jq);
                            this.threadPool.execute(new Runnable(){

                                public void run() {
                                    while (JobEventHandler.this.running && !jq.isFinished()) {
                                        JobEventHandler.this.logger.info("Starting {}job queue {}", (Object)(orderedQueue ? "ordered " : ""), (Object)queueName);
                                        try {
                                            JobEventHandler.this.runJobQueue(queueName, jq);
                                        }
                                        catch (Throwable t) {
                                            JobEventHandler.this.logger.error("Job queue stopped with exception: " + t.getMessage() + ". Restarting.", t);
                                        }
                                    }
                                }
                            });
                        }
                    }
                    if (jobQueue != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Queuing job {} into queue {}.", (Object)EventUtil.toString(info.event), (Object)queueName);
                        }
                        try {
                            jobQueue.put(info);
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                        }
                        queued = true;
                    }
                }
            }
            if (!queued) {
                try {
                    this.queue.put(info);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
        }
    }

    @Override
    protected void runInBackground() throws RepositoryException {
        this.backgroundSession = this.createSession();
        this.backgroundSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 10, this.repositoryPath, true, null, new String[]{this.getEventNodeType()}, true);
        if (this.running) {
            this.logger.info("Apache Sling Job Event Handler started.");
            this.logger.debug("Job Handler Configuration: (sleepTime={} secs, maxJobRetries={}, waitForAck={} ms, maximumParallelJobs={}, cleanupPeriod={} min, maxJobQueues={})", new Object[]{this.sleepTime, this.maxJobRetries, this.waitForAckMs, this.maximumParallelJobs, this.cleanupPeriod, this.maxJobQueues});
        } else {
            ComponentContext ctx = this.componentContext;
            if (ctx != null) {
                this.logger.info("Deactivating component {} due to errors during startup.", ctx.getProperties().get("service.id"));
                String name = (String)this.componentContext.getProperties().get("component.name");
                ctx.disableComponent(name);
            }
        }
        while (this.running) {
            AbstractRepositoryEventHandler.EventInfo info = null;
            try {
                info = (AbstractRepositoryEventHandler.EventInfo)this.queue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (info == null || !this.running || this.executeJob(info, null) != Status.RESCHEDULE) continue;
            this.putBackIntoMainQueue(info, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobQueue(String queueName, JobBlockingQueue jobQueue) {
        AbstractRepositoryEventHandler.EventInfo info = null;
        while (this.running && !jobQueue.isFinished()) {
            Object status;
            if (info == null) {
                try {
                    info = (AbstractRepositoryEventHandler.EventInfo)jobQueue.take();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
            if (info == null || !this.running || jobQueue.isFinished()) continue;
            AbstractRepositoryEventHandler.EventInfo processInfo = info;
            info = null;
            if (jobQueue.isOrdered()) {
                Object object = jobQueue.getLock();
                synchronized (object) {
                    status = this.executeJob(processInfo, jobQueue);
                    if (status == Status.SUCCESS) {
                        try {
                            info = jobQueue.waitForFinish();
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                        }
                    } else if (status == Status.RESCHEDULE) {
                        info = jobQueue.reschedule(processInfo, this.scheduler);
                    }
                    continue;
                }
            }
            int maxJobs = ParallelInfo.getMaxNumberOfParallelJobs(processInfo.event);
            status = jobQueue.getLock();
            synchronized (status) {
                try {
                    jobQueue.acquireSlot(maxJobs);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
            if (!this.running || jobQueue.isFinished() || (status = this.executeJob(processInfo, jobQueue)) != Status.RESCHEDULE) continue;
            jobQueue.reschedule(processInfo, this.scheduler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPrecondition(ParallelInfo parInfo, String jobTopic) {
        boolean process = parInfo.processParallel;
        if (!parInfo.processParallel) {
            Map<String, Boolean> map = this.processingMap;
            synchronized (map) {
                Boolean value = this.processingMap.get(jobTopic);
                if (value == null || !value.booleanValue()) {
                    this.processingMap.put(jobTopic, Boolean.TRUE);
                    process = true;
                }
            }
        }
        if (parInfo.maxParallelJob > 1) {
            Map<String, Integer> map = this.parallelProcessingMap;
            synchronized (map) {
                int currentValue;
                Integer value = this.parallelProcessingMap.get(jobTopic);
                int n = currentValue = value == null ? 0 : value;
                if (currentValue < parInfo.maxParallelJob) {
                    this.parallelProcessingMap.put(jobTopic, currentValue + 1);
                } else {
                    process = false;
                }
            }
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockState(ParallelInfo parInfo, String jobTopic) {
        if (!parInfo.processParallel) {
            Map<String, Boolean> map = this.processingMap;
            synchronized (map) {
                this.processingMap.put(jobTopic, Boolean.FALSE);
            }
        }
        if (parInfo.maxParallelJob > 1) {
            Map<String, Integer> map = this.parallelProcessingMap;
            synchronized (map) {
                Integer value = this.parallelProcessingMap.get(jobTopic);
                this.parallelProcessingMap.put(jobTopic, value - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Status executeJob(AbstractRepositoryEventHandler.EventInfo info, BlockingQueue<AbstractRepositoryEventHandler.EventInfo> jobQueue) {
        boolean putback = false;
        Object object = this.backgroundLock;
        synchronized (object) {
            block27: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Executing job {}.", (Object)EventUtil.toString(info.event));
                }
                try {
                    this.backgroundSession.refresh(false);
                    if (!this.backgroundSession.itemExists(info.nodePath) || this.backgroundSession.itemExists(info.nodePath + '/' + "slingevent:finished")) break block27;
                    org.osgi.service.event.Event event = info.event;
                    String jobTopic = (String)event.getProperty("event.job.topic");
                    ParallelInfo parInfo = ParallelInfo.getParallelInfo(event);
                    boolean process = this.checkPrecondition(parInfo, jobTopic);
                    if (process && jobQueue == null && this.parallelJobCount >= this.maximumParallelJobs) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Waiting with executing job {} - maximum parallel job count of {} reached!", (Object)EventUtil.toString(info.event), (Object)this.maximumParallelJobs);
                        }
                        try {
                            this.backgroundLock.wait();
                        }
                        catch (InterruptedException e) {
                            this.ignoreException(e);
                        }
                        if (!this.running) {
                            return Status.FAILED;
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Continuing with executing job {}.", (Object)EventUtil.toString(info.event));
                        }
                    }
                    if (process) {
                        boolean unlock = true;
                        try {
                            Node eventNode = (Node)this.backgroundSession.getItem(info.nodePath);
                            if (eventNode.isLocked()) break block27;
                            try {
                                eventNode.lock(false, true);
                            }
                            catch (RepositoryException re) {
                                Status status = Status.FAILED;
                                if (unlock) {
                                    this.unlockState(parInfo, jobTopic);
                                }
                                return status;
                            }
                            unlock = false;
                            this.processJob(info.event, eventNode, jobQueue == null, parInfo);
                            Status status = Status.SUCCESS;
                            return status;
                        }
                        catch (RepositoryException e) {
                            this.ignoreException((Exception)((Object)e));
                            break block27;
                        }
                        finally {
                            if (unlock) {
                                this.unlockState(parInfo, jobTopic);
                            }
                        }
                    }
                    try {
                        Node eventNode = (Node)this.backgroundSession.getItem(info.nodePath);
                        if (!eventNode.isLocked() && !eventNode.hasProperty("slingevent:finished")) {
                            putback = true;
                        }
                    }
                    catch (RepositoryException e) {
                        this.ignoreException((Exception)((Object)e));
                    }
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
            }
        }
        if (putback) {
            return Status.RESCHEDULE;
        }
        return Status.FAILED;
    }

    @Override
    protected String getEventNodeType() {
        return "slingevent:Job";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(org.osgi.service.event.Event event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Receiving event {}", (Object)EventUtil.toString(event));
        }
        if (EventUtil.isLocal(event)) {
            if (event.getTopic().equals("org/apache/sling/event/job")) {
                String jobTopic;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Handling local job {}", (Object)EventUtil.toString(event));
                }
                if ((jobTopic = (String)event.getProperty("event.job.topic")) != null) {
                    try {
                        this.writeQueue.put(event);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                } else {
                    this.logger.warn("Event does not contain job topic: {}", (Object)EventUtil.toString(event));
                }
            } else {
                boolean doIt = false;
                Set<String> e = this.unloadedJobs;
                synchronized (e) {
                    if (this.unloadedJobs.size() > 0) {
                        doIt = true;
                    }
                }
                if (doIt) {
                    Runnable t = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Set set = JobEventHandler.this.unloadedJobs;
                            synchronized (set) {
                                Session s = null;
                                HashSet<String> newUnloadedJobs = new HashSet<String>();
                                newUnloadedJobs.addAll(JobEventHandler.this.unloadedJobs);
                                try {
                                    s = JobEventHandler.this.createSession();
                                    for (String path : JobEventHandler.this.unloadedJobs) {
                                        newUnloadedJobs.remove(path);
                                        try {
                                            if (!s.itemExists(path)) continue;
                                            Node eventNode = (Node)s.getItem(path);
                                            JobEventHandler.this.tryToLoadJob(eventNode, newUnloadedJobs);
                                        }
                                        catch (RepositoryException re) {
                                            newUnloadedJobs.add(path);
                                            JobEventHandler.this.ignoreException((Exception)((Object)re));
                                        }
                                    }
                                }
                                catch (RepositoryException re) {
                                    JobEventHandler.this.ignoreException((Exception)((Object)re));
                                }
                                finally {
                                    if (s != null) {
                                        s.logout();
                                    }
                                    JobEventHandler.this.unloadedJobs.clear();
                                    JobEventHandler.this.unloadedJobs.addAll(newUnloadedJobs);
                                }
                            }
                        }
                    };
                    this.threadPool.execute(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJob(org.osgi.service.event.Event event, Node eventNode, boolean isMainQueue, ParallelInfo parInfo) {
        block19: {
            String jobTopic = (String)event.getProperty("event.job.topic");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting job {}", (Object)EventUtil.toString(event));
            }
            boolean unlock = true;
            try {
                if (isMainQueue) {
                    ++this.parallelJobCount;
                }
                String nodePath = eventNode.getPath();
                org.osgi.service.event.Event jobEvent = this.getJobEvent(event, nodePath);
                eventNode.setProperty("slingevent:processor", this.applicationId);
                eventNode.save();
                EventAdmin localEA = this.eventAdmin;
                if (localEA != null) {
                    StartedJobInfo jobInfo = new StartedJobInfo(jobEvent, nodePath, System.currentTimeMillis());
                    Map<String, StartedJobInfo> map = this.processingEventsList;
                    synchronized (map) {
                        this.processingEventsList.put(nodePath, jobInfo);
                    }
                    localEA.postEvent(jobEvent);
                    unlock = false;
                    break block19;
                }
                this.logger.error("Job event can't be sent as no event admin is available.");
            }
            catch (RepositoryException re) {
                this.logger.error("Exception during job processing.", (Throwable)re);
            }
            finally {
                if (unlock) {
                    if (isMainQueue) {
                        --this.parallelJobCount;
                    }
                    this.unlockState(parInfo, jobTopic);
                    try {
                        eventNode.unlock();
                    }
                    catch (RepositoryException e) {
                        this.ignoreException((Exception)((Object)e));
                    }
                }
            }
        }
    }

    private org.osgi.service.event.Event getJobEvent(org.osgi.service.event.Event e, String nodePath) {
        String eventTopic = (String)e.getProperty("event.job.topic");
        EventPropertiesMap properties = new EventPropertiesMap(e);
        ((Dictionary)properties).put(JobStatusNotifier.CONTEXT_PROPERTY_NAME, new JobStatusNotifier.NotifierContext(this, nodePath));
        return new org.osgi.service.event.Event(eventTopic, (Dictionary)properties);
    }

    @Override
    protected void addNodeProperties(Node eventNode, org.osgi.service.event.Event event) throws RepositoryException {
        super.addNodeProperties(eventNode, event);
        eventNode.setProperty("slingevent:topic", (String)event.getProperty("event.job.topic"));
        String jobId = (String)event.getProperty("event.job.id");
        if (jobId != null) {
            eventNode.setProperty("slingevent:id", jobId);
        }
        long retryCount = OsgiUtil.toLong((Object)event.getProperty("event.job.retrycount"), (long)0L);
        long retries = OsgiUtil.toLong((Object)event.getProperty("event.job.retries"), (long)this.maxJobRetries);
        eventNode.setProperty("event.job.retrycount", retryCount);
        eventNode.setProperty("event.job.retries", retries);
    }

    @Override
    protected void addEventProperties(Node eventNode, Dictionary<String, Object> properties) throws RepositoryException {
        super.addEventProperties(eventNode, properties);
        if (properties.get("event.job.retries") != null) {
            properties.put("event.job.retries", Integer.valueOf(properties.get("event.job.retries").toString()));
        }
        if (properties.get("event.job.retrycount") != null) {
            properties.put("event.job.retrycount", Integer.valueOf(properties.get("event.job.retrycount").toString()));
        }
        properties.put("event.application", eventNode.getProperty("slingevent:application").getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator iter) {
        block12: {
            Session s = null;
            block8: while (true) {
                while (iter.hasNext()) {
                    Event event = iter.nextEvent();
                    if (event.getType() != 16 && event.getType() != 8) continue;
                    try {
                        String propPath = event.getPath();
                        int pos = propPath.lastIndexOf(47);
                        String nodePath = propPath.substring(0, pos);
                        String propertyName = propPath.substring(pos + 1);
                        if (!"jcr:lockOwner".equals(propertyName)) continue block8;
                        boolean doNotProcess = false;
                        Set<String> set = this.deletedJobs;
                        synchronized (set) {
                            doNotProcess = this.deletedJobs.remove(nodePath);
                        }
                        if (doNotProcess) continue block8;
                        if (s == null) {
                            s = this.createSession();
                        }
                        Node eventNode = (Node)s.getItem(nodePath);
                        this.tryToLoadJob(eventNode, this.unloadedJobs);
                        continue block8;
                    }
                    catch (RepositoryException re) {
                        this.logger.error("Exception during jcr event processing.", (Throwable)re);
                    }
                }
                break block12;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        }
    }

    private long loadJobs(long since) {
        long maxLoad;
        long eventCreated = since;
        long l = maxLoad = since == -1L ? this.maxLoadJobs : this.maxLoadJobs - (long)this.queue.size();
        if (maxLoad > 0L) {
            this.logger.debug("Loading from repository since {} and max {}", (Object)since, (Object)maxLoad);
            try {
                String dateString;
                QueryManager qManager = this.backgroundSession.getWorkspace().getQueryManager();
                StringBuilder buffer = new StringBuilder("/jcr:root");
                buffer.append(this.repositoryPath);
                buffer.append("//element(*, ");
                buffer.append(this.getEventNodeType());
                buffer.append(") [not(@");
                buffer.append("slingevent:finished");
                buffer.append(")");
                if (since != -1L) {
                    Calendar beforeDate = Calendar.getInstance();
                    beforeDate.setTimeInMillis(since);
                    dateString = ISO8601.format(beforeDate);
                    buffer.append(" and @");
                    buffer.append("slingevent:created");
                    buffer.append(" >= xs:dateTime('");
                    buffer.append(dateString);
                    buffer.append("')");
                }
                Calendar startDate = Calendar.getInstance();
                startDate.setTimeInMillis(this.startTime);
                dateString = ISO8601.format(startDate);
                buffer.append(" and @");
                buffer.append("slingevent:created");
                buffer.append(" < xs:dateTime('");
                buffer.append(dateString);
                buffer.append("')");
                buffer.append("] order by @");
                buffer.append("slingevent:created");
                buffer.append(" ascending");
                Query q = qManager.createQuery(buffer.toString(), "xpath");
                NodeIterator result = q.execute().getNodes();
                long count = 0L;
                while (result.hasNext() && count < maxLoad) {
                    Node eventNode = result.nextNode();
                    eventCreated = eventNode.getProperty("slingevent:created").getLong();
                    if (!this.tryToLoadJob(eventNode, this.unloadedJobs)) continue;
                    ++count;
                }
                boolean done = false;
                while (result.hasNext() && !done) {
                    Node eventNode = result.nextNode();
                    long created = eventNode.getProperty("slingevent:created").getLong();
                    if (created == eventCreated) {
                        if (!this.tryToLoadJob(eventNode, this.unloadedJobs)) continue;
                        ++count;
                        continue;
                    }
                    done = true;
                }
                if (!done && !result.hasNext()) {
                    eventCreated = -1L;
                }
                this.logger.debug("Loaded {} jobs and new since {}", (Object)count, (Object)eventCreated);
            }
            catch (RepositoryException re) {
                this.logger.error("Exception during initial loading of stored jobs.", (Throwable)re);
            }
        }
        return eventCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToLoadJob(Node eventNode, Set<String> unloadedJobSet) {
        block8: {
            try {
                if (eventNode.isLocked() || eventNode.hasProperty("slingevent:finished")) break block8;
                String nodePath = eventNode.getPath();
                try {
                    org.osgi.service.event.Event event = this.readEvent(eventNode);
                    AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                    info.event = event;
                    info.nodePath = nodePath;
                    this.queueJob(info);
                }
                catch (ClassNotFoundException cnfe) {
                    Set<String> set = unloadedJobSet;
                    synchronized (set) {
                        unloadedJobSet.add(nodePath);
                    }
                    this.ignoreException(cnfe);
                }
                catch (RepositoryException re) {
                    this.logger.error("Unable to load stored job from " + nodePath, (Throwable)re);
                }
                return true;
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to load stored job from " + eventNode, (Throwable)re);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendAcknowledge(org.osgi.service.event.Event job, String eventNodePath) {
        Map<String, StartedJobInfo> map = this.processingEventsList;
        synchronized (map) {
            StartedJobInfo ack = this.processingEventsList.remove(eventNodePath);
            if (ack != null) {
                this.sendNotification("org/apache/sling/event/notification/job/START", job);
            }
            return ack != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean finishedJob(org.osgi.service.event.Event job, String eventNodePath, boolean shouldReschedule) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received finish for job {}, shouldReschedule={}", (Object)EventUtil.toString(job), (Object)shouldReschedule);
        }
        Map<String, StartedJobInfo> map = this.processingEventsList;
        synchronized (map) {
            this.processingEventsList.remove(eventNodePath);
        }
        boolean reschedule = shouldReschedule;
        if (shouldReschedule) {
            int retries = this.maxJobRetries;
            if (job.getProperty("event.job.retries") != null) {
                retries = (Integer)job.getProperty("event.job.retries");
            }
            int retryCount = 0;
            if (job.getProperty("event.job.retrycount") != null) {
                retryCount = (Integer)job.getProperty("event.job.retrycount");
            }
            if (retries != -1 && ++retryCount > retries) {
                reschedule = false;
            }
            if (reschedule) {
                EventPropertiesMap newProperties = new EventPropertiesMap(job);
                ((Dictionary)newProperties).put("event.job.retrycount", retryCount);
                ((Dictionary)newProperties).put("event.job.retries", retries);
                job = new org.osgi.service.event.Event(job.getTopic(), (Dictionary)newProperties);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed job {}", (Object)EventUtil.toString(job));
                }
                this.sendNotification("org/apache/sling/event/notification/job/FAILED", job);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cancelled job {}", (Object)EventUtil.toString(job));
                }
                this.sendNotification("org/apache/sling/event/notification/job/CANCELLED", job);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished job {}", (Object)EventUtil.toString(job));
            }
            this.sendNotification("org/apache/sling/event/notification/job/FINISHED", job);
        }
        ParallelInfo parInfo = ParallelInfo.getParallelInfo(job);
        AbstractRepositoryEventHandler.EventInfo putback = null;
        Object object = this.backgroundLock;
        synchronized (object) {
            block60: {
                if (this.backgroundSession == null) {
                    this.checkForNotify(job, null);
                    return false;
                }
                try {
                    Node eventNode;
                    block58: {
                        this.backgroundSession.refresh(false);
                        if (!this.backgroundSession.itemExists(eventNodePath)) {
                            this.checkForNotify(job, null);
                            return true;
                        }
                        eventNode = (Node)this.backgroundSession.getItem(eventNodePath);
                        boolean unlock = true;
                        try {
                            block56: {
                                if (reschedule) break block56;
                                Set<String> set = this.deletedJobs;
                                synchronized (set) {
                                    this.deletedJobs.add(eventNodePath);
                                }
                                try {
                                    eventNode.unlock();
                                }
                                catch (RepositoryException e) {
                                    this.ignoreException((Exception)((Object)e));
                                }
                                unlock = false;
                                String jobId = (String)job.getProperty("event.job.id");
                                if (jobId == null) {
                                    Node parentNode = eventNode.getParent();
                                    eventNode.remove();
                                    parentNode.save();
                                    break block56;
                                }
                                eventNode.setProperty("slingevent:finished", Calendar.getInstance());
                                eventNode.save();
                            }
                            Object var13_22 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_24 = null;
                            String jobTopic = (String)job.getProperty("event.job.topic");
                            this.unlockState(parInfo, jobTopic);
                            if (job.getProperty("event.job.queuename") == null) {
                                --this.parallelJobCount;
                                this.backgroundLock.notify();
                            }
                            if (unlock) {
                                Set<String> set = this.deletedJobs;
                                synchronized (set) {
                                    this.deletedJobs.add(eventNodePath);
                                }
                                try {
                                    eventNode.unlock();
                                }
                                catch (RepositoryException e) {
                                    this.ignoreException((Exception)((Object)e));
                                }
                            }
                            throw throwable;
                        }
                        String jobTopic = (String)job.getProperty("event.job.topic");
                        this.unlockState(parInfo, jobTopic);
                        if (job.getProperty("event.job.queuename") == null) {
                            --this.parallelJobCount;
                            this.backgroundLock.notify();
                        }
                        if (unlock) {
                            Set<String> set = this.deletedJobs;
                            synchronized (set) {
                                this.deletedJobs.add(eventNodePath);
                            }
                            try {
                                eventNode.unlock();
                            }
                            catch (RepositoryException e) {
                                this.ignoreException((Exception)((Object)e));
                            }
                        }
                        break block58;
                        {
                            catch (RepositoryException re) {
                                this.logger.error("Exception during job finishing.", (Throwable)re);
                                Object var13_23 = null;
                                jobTopic = (String)job.getProperty("event.job.topic");
                                this.unlockState(parInfo, jobTopic);
                                if (job.getProperty("event.job.queuename") == null) {
                                    --this.parallelJobCount;
                                    this.backgroundLock.notify();
                                }
                                if (!unlock) break block58;
                                Set<String> set = this.deletedJobs;
                                synchronized (set) {
                                    this.deletedJobs.add(eventNodePath);
                                }
                                try {
                                    eventNode.unlock();
                                }
                                catch (RepositoryException e) {
                                    this.ignoreException((Exception)((Object)e));
                                }
                            }
                        }
                    }
                    if (reschedule) {
                        try {
                            eventNode.setProperty("event.job.retries", (long)((Integer)job.getProperty("event.job.retries")).intValue());
                            eventNode.setProperty("event.job.retrycount", (long)((Integer)job.getProperty("event.job.retrycount")).intValue());
                            eventNode.save();
                        }
                        catch (RepositoryException re) {
                            this.logger.error("Exception during job updating job rescheduling information.", (Throwable)re);
                        }
                        AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                        try {
                            info.event = job;
                            info.nodePath = eventNode.getPath();
                        }
                        catch (RepositoryException e) {
                            this.ignoreException((Exception)((Object)e));
                        }
                        if (job.getProperty("event.job.queuename") != null) {
                            this.checkForNotify(job, info);
                        } else {
                            putback = info;
                        }
                        break block60;
                    }
                    this.checkForNotify(job, null);
                }
                catch (RepositoryException re) {
                    this.logger.error("Unable to create new session.", (Throwable)re);
                    return false;
                }
            }
        }
        if (putback != null) {
            this.putBackIntoMainQueue(putback, false);
        }
        if (!shouldReschedule) {
            return true;
        }
        return reschedule;
    }

    private void putBackIntoMainQueue(final AbstractRepositoryEventHandler.EventInfo info, boolean useSleepTime) {
        long delay;
        Runnable t = new Runnable(){

            public void run() {
                try {
                    JobEventHandler.this.queue.put(info);
                }
                catch (InterruptedException e) {
                    JobEventHandler.this.ignoreException(e);
                }
            }
        };
        if (useSleepTime) {
            delay = this.sleepTime * 1000L;
        } else {
            Long obj = (Long)info.event.getProperty("event.job.retrydelay");
            long l = delay = obj == null ? -1L : obj;
        }
        if (delay == -1L) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Putting job {} back into the queue.", (Object)EventUtil.toString(info.event));
            }
            t.run();
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Putting job {} back into the queue after {}ms.", (Object)EventUtil.toString(info.event), (Object)delay);
            }
            Date fireDate = new Date();
            fireDate.setTime(System.currentTimeMillis() + delay);
            try {
                this.scheduler.fireJobAt(null, (Object)t, null, fireDate);
            }
            catch (Exception e) {
                this.ignoreException(e);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    this.ignoreException(ie);
                }
                t.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNotify(org.osgi.service.event.Event job, AbstractRepositoryEventHandler.EventInfo info) {
        if (job.getProperty("event.job.queuename") != null) {
            JobBlockingQueue jobQueue;
            Object object = this.jobQueues;
            synchronized (object) {
                jobQueue = this.jobQueues.get(job.getProperty("event.job.queuename"));
            }
            object = jobQueue.getLock();
            synchronized (object) {
                AbstractRepositoryEventHandler.EventInfo reprocessInfo = null;
                if (info != null) {
                    reprocessInfo = jobQueue.reschedule(info, this.scheduler);
                }
                if (jobQueue.isOrdered()) {
                    jobQueue.notifyFinish(reprocessInfo);
                } else {
                    jobQueue.freeSlot();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<org.osgi.service.event.Event> queryJobs(String topic, Boolean locked, Map<String, Object> ... filterProps) {
        Session s = null;
        ArrayList<org.osgi.service.event.Event> jobs = new ArrayList<org.osgi.service.event.Event>();
        try {
            try {
                s = this.createSession();
                QueryManager qManager = s.getWorkspace().getQueryManager();
                StringBuilder buffer = new StringBuilder("/jcr:root");
                buffer.append(this.repositoryPath);
                if (topic != null) {
                    buffer.append('/');
                    buffer.append(topic.replace('/', '.'));
                }
                buffer.append("//element(*, ");
                buffer.append(this.getEventNodeType());
                buffer.append(") [not(@");
                buffer.append("slingevent:finished");
                buffer.append(")");
                if (locked != null) {
                    if (locked.booleanValue()) {
                        buffer.append(" and @jcr:lockOwner");
                    } else {
                        buffer.append(" and not(@jcr:lockOwner)");
                    }
                }
                if (filterProps != null && filterProps.length > 0) {
                    buffer.append(" and (");
                    int index = 0;
                    Map<String, Object>[] arr$ = filterProps;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++index, ++i$) {
                        Map<String, Object> template = arr$[i$];
                        if (index > 0) {
                            buffer.append(" or ");
                        }
                        buffer.append('(');
                        Iterator<Map.Entry<String, Object>> i = template.entrySet().iterator();
                        boolean first = true;
                        while (i.hasNext()) {
                            Value value;
                            Map.Entry<String, Object> current = i.next();
                            String propName = EventHelper.getNodePropertyName(current.getKey());
                            if (propName == null || (value = EventHelper.getNodePropertyValue(s.getValueFactory(), current.getValue())) == null) continue;
                            if (first) {
                                first = false;
                                buffer.append('@');
                            } else {
                                buffer.append(" and @");
                            }
                            buffer.append(propName);
                            buffer.append(" = '");
                            buffer.append(current.getValue());
                            buffer.append("'");
                        }
                        buffer.append(')');
                    }
                    buffer.append(')');
                }
                buffer.append("]");
                buffer.append(" order by @");
                buffer.append("slingevent:created");
                buffer.append(" ascending");
                String queryString = buffer.toString();
                this.logger.debug("Executing job query {}.", (Object)queryString);
                Query q = qManager.createQuery(queryString, "xpath");
                NodeIterator iter = q.execute().getNodes();
                while (iter.hasNext()) {
                    Node eventNode = iter.nextNode();
                    try {
                        org.osgi.service.event.Event event = this.readEvent(eventNode);
                        jobs.add(event);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.ignoreException(cnfe);
                    }
                }
                Object var19_23 = null;
                if (s == null) return jobs;
            }
            catch (RepositoryException e) {
                this.ignoreException((Exception)((Object)e));
                Object var19_24 = null;
                if (s == null) return jobs;
                s.logout();
                return jobs;
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (s == null) throw throwable;
            s.logout();
            throw throwable;
        }
        s.logout();
        return jobs;
    }

    @Override
    public Collection<org.osgi.service.event.Event> getCurrentJobs(String topic) {
        return this.getCurrentJobs(topic, null);
    }

    @Override
    public Collection<org.osgi.service.event.Event> scheduledJobs(String topic) {
        return this.getScheduledJobs(topic);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getScheduledJobs(String topic) {
        return this.getScheduledJobs(topic, null);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getCurrentJobs(String topic, Map<String, Object> ... filterProps) {
        return this.queryJobs(topic, true, filterProps);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getScheduledJobs(String topic, Map<String, Object> ... filterProps) {
        return this.queryJobs(topic, false, filterProps);
    }

    @Override
    public Collection<org.osgi.service.event.Event> getAllJobs(String topic, Map<String, Object> ... filterProps) {
        return this.queryJobs(topic, null, filterProps);
    }

    @Override
    public void cancelJob(String topic, String jobId) {
        if (jobId != null && topic != null) {
            this.cancelJob(JobUtil.getUniquePath(topic, jobId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelJob(String jobId) {
        if (jobId != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writerSession.refresh(false);
                }
                catch (RepositoryException e) {
                    this.ignoreException((Exception)((Object)e));
                }
                try {
                    if (this.writerSession.itemExists(jobId)) {
                        Item item = this.writerSession.getItem(jobId);
                        Node parentNode = item.getParent();
                        item.remove();
                        parentNode.save();
                    }
                }
                catch (RepositoryException e) {
                    this.logger.error("Error during cancelling job at " + jobId, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUpJobQueue(String jobQueueName) {
        if (jobQueueName != null) {
            Map<String, JobBlockingQueue> map = this.jobQueues;
            synchronized (map) {
                JobBlockingQueue queue = this.jobQueues.get(jobQueueName);
                if (queue != null) {
                    this.wakeUpJobQueue(queue);
                }
            }
        }
    }

    private void wakeUpJobQueue(JobBlockingQueue jobQueue) {
        if (jobQueue.isSleeping()) {
            Scheduler localScheduler;
            String schedulerJobName = jobQueue.getSchedulerJobName();
            Thread thread = jobQueue.getSleepingThread();
            if (schedulerJobName != null && (localScheduler = this.scheduler) != null) {
                localScheduler.removeJob(schedulerJobName);
            }
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    private void sendNotification(String topic, org.osgi.service.event.Event job) {
        EventAdmin localEA = this.eventAdmin;
        if (localEA != null) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("event.notification.job", job);
            ((Dictionary)props).put("timestamp", System.currentTimeMillis());
            localEA.postEvent(new org.osgi.service.event.Event(topic, props));
        }
    }

    private static final class StartedJobInfo {
        public final org.osgi.service.event.Event event;
        public final String nodePath;
        public final long started;

        public StartedJobInfo(org.osgi.service.event.Event e, String path, long started) {
            this.event = e;
            this.nodePath = path;
            this.started = started;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        FAILED,
        RESCHEDULE,
        SUCCESS;

    }
}

