/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.job;

import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;
import org.osgi.service.event.Event;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobBlockingQueue
extends LinkedBlockingQueue<AbstractRepositoryEventHandler.EventInfo> {
    private volatile AbstractRepositoryEventHandler.EventInfo eventInfo;
    private final Object lock = new Object();
    private volatile boolean isWaiting = false;
    private volatile boolean markForCleanUp = false;
    private volatile boolean finished = false;
    private volatile boolean isSleeping = false;
    private volatile String schedulerJobName;
    private volatile Thread sleepingThread;
    private final String queueName;
    private final Logger logger;
    private final boolean orderedQueue;
    private volatile int jobCount;

    public JobBlockingQueue(String name, boolean orderedQueue, Logger logger) {
        this.queueName = name;
        this.orderedQueue = orderedQueue;
        this.logger = logger;
    }

    public AbstractRepositoryEventHandler.EventInfo waitForFinish() throws InterruptedException {
        this.isWaiting = true;
        this.markForCleanUp = false;
        this.logger.debug("Job queue {} is waiting for finish.", (Object)this.queueName);
        this.lock.wait();
        this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
        this.isWaiting = false;
        AbstractRepositoryEventHandler.EventInfo object = this.eventInfo;
        this.eventInfo = null;
        return object;
    }

    public String getName() {
        return this.queueName;
    }

    public void markForCleanUp() {
        if (!this.isWaiting) {
            this.markForCleanUp = true;
        }
    }

    public void acquireSlot(int maxJobs) throws InterruptedException {
        if (this.jobCount >= maxJobs) {
            this.isWaiting = true;
            this.markForCleanUp = false;
            this.logger.debug("Job queue {} is processing {} job - waiting for a free slot.", (Object)this.queueName, (Object)this.jobCount);
            this.lock.wait();
            this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
            this.isWaiting = false;
        }
        ++this.jobCount;
    }

    public void freeSlot() {
        --this.jobCount;
        if (this.isWaiting) {
            this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
            this.lock.notify();
        }
    }

    public boolean isMarkedForCleanUp() {
        return !this.isWaiting && this.markForCleanUp;
    }

    public void notifyFinish(AbstractRepositoryEventHandler.EventInfo i) {
        this.eventInfo = i;
        this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
        this.lock.notify();
    }

    public Object getLock() {
        return this.lock;
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean flag) {
        this.finished = flag;
    }

    public void setSleeping(boolean flag) {
        this.isSleeping = flag;
        if (!flag) {
            this.schedulerJobName = null;
            this.sleepingThread = null;
        }
    }

    public void setSleeping(String schedulerJobName) {
        this.schedulerJobName = schedulerJobName;
        this.setSleeping(true);
    }

    public void setSleeping(Thread sleepingThread) {
        this.sleepingThread = sleepingThread;
        this.setSleeping(true);
    }

    public String getSchedulerJobName() {
        return this.schedulerJobName;
    }

    public Thread getSleepingThread() {
        return this.sleepingThread;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    public boolean isOrdered() {
        return this.orderedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractRepositoryEventHandler.EventInfo reschedule(final AbstractRepositoryEventHandler.EventInfo info, Scheduler scheduler) {
        Event job = info.event;
        if (this.orderedQueue) {
            if (job.getProperty("event.job.retrydelay") != null) {
                long delay = (Long)job.getProperty("event.job.retrydelay");
                this.setSleeping(Thread.currentThread());
                try {
                    this.logger.debug("Job queue {} is sleeping for {}ms.", (Object)this.queueName, (Object)delay);
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
                finally {
                    this.setSleeping(false);
                }
            }
            return info;
        }
        if (job.getProperty("event.job.retrydelay") != null) {
            long delay = (Long)job.getProperty("event.job.retrydelay");
            Date fireDate = new Date();
            fireDate.setTime(System.currentTimeMillis() + delay);
            final String jobName = "Waiting:" + this.queueName;
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JobBlockingQueue.this.setSleeping(jobName);
                    try {
                        JobBlockingQueue.this.put(info);
                    }
                    catch (InterruptedException e) {
                        JobBlockingQueue.this.ignoreException(e);
                    }
                    finally {
                        JobBlockingQueue.this.setSleeping(false);
                    }
                }
            };
            if (scheduler != null) {
                try {
                    scheduler.fireJobAt(jobName, (Object)t, null, fireDate);
                }
                catch (Exception e) {
                    this.ignoreException(e);
                    t.run();
                }
            } else {
                t.run();
            }
        } else {
            try {
                this.put(info);
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
        }
        return null;
    }

    protected void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }
}

