/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.job;

import org.osgi.service.event.Event;

public class ParallelInfo {
    public static final ParallelInfo UNLIMITED = new ParallelInfo(true, -1);
    public static final ParallelInfo SERIAL = new ParallelInfo(false, -1);
    public final boolean processParallel;
    public final int maxParallelJob;

    private ParallelInfo(boolean processParallel, int maxParallelJob) {
        this.processParallel = processParallel;
        this.maxParallelJob = maxParallelJob;
    }

    public static ParallelInfo getParallelInfo(Event job) {
        if (job.getProperty("event.job.queuename") != null) {
            return UNLIMITED;
        }
        Object value = job.getProperty("event.job.parallel");
        if (value != null) {
            if (value instanceof Boolean) {
                boolean result = (Boolean)value;
                if (result) {
                    return UNLIMITED;
                }
                return SERIAL;
            }
            if (value instanceof Number) {
                int result = ((Number)value).intValue();
                if (result > 1) {
                    return new ParallelInfo(true, result);
                }
                return SERIAL;
            }
            String strValue = value.toString();
            if ("no".equalsIgnoreCase(strValue) || "false".equalsIgnoreCase(strValue)) {
                return SERIAL;
            }
            try {
                int result = Integer.valueOf(strValue);
                if (result > 1) {
                    return new ParallelInfo(true, result);
                }
                return SERIAL;
            }
            catch (NumberFormatException numberFormatException) {
                return UNLIMITED;
            }
        }
        return SERIAL;
    }

    public static int getMaxNumberOfParallelJobs(Event job) {
        int result;
        Object value = job.getProperty("event.job.parallel");
        if (value instanceof String) {
            try {
                value = Integer.valueOf((String)value);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        if (value instanceof Number && (result = ((Number)value).intValue()) > 1) {
            return result;
        }
        return 1;
    }
}

