/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.util.Calendar;
import java.util.Dictionary;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.jcr.JCRHelper;
import org.apache.sling.event.impl.support.Environment;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryEventHandler
implements EventHandler,
EventListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_PROPERTY_REPO_PATH = "/sling/events";
    protected static final String CONFIG_PROPERTY_REPO_PATH = "repository.path";
    protected Session writerSession;
    protected final Object writeLock = new Object();
    protected String repositoryPath;
    protected volatile boolean running;
    protected final BlockingQueue<EventInfo> queue = new LinkedBlockingQueue<EventInfo>();
    protected final BlockingQueue<Event> writeQueue = new LinkedBlockingQueue<Event>();
    protected EnvironmentComponent environment;
    private Node writeRootNode;

    protected void activate(ComponentContext context) {
        this.repositoryPath = OsgiUtil.toString(context.getProperties().get(CONFIG_PROPERTY_REPO_PATH), DEFAULT_PROPERTY_REPO_PATH);
        this.running = true;
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                try {
                    object = AbstractRepositoryEventHandler.this.writeLock;
                    synchronized (object) {
                        AbstractRepositoryEventHandler.this.startWriterSession();
                    }
                }
                catch (RepositoryException e) {
                    AbstractRepositoryEventHandler.this.logger.error("Error during session starting.", (Throwable)e);
                    AbstractRepositoryEventHandler.this.running = false;
                }
                try {
                    AbstractRepositoryEventHandler.this.processWriteQueue();
                }
                catch (Throwable t) {
                    AbstractRepositoryEventHandler.this.logger.error("Writer thread stopped with exception: " + t.getMessage(), t);
                    AbstractRepositoryEventHandler.this.running = false;
                }
                object = AbstractRepositoryEventHandler.this.writeLock;
                synchronized (object) {
                    AbstractRepositoryEventHandler.this.stopWriterSession();
                }
            }
        });
        writerThread.start();
        Thread backgroundThread = new Thread(new Runnable(){

            public void run() {
                try {
                    AbstractRepositoryEventHandler.this.runInBackground();
                }
                catch (Throwable t) {
                    AbstractRepositoryEventHandler.this.logger.error("Background thread stopped with exception: " + t.getMessage(), t);
                    AbstractRepositoryEventHandler.this.running = false;
                }
            }
        });
        backgroundThread.start();
    }

    protected abstract void runInBackground() throws RepositoryException;

    protected abstract void processWriteQueue();

    protected void deactivate(ComponentContext context) {
        this.running = false;
        try {
            this.writeQueue.put(new Event("some", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        try {
            this.queue.put(new EventInfo());
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        this.writeRootNode = null;
    }

    protected void startWriterSession() throws RepositoryException {
        this.writerSession = this.environment.createAdminSession();
        this.writeRootNode = this.createPath(this.writerSession.getRootNode(), this.repositoryPath.substring(1), "sling:OrderedFolder");
        this.writerSession.save();
    }

    protected void stopWriterSession() {
        if (this.writerSession != null) {
            try {
                this.writerSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                this.logger.warn("Unable to remove event listener.", (Throwable)e);
            }
            this.writerSession.logout();
            this.writerSession = null;
        }
    }

    protected String getEventNodeType() {
        return "slingevent:Event";
    }

    protected Node getWriterRootNode() {
        return this.writeRootNode;
    }

    protected Node writeEvent(Event e, String suggestedName) throws RepositoryException {
        String nodeName;
        Node rootNode = this.getWriterRootNode();
        String nodeType = this.getEventNodeType();
        if (suggestedName != null) {
            nodeName = suggestedName;
        } else {
            Calendar now = Calendar.getInstance();
            int sepPos = nodeType.indexOf(58);
            nodeName = nodeType.substring(sepPos + 1) + "-" + Environment.APPLICATION_ID + "-" + now.getTime().getTime();
        }
        Node eventNode = this.createPath(rootNode, nodeName, nodeType);
        eventNode.setProperty("slingevent:created", Calendar.getInstance());
        eventNode.setProperty("slingevent:topic", e.getTopic());
        eventNode.setProperty("slingevent:application", Environment.APPLICATION_ID);
        JCRHelper.writeEventProperties(eventNode, e);
        this.addNodeProperties(eventNode, e);
        this.writerSession.save();
        return eventNode;
    }

    protected Event readEvent(Node eventNode) throws RepositoryException, ClassNotFoundException {
        String topic = eventNode.getProperty("slingevent:topic").getString();
        ClassLoader cl = this.environment.getDynamicClassLoader();
        Dictionary<String, Object> eventProps = JCRHelper.readEventProperties(eventNode, cl, false);
        eventProps.put("slingevent:eventId", eventNode.getPath());
        this.addEventProperties(eventNode, eventProps);
        try {
            Event event = new Event(topic, eventProps);
            return event;
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("Unable to read event: " + iae.getMessage(), (Throwable)iae);
        }
    }

    protected void addEventProperties(Node eventNode, Dictionary<String, Object> properties) throws RepositoryException {
    }

    protected void addNodeProperties(Node eventNode, Event event) throws RepositoryException {
    }

    protected void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    private Node createPath(Node parentNode, String relativePath, String nodeType) throws RepositoryException {
        if (!parentNode.hasNode(relativePath)) {
            Node node = parentNode;
            int pos = relativePath.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(relativePath.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        try {
                            node.addNode(token, "sling:Folder");
                            node.getSession().save();
                        }
                        catch (RepositoryException re) {
                            node.refresh(false);
                        }
                    }
                    node = node.getNode(token);
                }
                relativePath = relativePath.substring(pos + 1);
            }
            if (!node.hasNode(relativePath)) {
                node.addNode(relativePath, nodeType);
            }
            return node.getNode(relativePath);
        }
        return parentNode.getNode(relativePath);
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }

    public static final class EventInfo {
        public String nodePath;
        public Event event;
    }
}

