/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.event.impl.EventingThreadPool;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.event.EventAdmin;

public class EnvironmentComponent {
    private SlingRepository repository;
    private EventAdmin eventAdmin;
    private DynamicClassLoaderManager classLoaderManager;
    private ThreadPool threadPool;
    private SlingSettingsService settingsService;

    protected void activate() {
        Environment.APPLICATION_ID = this.settingsService.getSlingId();
        Environment.THREAD_POOL = this.threadPool;
    }

    protected void deactivate() {
        if (Environment.THREAD_POOL == this.threadPool) {
            Environment.THREAD_POOL = null;
        }
    }

    public ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.classLoaderManager;
        if (dclm != null) {
            return dclm.getDynamicClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public Session createAdminSession() throws RepositoryException {
        SlingRepository repo = this.repository;
        if (repo == null) {
            throw new RepositoryException("Repository is currently not available.");
        }
        return repo.loginAdministrative(null);
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    protected void bindThreadPool(EventingThreadPool etp) {
        this.threadPool = etp;
    }

    protected void unbindThreadPool(EventingThreadPool etp) {
        if (this.threadPool == etp) {
            this.threadPool = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.classLoaderManager == dynamicClassLoaderManager) {
            this.classLoaderManager = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

