/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.JobsIteratorImpl;
import org.apache.sling.event.impl.jobs.StatisticsImpl;
import org.apache.sling.event.impl.jobs.TopicStatisticsImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.apache.sling.event.impl.jobs.queues.OrderedJobQueue;
import org.apache.sling.event.impl.jobs.queues.ParallelJobQueue;
import org.apache.sling.event.impl.jobs.queues.TopicRoundRobinJobQueue;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.JobsIterator;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJobManager
extends StatisticsImpl
implements Runnable,
JobManager,
EventHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private EnvironmentComponent environment;
    private QueueConfigurationManager configManager;
    private Scheduler scheduler;
    private final Object queuesLock = new Object();
    private final Map<String, AbstractJobQueue> queues = new ConcurrentHashMap<String, AbstractJobQueue>();
    private InternalQueueConfiguration mainConfiguration;
    private final StatisticsImpl baseStatistics = new StatisticsImpl();
    private long lastUpdatedStatistics;
    private final Map<String, JobEvent> allEvents = new HashMap<String, JobEvent>();
    private final Map<String, List<JobEvent>> allEventsByTopic = new HashMap<String, List<JobEvent>>();
    private final ConcurrentMap<String, TopicStatistics> topicStatistics = new ConcurrentHashMap<String, TopicStatistics>();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String PROP_ENABLED = "jobmanager.enabled";
    private boolean enabled = true;
    private long schedulerRuns;

    protected void activate(Map<String, Object> props) {
        this.update(props);
        this.logger.info("Apache Sling Job Event Handler started on instance {}", (Object)Environment.APPLICATION_ID);
    }

    protected void update(Map<String, Object> props) {
        HashMap<String, Object> queueProps = new HashMap<String, Object>(props);
        queueProps.remove("queue.applicationids");
        queueProps.put("queue.topics", "*");
        queueProps.put("queue.name", "<main queue>");
        queueProps.put("queue.runlocal", false);
        queueProps.put("queue.type", (Object)QueueConfiguration.Type.UNORDERED);
        int maxParallel = OsgiUtil.toInteger(queueProps.get("queue.maxparallel"), 15);
        if (maxParallel < 2) {
            this.logger.debug("Ignoring invalid setting of {} for {}. Setting to minimum value: 2", (Object)maxParallel, (Object)"queue.maxparallel");
            queueProps.put("queue.maxparallel", 2);
        }
        this.mainConfiguration = InternalQueueConfiguration.fromConfiguration(queueProps);
        boolean oldEnabled = this.enabled;
        this.enabled = OsgiUtil.toBoolean(props.get(PROP_ENABLED), true);
        if (this.enabled != oldEnabled && this.enabled) {
            this.restart();
        }
    }

    protected void deactivate() {
        for (AbstractJobQueue jbq : this.queues.values()) {
            jbq.close();
        }
        this.queues.clear();
        this.logger.info("Apache Sling Job Event Handler stopped on instance {}", (Object)Environment.APPLICATION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        boolean bl;
        Map.Entry<String, AbstractJobQueue> current;
        boolean doFullCleanUp;
        this.logger.debug("cleanup: Starting #{}", (Object)(this.schedulerRuns + 1L));
        for (AbstractJobQueue abstractJobQueue : this.queues.values()) {
            abstractJobQueue.checkForUnprocessedJobs();
        }
        ++this.schedulerRuns;
        boolean bl2 = doFullCleanUp = this.schedulerRuns % 5L == 0L;
        if (doFullCleanUp) {
            this.logger.debug("cleanup: doing full cleanup");
            Object object = this.queuesLock;
            synchronized (object) {
                Iterator<Map.Entry<String, AbstractJobQueue>> i = this.queues.entrySet().iterator();
                while (i.hasNext()) {
                    current = i.next();
                    AbstractJobQueue jbq2 = (AbstractJobQueue)current.getValue();
                    if (jbq2.isMarkedForRemoval()) {
                        this.logger.debug("cleanup: Removing idle Job Queue {}", (Object)jbq2);
                        jbq2.close();
                        this.baseStatistics.add(jbq2);
                        i.remove();
                        continue;
                    }
                    jbq2.markForRemoval();
                }
            }
        }
        boolean bl3 = bl = this.schedulerRuns % 12L == 0L;
        if (bl) {
            HashMap<String, JobEvent> currentEvents;
            this.logger.debug("cleanup: running sanity check");
            current = this.allEvents;
            synchronized (current) {
                currentEvents = new HashMap<String, JobEvent>(this.allEvents);
            }
            for (Map.Entry entry : currentEvents.entrySet()) {
                List<JobEvent> l;
                JobEvent job = (JobEvent)entry.getValue();
                if (job.isAlive()) continue;
                Map<String, JobEvent> map = this.allEvents;
                synchronized (map) {
                    this.logger.debug("cleanup: Removing dead job {}", (Object)job);
                    this.allEvents.remove(entry.getKey());
                }
                String topic = (String)job.event.getProperty("event.job.topic");
                Object object = this.allEventsByTopic;
                synchronized (object) {
                    l = this.allEventsByTopic.get(topic);
                }
                if (l == null) continue;
                object = l;
                synchronized (object) {
                    l.remove(job);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JobEvent event) {
        if (!this.enabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Job manager is disabled. Ignoring job {}", (Object)EventUtil.toString(event.event));
            }
            return;
        }
        InternalQueueConfiguration config = this.configManager.getQueueConfiguration(event);
        if (config == null) {
            String customQueueName = (String)event.event.getProperty("event.job.queuename");
            if (customQueueName != null) {
                Object object = this.queuesLock;
                synchronized (object) {
                    AbstractJobQueue queue = this.queues.get(customQueueName);
                    config = queue != null ? queue.getConfiguration() : new InternalQueueConfiguration(event.event);
                    event.queueName = customQueueName;
                }
            } else {
                config = this.mainConfiguration;
                event.queueName = this.mainConfiguration.getName();
            }
        }
        String queueName = event.queueName;
        if (config.isSkipped(event)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ignoring job due to configuration of queue {} : {}", (Object)queueName, (Object)EventUtil.toString(event.event));
            }
            return;
        }
        if (config.getType() == QueueConfiguration.Type.DROP) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping job due to configuration of queue {} : {}", (Object)queueName, (Object)EventUtil.toString(event.event));
            }
            Utility.sendNotification(this.environment, "org/apache/sling/event/notification/job/CANCELLED", event.event, null);
            event.finished();
            return;
        }
        AbstractJobQueue queue = null;
        Object object = this.queuesLock;
        synchronized (object) {
            queue = this.queues.get(queueName);
            if (queue != null && queue.getConfiguration() != config) {
                this.outdateQueue(queue);
                queue = null;
            }
            if (queue == null) {
                if (config.getType() == QueueConfiguration.Type.ORDERED) {
                    queue = new OrderedJobQueue(queueName, config, this.environment);
                } else if (config.getType() == QueueConfiguration.Type.UNORDERED) {
                    queue = new ParallelJobQueue(queueName, config, this.environment, this.scheduler);
                } else if (config.getType() == QueueConfiguration.Type.TOPIC_ROUND_ROBIN) {
                    queue = new TopicRoundRobinJobQueue(queueName, config, this.environment, this.scheduler);
                }
                if (queue == null) {
                    this.logger.warn("Ignoring event due to unknown queue type of queue {} : {}", (Object)queueName, (Object)EventUtil.toString(event.event));
                    return;
                }
                this.queues.put(queueName, queue);
                queue.start();
            }
        }
        queue.process(event);
    }

    @Override
    public void run() {
        this.cleanup();
    }

    @Override
    public synchronized Statistics getStatistics() {
        long now = System.currentTimeMillis();
        if (this.lastUpdatedStatistics + 1500L < now) {
            this.copyFrom(this.baseStatistics);
            for (AbstractJobQueue jq : this.queues.values()) {
                this.add(jq);
            }
        }
        return this;
    }

    @Override
    public Queue getQueue(String name) {
        return this.queues.get(name);
    }

    @Override
    public Iterable<Queue> getQueues() {
        final Iterator<AbstractJobQueue> jqI = this.queues.values().iterator();
        return new Iterable<Queue>(){

            @Override
            public Iterator<Queue> iterator() {
                return new Iterator<Queue>(){

                    @Override
                    public boolean hasNext() {
                        return jqI.hasNext();
                    }

                    @Override
                    public Queue next() {
                        return (Queue)jqI.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public InternalQueueConfiguration getMainQueueConfiguration() {
        return this.mainConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddJob(JobEvent job) {
        List<JobEvent> l;
        JobEvent oldJob;
        String key = job.uniqueId;
        String topic = (String)job.event.getProperty("event.job.topic");
        Map<String, JobEvent> map = this.allEvents;
        synchronized (map) {
            oldJob = this.allEvents.put(key, job);
        }
        Object object = this.allEventsByTopic;
        synchronized (object) {
            l = this.allEventsByTopic.get(topic);
            if (l == null) {
                l = new ArrayList<JobEvent>();
                this.allEventsByTopic.put(topic, l);
            }
        }
        object = l;
        synchronized (object) {
            if (oldJob != null) {
                l.remove(oldJob);
            }
            l.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoveJob(String key) {
        JobEvent oldJob;
        Map<String, JobEvent> map = this.allEvents;
        synchronized (map) {
            oldJob = this.allEvents.remove(key);
        }
        if (oldJob != null) {
            List<JobEvent> l;
            String topic = (String)oldJob.event.getProperty("event.job.topic");
            Object object = this.allEventsByTopic;
            synchronized (object) {
                l = this.allEventsByTopic.get(topic);
            }
            if (l != null) {
                object = l;
                synchronized (object) {
                    l.remove(oldJob);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyActiveJob(String key) {
        JobEvent job;
        Map<String, JobEvent> map = this.allEvents;
        synchronized (map) {
            job = this.allEvents.get(key);
        }
        if (job != null) {
            job.started = 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRescheduleJob(String key) {
        JobEvent job;
        Map<String, JobEvent> map = this.allEvents;
        synchronized (map) {
            job = this.allEvents.get(key);
        }
        if (job != null) {
            job.started = -1L;
        }
    }

    private boolean checkType(JobManager.QueryType type, JobEvent event) {
        if (type == JobManager.QueryType.ALL) {
            return true;
        }
        if (type == JobManager.QueryType.ACTIVE && event.started == 1L) {
            return true;
        }
        return type == JobManager.QueryType.QUEUED && event.started == -1L;
    }

    private boolean match(JobEvent job, Map<String, Object> template) {
        if (template != null) {
            for (Map.Entry<String, Object> current : template.entrySet()) {
                Operation op;
                String propName;
                char firstChar;
                String key = current.getKey();
                char c = firstChar = key.length() > 0 ? key.charAt(0) : (char)'\u0000';
                if (firstChar == '=') {
                    propName = key.substring(1);
                    op = Operation.EQUALS;
                } else if (firstChar == '<') {
                    char secondChar;
                    char c2 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                    if (secondChar == '=') {
                        op = Operation.LESS_OR_EQUALS;
                        propName = key.substring(2);
                    } else {
                        op = Operation.LESS;
                        propName = key.substring(1);
                    }
                } else if (firstChar == '>') {
                    char secondChar;
                    char c3 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                    if (secondChar == '=') {
                        op = Operation.GREATER_OR_EQUALS;
                        propName = key.substring(2);
                    } else {
                        op = Operation.GREATER;
                        propName = key.substring(1);
                    }
                } else {
                    propName = key;
                    op = Operation.EQUALS;
                }
                Object value = current.getValue();
                if (op == Operation.EQUALS) {
                    if (value.equals(job.event.getProperty(propName))) continue;
                    return false;
                }
                if (value instanceof Comparable) {
                    int result = ((Comparable)value).compareTo(job.event.getProperty(propName));
                    if (op == Operation.LESS && result != -1) {
                        return false;
                    }
                    if (op == Operation.LESS_OR_EQUALS && result == 1) {
                        return false;
                    }
                    if (op == Operation.GREATER_OR_EQUALS && result == -1) {
                        return false;
                    }
                    if (op != Operation.GREATER || result == 1) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queryCollection(List<Event> result, JobManager.QueryType type, Collection<JobEvent> collection, long limit, Map<String, Object> ... filterProps) {
        Collection<JobEvent> collection2 = collection;
        synchronized (collection2) {
            for (JobEvent job : collection) {
                boolean add = this.checkType(type, job);
                if (add && filterProps != null && filterProps.length != 0) {
                    Map<String, Object> template;
                    add = false;
                    Map<String, Object>[] arr$ = filterProps;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && !(add = this.match(job, template = arr$[i$])); ++i$) {
                    }
                }
                if (!add) continue;
                result.add(job.event);
                if (limit <= 0L || (long)result.size() != limit) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JobsIterator queryJobs(JobManager.QueryType type, String topic, Map<String, Object> ... filterProps) {
        return this.queryJobs(type, topic, -1L, filterProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobsIterator queryJobs(JobManager.QueryType type, String topic, long limit, Map<String, Object> ... filterProps) {
        ArrayList<Event> result = new ArrayList<Event>();
        if (topic != null) {
            List<JobEvent> l;
            Map<String, List<JobEvent>> map = this.allEventsByTopic;
            synchronized (map) {
                l = this.allEventsByTopic.get(topic);
            }
            if (l != null) {
                this.queryCollection(result, type, l, limit, filterProps);
            }
        } else {
            HashSet<List<JobEvent>> topics;
            Map<String, List<JobEvent>> map = this.allEventsByTopic;
            synchronized (map) {
                topics = new HashSet<List<JobEvent>>(this.allEventsByTopic.values());
            }
            boolean done = false;
            Iterator i = topics.iterator();
            while (!done && i.hasNext()) {
                Collection l = (Collection)i.next();
                done = this.queryCollection(result, type, l, limit, filterProps);
            }
        }
        return new JobsIteratorImpl(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event findJob(String topic, Map<String, Object> template) {
        Event result = null;
        if (topic != null) {
            List<JobEvent> l;
            Object object = this.allEventsByTopic;
            synchronized (object) {
                l = this.allEventsByTopic.get(topic);
            }
            if (l != null) {
                object = l;
                synchronized (object) {
                    Iterator<JobEvent> iter = l.iterator();
                    while (result == null && iter.hasNext()) {
                        JobEvent job = iter.next();
                        if (!this.match(job, template)) continue;
                        result = job.event;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(String jobId) {
        JobEvent job;
        Map<String, JobEvent> map = this.allEvents;
        synchronized (map) {
            job = this.allEvents.get(jobId);
        }
        boolean result = true;
        if (job != null) {
            result = job.started != 1L ? job.remove() : false;
        }
        return result;
    }

    @Override
    public void forceRemoveJob(String jobId) {
        while (!this.removeJob(jobId)) {
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException ignore) {
                this.ignoreException(ignore);
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized void reset() {
        this.baseStatistics.reset();
        for (AbstractJobQueue jq : this.queues.values()) {
            jq.reset();
        }
        this.topicStatistics.clear();
        this.lastUpdatedStatistics = 0L;
    }

    @Override
    public Iterable<TopicStatistics> getTopicStatistics() {
        return this.topicStatistics.values();
    }

    public void handleEvent(Event event) {
        String topic;
        Event job = (Event)event.getProperty("event.notification.job");
        if (job != null && (topic = (String)job.getProperty("event.job.topic")) != null) {
            TopicStatisticsImpl ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
            if (ts == null) {
                this.topicStatistics.putIfAbsent(topic, new TopicStatisticsImpl(topic));
                ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
            }
            if (event.getTopic().equals("org/apache/sling/event/notification/job/CANCELLED")) {
                ts.addCancelled();
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/FAILED")) {
                ts.addFailed();
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/FINISHED")) {
                Long time = (Long)event.getProperty("time");
                ts.addFinished(time == null ? -1L : time);
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/START")) {
                Long time = (Long)event.getProperty("time");
                ts.addActivated(time == null ? -1L : time);
            }
        }
    }

    private void outdateQueue(AbstractJobQueue queue) {
        this.queues.remove(queue.getName());
        queue.markForRemoval();
        if (queue.isMarkedForRemoval()) {
            queue.close();
            this.baseStatistics.add(queue);
        } else {
            queue.rename(queue.getName() + "<outdated>(" + queue.hashCode() + ")");
            this.queues.put(queue.getName(), queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        ArrayList<JobEvent> jobs;
        Map<String, List<JobEvent>> queues;
        Object object = this.queuesLock;
        synchronized (object) {
            queues = new ArrayList<AbstractJobQueue>(this.queues.values());
            Iterator i$ = queues.iterator();
            while (i$.hasNext()) {
                AbstractJobQueue queue = (AbstractJobQueue)i$.next();
                this.outdateQueue(queue);
            }
        }
        this.reset();
        queues = this.allEvents;
        synchronized (queues) {
            jobs = new ArrayList<JobEvent>(this.allEvents.values());
            this.allEvents.clear();
        }
        queues = this.allEventsByTopic;
        synchronized (queues) {
            this.allEventsByTopic.clear();
        }
        for (JobEvent job : jobs) {
            job.restart();
        }
    }

    @Override
    public boolean isJobProcessingEnabled() {
        return this.enabled;
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }

    protected void bindConfigManager(QueueConfigurationManager queueConfigurationManager) {
        this.configManager = queueConfigurationManager;
    }

    protected void unbindConfigManager(QueueConfigurationManager queueConfigurationManager) {
        if (this.configManager == queueConfigurationManager) {
            this.configManager = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        LESS,
        LESS_OR_EQUALS,
        EQUALS,
        GREATER_OR_EQUALS,
        GREATER;

    }
}

