/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import org.apache.sling.event.jobs.TopicStatistics;

public class TopicStatisticsImpl
implements TopicStatistics {
    private final String topic;
    private volatile long lastActivated = -1L;
    private volatile long lastFinished = -1L;
    private volatile long averageWaitingTime;
    private volatile long averageProcessingTime;
    private volatile long waitingTime;
    private volatile long processingTime;
    private volatile long waitingCount;
    private volatile long processingCount;
    private volatile long finishedJobs;
    private volatile long failedJobs;
    private volatile long cancelledJobs;

    public TopicStatisticsImpl(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public synchronized long getNumberOfProcessedJobs() {
        return this.getNumberOfCancelledJobs() + this.getNumberOfFailedJobs() + this.getNumberOfFinishedJobs();
    }

    public synchronized long getAverageWaitingTime() {
        return this.averageWaitingTime;
    }

    public synchronized long getAverageProcessingTime() {
        return this.averageProcessingTime;
    }

    public synchronized long getNumberOfFinishedJobs() {
        return this.finishedJobs;
    }

    public synchronized long getNumberOfCancelledJobs() {
        return this.cancelledJobs;
    }

    public synchronized long getNumberOfFailedJobs() {
        return this.failedJobs;
    }

    public synchronized long getLastActivatedJobTime() {
        return this.lastActivated;
    }

    public synchronized long getLastFinishedJobTime() {
        return this.lastFinished;
    }

    public synchronized void addFinished(long jobTime) {
        ++this.finishedJobs;
        this.lastFinished = System.currentTimeMillis();
        if (jobTime != -1L) {
            this.processingTime += jobTime;
            ++this.processingCount;
            this.averageProcessingTime = this.processingTime / this.processingCount;
        }
    }

    public synchronized void addActivated(long queueTime) {
        this.lastActivated = System.currentTimeMillis();
        if (queueTime != -1L) {
            this.waitingTime += queueTime;
            ++this.waitingCount;
            this.averageWaitingTime = this.waitingTime / this.waitingCount;
        }
    }

    public synchronized void addFailed() {
        ++this.failedJobs;
    }

    public synchronized void addCancelled() {
        ++this.cancelledJobs;
    }
}

