/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.support.Environment;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class Utility {
    private static final BitSet ALLOWED_CHARS;
    private static final char REPLACEMENT_CHAR = '_';
    private static final char[] HEX_TABLE;
    private static long JOB_COUNTER;
    public static final String PROPERTY_TIME = "time";

    public static String filter(String nodeName) {
        StringBuilder sb = new StringBuilder(nodeName.length());
        int lastAdded = 0;
        for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            int toAdd = c;
            if (!ALLOWED_CHARS.get(c)) {
                if (lastAdded == 95) continue;
                toAdd = 95;
            } else if (i == 0 && Character.isDigit(c)) {
                sb.append('_');
            }
            sb.append((char)toAdd);
            lastAdded = toAdd;
        }
        if (sb.length() == 0) {
            sb.append('_');
        }
        return sb.toString();
    }

    public static String md5(String data) {
        try {
            return Utility.digest("MD5", data.getBytes("utf-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 digest not available???");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("UTF8 digest not available???");
        }
    }

    private static String digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] digest = md.digest(data);
        StringBuilder res = new StringBuilder(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            res.append(HEX_TABLE[b >> 4 & 0xF]);
            res.append(HEX_TABLE[b & 0xF]);
        }
        return res.toString();
    }

    public static String getUniquePath(String jobTopic, String jobId) {
        String convTopic = jobTopic.replace('/', '.');
        if (jobId != null) {
            StringBuilder sb = new StringBuilder("identified/");
            sb.append(convTopic);
            sb.append('/');
            String md5 = Utility.md5(jobId);
            sb.append(md5.charAt(0));
            sb.append(md5.charAt(1));
            sb.append(md5.charAt(2));
            sb.append('/');
            sb.append(md5.charAt(3));
            sb.append(md5.charAt(4));
            sb.append(md5.charAt(5));
            sb.append('/');
            sb.append(Utility.filter(jobId));
            return sb.toString();
        }
        Calendar now = Calendar.getInstance();
        StringBuilder sb = Utility.getAnonPath(now);
        sb.append('/');
        sb.append(convTopic);
        sb.append('_');
        sb.append(JOB_COUNTER);
        ++JOB_COUNTER;
        return sb.toString();
    }

    public static StringBuilder getAnonPath(Calendar now) {
        StringBuilder sb = new StringBuilder("anon/");
        sb.append(Environment.APPLICATION_ID);
        sb.append('/');
        sb.append(now.get(1));
        sb.append('/');
        sb.append(now.get(2) + 1);
        sb.append('/');
        sb.append(now.get(5));
        sb.append('/');
        sb.append(now.get(11));
        sb.append('/');
        sb.append(now.get(12));
        return sb;
    }

    public static void sendNotification(EnvironmentComponent environment, String topic, Event job, Long time) {
        EventAdmin localEA = environment.getEventAdmin();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event.notification.job", job);
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        if (time != null) {
            ((Dictionary)props).put(PROPERTY_TIME, time);
        }
        localEA.postEvent(new Event(topic, props));
    }

    static {
        String allowed = "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789_,.-+#!?$%&()=";
        BitSet allowedSet = new BitSet();
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789_,.-+#!?$%&()=".length(); ++i) {
            allowedSet.set("ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789_,.-+#!?$%&()=".charAt(i));
        }
        ALLOWED_CHARS = allowedSet;
        HEX_TABLE = "0123456789abcdef".toCharArray();
        JOB_COUNTER = 0L;
    }
}

