/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class QueueConfigurationManager {
    private volatile InternalQueueConfiguration[] orderedConfigs = new InternalQueueConfiguration[0];
    private ServiceTracker configTracker;
    private volatile int lastTrackerCount = -1;

    protected void activate(BundleContext bundleContext) {
        this.configTracker = new ServiceTracker(bundleContext, InternalQueueConfiguration.class.getName(), null);
        this.configTracker.open();
    }

    protected void deactivate() {
        if (this.configTracker != null) {
            this.configTracker.close();
            this.configTracker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalQueueConfiguration[] getConfigurations() {
        int count = this.configTracker.getTrackingCount();
        InternalQueueConfiguration[] configurations = this.orderedConfigs;
        if (this.lastTrackerCount < count) {
            QueueConfigurationManager queueConfigurationManager = this;
            synchronized (queueConfigurationManager) {
                configurations = this.orderedConfigs;
                if (this.lastTrackerCount < count) {
                    Object[] trackedConfigs = this.configTracker.getServices();
                    if (trackedConfigs == null || trackedConfigs.length == 0) {
                        configurations = new InternalQueueConfiguration[]{};
                    } else {
                        configurations = new InternalQueueConfiguration[trackedConfigs.length];
                        int i = 0;
                        for (Object entry : trackedConfigs) {
                            InternalQueueConfiguration config;
                            configurations[i] = config = (InternalQueueConfiguration)entry;
                            ++i;
                        }
                    }
                    this.orderedConfigs = configurations;
                    this.lastTrackerCount = count;
                }
            }
        }
        return configurations;
    }

    public InternalQueueConfiguration getQueueConfiguration(JobEvent event) {
        InternalQueueConfiguration[] configurations = this.getConfigurations();
        String queueName = (String)event.event.getProperty("event.job.queuename");
        for (InternalQueueConfiguration config : configurations) {
            if (!config.isValid()) continue;
            if (queueName != null && queueName.equals(config.getName())) {
                event.queueName = queueName;
                return config;
            }
            if (!config.match(event)) continue;
            return config;
        }
        return null;
    }
}

