/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.event.impl.jobs.DefaultJobManager;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;

public class WebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = -6983227434841706385L;
    private JobManager jobManager;
    private QueueConfigurationManager queueConfigManager;
    private static final String PAR_QUEUE = "queue";
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS yyyy-MMM-dd");

    private String escape(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private Queue getQueue(HttpServletRequest req) {
        String name = req.getParameter(PAR_QUEUE);
        if (name != null) {
            for (Queue q : this.jobManager.getQueues()) {
                if (!name.equals(q.getName())) continue;
                return q;
            }
        }
        return null;
    }

    private String getQueueErrorMessage(HttpServletRequest req, String command) {
        String name = req.getParameter(PAR_QUEUE);
        if (name == null || name.length() == 0) {
            return "Queue parameter missing for opertation " + command;
        }
        return "Queue with name '" + name + "' not found for operation " + command;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Queue q;
        String msg = null;
        String cmd = req.getParameter("action");
        if ("suspend".equals(cmd)) {
            q = this.getQueue(req);
            if (q != null) {
                q.suspend();
            } else {
                msg = this.getQueueErrorMessage(req, "suspend");
            }
        } else if ("resume".equals(cmd)) {
            q = this.getQueue(req);
            if (q != null) {
                q.resume();
            } else {
                msg = this.getQueueErrorMessage(req, "resume");
            }
        } else if ("clear".equals(cmd)) {
            q = this.getQueue(req);
            if (q != null) {
                q.clear();
            } else {
                msg = this.getQueueErrorMessage(req, "clear");
            }
        } else if ("reset".equals(cmd)) {
            if (req.getParameter(PAR_QUEUE) == null || req.getParameter(PAR_QUEUE).length() == 0) {
                this.jobManager.getStatistics().reset();
            } else {
                q = this.getQueue(req);
                if (q != null) {
                    q.getStatistics().reset();
                } else {
                    msg = this.getQueueErrorMessage(req, "reset");
                }
            }
        } else if ("restart".equals(cmd)) {
            this.jobManager.restart();
        } else if ("dropall".equals(cmd)) {
            q = this.getQueue(req);
            if (q != null) {
                q.removeAll();
            } else {
                msg = this.getQueueErrorMessage(req, "drop all");
            }
        } else {
            msg = "Unknown command";
        }
        String path = req.getContextPath() + req.getServletPath() + req.getPathInfo();
        String redirectTo = msg == null ? path : path + "?message=" + msg;
        resp.sendRedirect(redirectTo);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        InternalQueueConfiguration[] configs;
        String msg = req.getParameter("message");
        PrintWriter pw = res.getWriter();
        pw.println("<form method='POST' name='eventingcmd'><input type='hidden' name='action' value=''/><input type='hidden' name='queue' value=''/></form>");
        pw.println("<script type='text/javascript'>");
        pw.println("function eventingsubmit(action, queue) { if ( action == 'restart' ) {   if ( !confirm('Do you really want to restart the eventing?') ) { return; } } document.forms['eventingcmd'].action.value = action; document.forms['eventingcmd'].queue.value = queue; document.forms['eventingcmd'].submit();} </script>");
        pw.printf("<p class='statline ui-state-highlight'>Apache Sling Eventing%s%s%n</p>", this.jobManager.isJobProcessingEnabled() ? "" : " (JOB PROCESSING IS DISABLED!)", msg != null ? " : " + msg : "");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.println("<span style='float: left; margin-left: 1em'>Apache Sling Eventing: Overall Statistics</span>");
        this.printForm(pw, null, "Restart!", "restart");
        this.printForm(pw, null, "Reset Stats", "reset");
        pw.println("</div>");
        pw.println("<table class='nicetable'><tbody>");
        Statistics s = this.jobManager.getStatistics();
        pw.printf("<tr><td>Start Time</td><td>%s</td></tr>", this.formatDate(s.getStartTime()));
        pw.printf("<tr><td>Last Activated</td><td>%s</td></tr>", this.formatDate(s.getLastActivatedJobTime()));
        pw.printf("<tr><td>Last Finished</td><td>%s</td></tr>", this.formatDate(s.getLastFinishedJobTime()));
        pw.printf("<tr><td>Queued Jobs</td><td>%s</td></tr>", s.getNumberOfQueuedJobs());
        pw.printf("<tr><td>Active Jobs</td><td>%s</td></tr>", s.getNumberOfActiveJobs());
        pw.printf("<tr><td>Jobs</td><td>%s</td></tr>", s.getNumberOfJobs());
        pw.printf("<tr><td>Finished Jobs</td><td>%s</td></tr>", s.getNumberOfFinishedJobs());
        pw.printf("<tr><td>Failed Jobs</td><td>%s</td></tr>", s.getNumberOfFailedJobs());
        pw.printf("<tr><td>Cancelled Jobs</td><td>%s</td></tr>", s.getNumberOfCancelledJobs());
        pw.printf("<tr><td>Processed Jobs</td><td>%s</td></tr>", s.getNumberOfProcessedJobs());
        pw.printf("<tr><td>Average Processing Time</td><td>%s</td></tr>", this.formatTime(s.getAverageProcessingTime()));
        pw.printf("<tr><td>Average Waiting Time</td><td>%s</td></tr>", this.formatTime(s.getAverageWaitingTime()));
        pw.println("</tbody></table>");
        pw.println("<br/>");
        boolean isEmpty = true;
        for (Queue q : this.jobManager.getQueues()) {
            isEmpty = false;
            pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
            pw.printf("<span style='float: left; margin-left: 1em'>Active JobQueue: %s %s</span>", this.escape(q.getName()), q.isSuspended() ? "(SUSPENDED)" : "");
            this.printForm(pw, q, "Reset Stats", "reset");
            if (q.isSuspended()) {
                this.printForm(pw, q, "Resume", "resume");
            } else {
                this.printForm(pw, q, "Suspend", "suspend");
            }
            this.printForm(pw, q, "Clear Queue", "clear");
            this.printForm(pw, q, "Drop All", "dropall");
            pw.println("</div>");
            pw.println("<table class='nicetable'><tbody>");
            s = q.getStatistics();
            QueueConfiguration c = q.getConfiguration();
            pw.println("<tr><th colspan='2'>Statistics</th><th colspan='2'>Configuration</th></tr>");
            pw.printf("<tr><td>Start Time</td><td>%s</td><td>Type</td><td>%s</td></tr>", this.formatDate(s.getStartTime()), this.formatType(c.getType()));
            pw.printf("<tr><td>Last Activated</td><td>%s</td><td>Topics</td><td>%s</td></tr>", this.formatDate(s.getLastActivatedJobTime()), this.formatArray(c.getTopics()));
            pw.printf("<tr><td>Last Finished</td><td>%s</td><td>Max Parallel</td><td>%s</td></tr>", this.formatDate(s.getLastFinishedJobTime()), c.getMaxParallel());
            pw.printf("<tr><td>Queued Jobs</td><td>%s</td><td>Max Retries</td><td>%s</td></tr>", s.getNumberOfQueuedJobs(), c.getMaxRetries());
            pw.printf("<tr><td>Active Jobs</td><td>%s</td><td>Retry Delay</td><td>%s ms</td></tr>", s.getNumberOfActiveJobs(), c.getRetryDelayInMs());
            pw.printf("<tr><td>Jobs</td><td>%s</td><td>Priority</td><td>%s</td></tr>", new Object[]{s.getNumberOfJobs(), c.getPriority()});
            pw.printf("<tr><td>Finished Jobs</td><td>%s</td><td>Run Local</td><td>%s</td></tr>", s.getNumberOfFinishedJobs(), c.isLocalQueue());
            pw.printf("<tr><td>Failed Jobs</td><td>%s</td><td>App Ids</td><td>%s</td></tr>", s.getNumberOfFailedJobs(), this.formatArray(c.getApplicationIds()));
            pw.printf("<tr><td>Cancelled Jobs</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", s.getNumberOfCancelledJobs());
            pw.printf("<tr><td>Processed Jobs</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", s.getNumberOfProcessedJobs());
            pw.printf("<tr><td>Average Processing Time</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", this.formatTime(s.getAverageProcessingTime()));
            pw.printf("<tr><td>Average Waiting Time</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", this.formatTime(s.getAverageWaitingTime()));
            pw.printf("<tr><td>Status Info</td><td colspan='3'>%s</td></tr>", this.escape(q.getStateInfo()));
            pw.println("</tbody></table>");
            pw.println("<br/>");
        }
        if (isEmpty) {
            pw.println("<p>No active queues.</p>");
            pw.println("<br/>");
        }
        for (TopicStatistics ts : this.jobManager.getTopicStatistics()) {
            pw.println("<table class='nicetable'><tbody>");
            pw.printf("<tr><th colspan='2'>Topic Statistics: %s</th></tr>", this.escape(ts.getTopic()));
            pw.printf("<tr><td>Last Activated</td><td>%s</td></tr>", this.formatDate(ts.getLastActivatedJobTime()));
            pw.printf("<tr><td>Last Finished</td><td>%s</td></tr>", this.formatDate(ts.getLastFinishedJobTime()));
            pw.printf("<tr><td>Finished Jobs</td><td>%s</td></tr>", ts.getNumberOfFinishedJobs());
            pw.printf("<tr><td>Failed Jobs</td><td>%s</td></tr>", ts.getNumberOfFailedJobs());
            pw.printf("<tr><td>Cancelled Jobs</td><td>%s</td></tr>", ts.getNumberOfCancelledJobs());
            pw.printf("<tr><td>Processed Jobs</td><td>%s</td></tr>", ts.getNumberOfProcessedJobs());
            pw.printf("<tr><td>Average Processing Time</td><td>%s</td></tr>", this.formatTime(ts.getAverageProcessingTime()));
            pw.printf("<tr><td>Average Waiting Time</td><td>%s</td></tr>", this.formatTime(ts.getAverageWaitingTime()));
            pw.println("</tbody></table>");
            pw.println("<br/>");
        }
        pw.println("<p class='statline'>Apache Sling Eventing - Job Queue Configurations</p>");
        this.printQueueConfiguration(req, pw, ((DefaultJobManager)this.jobManager).getMainQueueConfiguration());
        for (InternalQueueConfiguration c : configs = this.queueConfigManager.getConfigurations()) {
            this.printQueueConfiguration(req, pw, c);
        }
    }

    private void printQueueConfiguration(HttpServletRequest req, PrintWriter pw, InternalQueueConfiguration c) {
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.printf("<span style='float: left; margin-left: 1em'>Job Queue Configuration: %s</span>%n", this.escape(c.getName()));
        pw.printf("<button id='edit' class='ui-state-default ui-corner-all' onclick='javascript:window.location=\"%s%s/configMgr/%s\";'>Edit</button>", req.getContextPath(), req.getServletPath(), c.getPid());
        pw.println("</div>");
        pw.println("<table class='nicetable'><tbody>");
        pw.println("<tr><th colspan='2'>Configuration</th></tr>");
        pw.printf("<tr><td>Valid</td><td>%s</td></tr>", c.isValid());
        pw.printf("<tr><td>Type</td><td>%s</td></tr>", this.formatType(c.getType()));
        pw.printf("<tr><td>Topics</td><td>%s</td></tr>", this.formatArray(c.getTopics()));
        pw.printf("<tr><td>Max Parallel</td><td>%s</td></tr>", c.getMaxParallel());
        pw.printf("<tr><td>Max Retries</td><td>%s</td></tr>", c.getMaxRetries());
        pw.printf("<tr><td>Retry Delay</td><td>%s ms</td></tr>", c.getRetryDelayInMs());
        pw.printf("<tr><td>Priority</td><td>%s</td></tr>", new Object[]{c.getPriority()});
        pw.printf("<tr><td>Run Local</td><td>%s</td></tr>", c.isLocalQueue());
        pw.printf("<tr><td>App Ids</td><td>%s</td></tr>", this.formatArray(c.getApplicationIds()));
        pw.printf("<tr><td>Ranking</td><td>%s</td></tr>", c.getRanking());
        pw.println("</tbody></table>");
        pw.println("<br/>");
    }

    private String formatArray(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : array) {
            if (!first) {
                sb.append('\n');
            }
            first = false;
            sb.append(s);
        }
        return this.escape(sb.toString());
    }

    private String formatArrayAsText(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        return Arrays.toString(array);
    }

    private String formatType(QueueConfiguration.Type type) {
        switch (type) {
            case IGNORE: {
                return "Ignore";
            }
            case ORDERED: {
                return "Ordered";
            }
            case TOPIC_ROUND_ROBIN: {
                return "Topic Round Robin";
            }
            case UNORDERED: {
                return "Parallel";
            }
        }
        return type.toString();
    }

    private synchronized String formatDate(long time) {
        if (time == -1L) {
            return "-";
        }
        Date d = new Date(time);
        return this.dateFormat.format(d);
    }

    private String formatTime(long time) {
        if (time == 0L) {
            return "-";
        }
        if (time < 1000L) {
            return time + " ms";
        }
        if (time < 60000L) {
            return time / 1000L + " secs";
        }
        long min = time / 1000L / 60L;
        long secs = time - min * 1000L * 60L;
        return min + " min " + secs / 1000L + " secs";
    }

    private void printForm(PrintWriter pw, Queue q, String buttonLabel, String cmd) {
        pw.printf("<button class='ui-state-default ui-corner-all' onclick='javascript:eventingsubmit(\"%s\", \"%s\");'>%s</button>", cmd, q != null ? q.getName() : "", buttonLabel);
    }

    public void printConfiguration(PrintWriter pw, String mode) {
        InternalQueueConfiguration[] configs;
        if (!"zip".equals(mode) && !"txt".equals(mode)) {
            return;
        }
        pw.println("Apache Sling Eventing");
        pw.println("---------------------");
        if (!this.jobManager.isJobProcessingEnabled()) {
            pw.println("JOB PROCESSING IS DISABLED!");
            pw.println();
        }
        Statistics s = this.jobManager.getStatistics();
        pw.println("Overall Statistics");
        pw.printf("Start Time : %s%n", this.formatDate(s.getStartTime()));
        pw.printf("Last Activated : %s%n", this.formatDate(s.getLastActivatedJobTime()));
        pw.printf("Last Finished : %s%n", this.formatDate(s.getLastFinishedJobTime()));
        pw.printf("Queued Jobs : %s%n", s.getNumberOfQueuedJobs());
        pw.printf("Active Jobs : %s%n", s.getNumberOfActiveJobs());
        pw.printf("Jobs : %s%n", s.getNumberOfJobs());
        pw.printf("Finished Jobs : %s%n", s.getNumberOfFinishedJobs());
        pw.printf("Failed Jobs : %s%n", s.getNumberOfFailedJobs());
        pw.printf("Cancelled Jobs : %s%n", s.getNumberOfCancelledJobs());
        pw.printf("Processed Jobs : %s%n", s.getNumberOfProcessedJobs());
        pw.printf("Average Processing Time : %s%n", this.formatTime(s.getAverageProcessingTime()));
        pw.printf("Average Waiting Time : %s%n", this.formatTime(s.getAverageWaitingTime()));
        pw.println();
        boolean isEmpty = true;
        for (Queue q : this.jobManager.getQueues()) {
            isEmpty = false;
            pw.printf("Active JobQueue: %s %s%n", q.getName(), q.isSuspended() ? "(SUSPENDED)" : "");
            s = q.getStatistics();
            QueueConfiguration c = q.getConfiguration();
            pw.println("Statistics");
            pw.printf("Start Time : %s%n", this.formatDate(s.getStartTime()));
            pw.printf("Last Activated : %s%n", this.formatDate(s.getLastActivatedJobTime()));
            pw.printf("Last Finished : %s%n", this.formatDate(s.getLastFinishedJobTime()));
            pw.printf("Queued Jobs : %s%n", s.getNumberOfQueuedJobs());
            pw.printf("Active Jobs : %s%n", s.getNumberOfActiveJobs());
            pw.printf("Jobs : %s%n", s.getNumberOfJobs());
            pw.printf("Finished Jobs : %s%n", s.getNumberOfFinishedJobs());
            pw.printf("Failed Jobs : %s%n", s.getNumberOfFailedJobs());
            pw.printf("Cancelled Jobs : %s%n", s.getNumberOfCancelledJobs());
            pw.printf("Processed Jobs : %s%n", s.getNumberOfProcessedJobs());
            pw.printf("Average Processing Time : %s%n", this.formatTime(s.getAverageProcessingTime()));
            pw.printf("Average Waiting Time : %s%n", this.formatTime(s.getAverageWaitingTime()));
            pw.printf("Status Info : %s%n", q.getStateInfo());
            pw.println("Configuration");
            pw.printf("Type : %s%n", this.formatType(c.getType()));
            pw.printf("Topics : %s%n", this.formatArrayAsText(c.getTopics()));
            pw.printf("Max Parallel : %s%n", c.getMaxParallel());
            pw.printf("Max Retries : %s%n", c.getMaxRetries());
            pw.printf("Retry Delay : %s ms%n", c.getRetryDelayInMs());
            pw.printf("Priority : %s%n", new Object[]{c.getPriority()});
            pw.printf("Run Local : %s%n", c.isLocalQueue());
            pw.printf("App Ids : %s%n", this.formatArrayAsText(c.getApplicationIds()));
            pw.println();
        }
        if (isEmpty) {
            pw.println("No active queues.");
            pw.println();
        }
        for (TopicStatistics ts : this.jobManager.getTopicStatistics()) {
            pw.printf("Topic Statistics - %s%n", ts.getTopic());
            pw.printf("Last Activated : %s%n", this.formatDate(ts.getLastActivatedJobTime()));
            pw.printf("Last Finished : %s%n", this.formatDate(ts.getLastFinishedJobTime()));
            pw.printf("Finished Jobs : %s%n", ts.getNumberOfFinishedJobs());
            pw.printf("Failed Jobs : %s%n", ts.getNumberOfFailedJobs());
            pw.printf("Cancelled Jobs : %s%n", ts.getNumberOfCancelledJobs());
            pw.printf("Processed Jobs : %s%n", ts.getNumberOfProcessedJobs());
            pw.printf("Average Processing Time : %s%n", this.formatTime(ts.getAverageProcessingTime()));
            pw.printf("Average Waiting Time : %s%n", this.formatTime(ts.getAverageWaitingTime()));
            pw.println();
        }
        pw.println("Apache Sling Eventing - Job Queue Configurations");
        pw.println("------------------------------------------------");
        this.printQueueConfiguration(pw, ((DefaultJobManager)this.jobManager).getMainQueueConfiguration());
        for (InternalQueueConfiguration c : configs = this.queueConfigManager.getConfigurations()) {
            this.printQueueConfiguration(pw, c);
        }
    }

    private void printQueueConfiguration(PrintWriter pw, InternalQueueConfiguration c) {
        pw.printf("Job Queue Configuration: %s%n", c.getName());
        pw.printf("Valid : %s%n", c.isValid());
        pw.printf("Type : %s%n", this.formatType(c.getType()));
        pw.printf("Topics : %s%n", this.formatArrayAsText(c.getTopics()));
        pw.printf("Max Parallel : %s%n", c.getMaxParallel());
        pw.printf("Max Retries : %s%n", c.getMaxRetries());
        pw.printf("Retry Delay : %s ms%n", c.getRetryDelayInMs());
        pw.printf("Priority : %s%n", new Object[]{c.getPriority()});
        pw.printf("Run Local : %s%n", c.isLocalQueue());
        pw.printf("App Ids : %s%n", this.formatArrayAsText(c.getApplicationIds()));
        pw.printf("Ranking : %s%n", c.getRanking());
        pw.println();
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected void bindQueueConfigManager(QueueConfigurationManager queueConfigurationManager) {
        this.queueConfigManager = queueConfigurationManager;
    }

    protected void unbindQueueConfigManager(QueueConfigurationManager queueConfigurationManager) {
        if (this.queueConfigManager == queueConfigurationManager) {
            this.queueConfigManager = null;
        }
    }
}

