/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.jcr;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.support.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockManager
implements Runnable,
EventListener {
    private static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/cluster";
    private static final String MODE_SESSION = "session";
    private static final String MODE_OPEN = "open";
    private static final String MODE_NONE = "none";
    private static final String DEFAULT_MODE = "session";
    private static final String LAST_MODIFIED_PROP = "lastModified";
    private static final String NODE_TYPE = "nt:unstructured";
    private static final String OWNER_PREFIX = "SlingVersioningManager:";
    private static final String CONFIG_PROPERTY_REPOSITORY_PATH = "repository.path";
    private static final String CONFIG_PROPERTY_MODE = "lm.mode";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Long> lastModifiedMap = new HashMap<String, Long>();
    private boolean running;
    private final Object backgroundLock = new Object();
    private Session backgroundSession;
    private EnvironmentComponent environment;
    private String repositoryPath;
    private String idNodePath;
    private LockMode mode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(Map<String, Object> props) throws RepositoryException {
        this.repositoryPath = OsgiUtil.toString(props.get(CONFIG_PROPERTY_REPOSITORY_PATH), DEFAULT_REPOSITORY_PATH);
        this.idNodePath = this.repositoryPath + '/' + Environment.APPLICATION_ID;
        this.backgroundSession = this.environment.createAdminSession();
        this.updateLastModified();
        this.backgroundSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 17, this.repositoryPath, true, null, null, true);
        this.logger.info("Apache Sling Versioning Manager started on instance {}", (Object)Environment.APPLICATION_ID);
        Session session = this.backgroundSession;
        synchronized (session) {
            this.unlock(Environment.APPLICATION_ID);
        }
        this.scanExistingNodes();
        this.update(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        this.running = false;
        if (this.backgroundSession != null) {
            Object object = this.backgroundLock;
            synchronized (object) {
                this.logger.debug("Shutting down background session.");
                try {
                    this.backgroundSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Unable to remove event listener.", (Throwable)e);
                }
                this.backgroundSession.logout();
                this.backgroundSession = null;
            }
        }
        this.logger.info("Apache Sling Versioning Manager stopped on instance {}", (Object)Environment.APPLICATION_ID);
    }

    protected void update(Map<String, Object> props) {
        LockMode oldMode = this.mode;
        String modeString = OsgiUtil.toString(props.get(CONFIG_PROPERTY_MODE), "session");
        this.mode = LockMode.valueOf(modeString);
        if (oldMode != this.mode) {
            this.running = this.mode == LockMode.open;
        }
    }

    private Node createPath(String relativePath) throws RepositoryException {
        Node parentNode = this.backgroundSession.getRootNode();
        if (!parentNode.hasNode(relativePath)) {
            Node node = parentNode;
            int pos = relativePath.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(relativePath.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        try {
                            node.addNode(token, NODE_TYPE);
                            node.getSession().save();
                        }
                        catch (RepositoryException re) {
                            node.refresh(false);
                        }
                    }
                    node = node.getNode(token);
                }
                relativePath = relativePath.substring(pos + 1);
            }
            if (!node.hasNode(relativePath)) {
                node.addNode(relativePath, NODE_TYPE);
            }
            return node.getNode(relativePath);
        }
        return parentNode.getNode(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastModified() {
        Object object = this.backgroundLock;
        synchronized (object) {
            try {
                Node slingNode = this.createPath(this.idNodePath.substring(1));
                slingNode.setProperty(LAST_MODIFIED_PROP, System.currentTimeMillis());
                this.backgroundSession.save();
                this.logger.debug("Heartbeat at {}", (Object)Environment.APPLICATION_ID);
            }
            catch (RepositoryException re) {
                this.ignoreException((Exception)((Object)re));
                try {
                    this.backgroundSession.refresh(false);
                }
                catch (RepositoryException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanExistingNodes() {
        Object object = this.backgroundLock;
        synchronized (object) {
            try {
                Node rootNode = this.backgroundSession.getNode(this.repositoryPath);
                NodeIterator nI = rootNode.getNodes();
                while (nI.hasNext()) {
                    Node node = nI.nextNode();
                    String id = node.getName();
                    if (Environment.APPLICATION_ID.equals(id) || !node.hasProperty(LAST_MODIFIED_PROP)) continue;
                    Property prop = node.getProperty(LAST_MODIFIED_PROP);
                    this.logger.debug("Updated heartbeat from {}", (Object)id);
                    this.lastModifiedMap.put(id, prop.getLong());
                }
            }
            catch (RepositoryException re) {
                this.ignoreException((Exception)((Object)re));
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            this.updateLastModified();
            long teeMinusTwo = System.currentTimeMillis() - 120000L;
            Object object = this.backgroundLock;
            synchronized (object) {
                for (Map.Entry<String, Long> entry : this.lastModifiedMap.entrySet()) {
                    if (entry.getValue() == -1L) continue;
                    this.logger.debug("Checking cluster node {}", (Object)entry.getKey());
                    if (entry.getValue() > teeMinusTwo) continue;
                    this.unlock(entry.getKey());
                    entry.setValue(-1L);
                }
            }
        }
    }

    private void unlock(String id) {
        this.logger.info("Trying to unlock {}", (Object)id);
        try {
            String searchString = OWNER_PREFIX + id;
            QueryManager qm = this.backgroundSession.getWorkspace().getQueryManager();
            Query q = qm.createQuery("select * from nt:base where jcr:lockOwner = '" + searchString + "'", "sql");
            QueryResult qr = q.execute();
            NodeIterator nI = qr.getNodes();
            while (nI.hasNext()) {
                Node node = nI.nextNode();
                try {
                    if (!node.hasProperty("jcr:lockOwner") || !node.isLocked() || !node.getProperty("jcr:lockOwner").getString().endsWith(searchString)) continue;
                    this.logger.debug("Trying to unlock node {} from {}", (Object)node.getPath(), (Object)id);
                    this.backgroundSession.getWorkspace().getLockManager().unlock(node.getPath());
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
            }
        }
        catch (RepositoryException re) {
            this.ignoreException((Exception)((Object)re));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onEvent(EventIterator events) {
        Object object = this.backgroundLock;
        synchronized (object) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                if (!this.running) continue;
                try {
                    String path = event.getType() == 1 ? event.getPath() + '/' + LAST_MODIFIED_PROP : event.getPath();
                    if (!this.backgroundSession.propertyExists(path)) continue;
                    Property prop = this.backgroundSession.getProperty(path);
                    String id = prop.getParent().getName();
                    this.logger.debug("Updated heartbeat from {}", (Object)id);
                    this.lastModifiedMap.put(id, prop.getLong());
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
            }
            return;
        }
    }

    public void lock(Session session, String path) throws RepositoryException {
        if (this.mode != LockMode.none) {
            session.getWorkspace().getLockManager().lock(path, false, this.mode == LockMode.session, Long.MAX_VALUE, OWNER_PREFIX + Environment.APPLICATION_ID);
        }
    }

    public void unlock(Session session, String path) throws RepositoryException {
        if (this.mode != LockMode.none) {
            session.getWorkspace().getLockManager().unlock(path);
        }
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LockMode {
        session,
        open,
        none;

    }
}

