/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.jcr;

import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.DefaultJobManager;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.jcr.JCRHelper;
import org.apache.sling.event.impl.jobs.jcr.JCRJobEvent;
import org.apache.sling.event.impl.jobs.jcr.LockManager;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceHandler
implements EventListener,
Runnable,
EventHandler {
    private static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/jobs";
    private static final String CONFIG_PROPERTY_REPOSITORY_PATH = "repository.path";
    private static final int DEFAULT_CLEANUP_PERIOD = 5;
    private static final String CONFIG_PROPERTY_CLEANUP_PERIOD = "cleanup.period";
    private static final long DEFAULT_MAXIMUM_LOAD_JOBS = 1000L;
    private static final String CONFIG_PROPERTY_MAX_LOAD_JOBS = "max.load.jobs";
    private static final long DEFAULT_LOAD_THRESHOLD = 400L;
    private static final String CONFIG_PROPERTY_LOAD_THREASHOLD = "load.threshold";
    private static final long DEFAULT_BACKGROUND_LOAD_DELAY = 30L;
    private static final String CONFIG_PROPERTY_BACKGROUND_LOAD_DELAY = "load.delay";
    private static final long DEFAULT_BACKGROUND_CHECK_DELAY = 240L;
    private static final String CONFIG_PROPERTY_BACKGROUND_CHECK_DELAY = "load.checkdelay";
    private int cleanupPeriod;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String repositoryPath;
    private volatile boolean running;
    private Set<String> unloadedJobs = new HashSet<String>();
    private final BlockingQueue<org.osgi.service.event.Event> writeQueue = new LinkedBlockingQueue<org.osgi.service.event.Event>();
    private final Object backgroundLock = new Object();
    private Session backgroundSession;
    private EnvironmentComponent environment;
    private JobManager jobManager;
    private LockManager lockManager;
    private long cleanUpCounter;

    protected void activate(ComponentContext context) throws RepositoryException {
        Dictionary props = context.getProperties();
        this.cleanupPeriod = OsgiUtil.toInteger(props.get(CONFIG_PROPERTY_CLEANUP_PERIOD), 5);
        if (this.cleanupPeriod < 1) {
            this.cleanupPeriod = 5;
        }
        this.repositoryPath = OsgiUtil.toString(props.get(CONFIG_PROPERTY_REPOSITORY_PATH), DEFAULT_REPOSITORY_PATH);
        this.running = true;
        Thread writerThread = new Thread(new Runnable(){

            public void run() {
                PersistenceHandler.this.persistJobs();
            }
        }, "Apache Sling Job Writer");
        writerThread.setDaemon(true);
        writerThread.start();
        final long loadThreshold = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_LOAD_THREASHOLD), 400L);
        final long backgroundLoadDelay = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_BACKGROUND_LOAD_DELAY), 30L);
        final long backgroundCheckDelay = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_BACKGROUND_CHECK_DELAY), 240L);
        final long maxLoadJobs = OsgiUtil.toLong(props.get(CONFIG_PROPERTY_MAX_LOAD_JOBS), 1000L);
        Thread loaderThread = new Thread(new Runnable(){

            public void run() {
                PersistenceHandler.this.loadJobsInTheBackground(backgroundLoadDelay, backgroundCheckDelay, loadThreshold, maxLoadJobs);
            }
        }, "Apache Sling Job Background Loader");
        loaderThread.setDaemon(true);
        loaderThread.start();
        this.backgroundSession = this.environment.createAdminSession();
        this.backgroundSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 14, this.repositoryPath, true, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        this.running = false;
        try {
            this.writeQueue.put(new org.osgi.service.event.Event("some", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        if (this.backgroundSession != null) {
            Object object = this.backgroundLock;
            synchronized (object) {
                this.logger.debug("Shutting down background session.");
                try {
                    this.backgroundSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Unable to remove event listener.", (Throwable)e);
                }
                this.backgroundSession.logout();
                this.backgroundSession = null;
            }
        }
        this.logger.debug("Apache Sling Job Persistence Handler stopped on instance {}", (Object)Environment.APPLICATION_ID);
    }

    protected void update(ComponentContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator iter) {
        block23: {
            Session s = null;
            block8: while (true) {
                while (iter.hasNext()) {
                    Event event = iter.nextEvent();
                    try {
                        Node eventNode;
                        String propertyName;
                        String path = event.getPath();
                        String loadNodePath = null;
                        if (event.getType() == 1) {
                            loadNodePath = path;
                        } else if (event.getType() == 8) {
                            int pos = path.lastIndexOf(47);
                            propertyName = path.substring(pos + 1);
                            if ("jcr:lockOwner".equals(propertyName)) {
                                loadNodePath = path.substring(0, pos);
                            }
                        } else if (event.getType() == 4) {
                            int pos = path.lastIndexOf(47);
                            propertyName = path.substring(pos + 1);
                            if ("jcr:lockOwner".equals(propertyName)) {
                                ((DefaultJobManager)this.jobManager).notifyActiveJob(path.substring(this.repositoryPath.length() + 1, pos));
                            }
                        } else if (event.getType() == 2) {
                            Set<String> pos = this.unloadedJobs;
                            synchronized (pos) {
                                this.unloadedJobs.remove(path);
                            }
                            ((DefaultJobManager)this.jobManager).notifyRemoveJob(path.substring(this.repositoryPath.length() + 1));
                        }
                        if (loadNodePath == null) continue block8;
                        if (s == null) {
                            s = this.environment.createAdminSession();
                        }
                        if (!s.itemExists(loadNodePath) || !(eventNode = (Node)s.getItem(loadNodePath)).isNodeType("slingevent:Job")) continue block8;
                        if (event.getType() == 1) {
                            this.logger.debug("New job has been added. Trying to load from {}", (Object)loadNodePath);
                        } else {
                            this.logger.debug("Job execution failed by someone else. Trying to load from {}", (Object)loadNodePath);
                        }
                        this.tryToLoadJob(eventNode, this.unloadedJobs);
                        continue block8;
                    }
                    catch (RepositoryException re) {
                        this.logger.error("Exception during jcr event processing.", (Throwable)re);
                    }
                }
                break block23;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        }
    }

    private Query getCleanUpQuery(Session s) throws RepositoryException {
        String selectorName = "nodetype";
        Calendar deleteBefore = Calendar.getInstance();
        deleteBefore.add(12, -this.cleanupPeriod);
        QueryObjectModelFactory qomf = s.getWorkspace().getQueryManager().getQOMFactory();
        QueryObjectModel q = qomf.createQuery((Source)qomf.selector("slingevent:Job", "nodetype"), (Constraint)qomf.and((Constraint)qomf.descendantNode("nodetype", this.repositoryPath), (Constraint)qomf.comparison((DynamicOperand)qomf.propertyValue("nodetype", "slingevent:finished"), "jcr.operator.less.than", (StaticOperand)qomf.literal(s.getValueFactory().createValue(deleteBefore)))), null, null);
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.running && this.jobManager.isJobProcessingEnabled()) {
            this.logger.debug("Cleaning up repository: removing all finished jobs older than {} minutes.", (Object)this.cleanupPeriod);
            Session s = null;
            try {
                s = this.environment.createAdminSession();
                Query q = this.getCleanUpQuery(s);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Executing query {}", (Object)q.getStatement());
                }
                NodeIterator iter = q.execute().getNodes();
                int count = 0;
                while (iter.hasNext()) {
                    Node eventNode = iter.nextNode();
                    eventNode.remove();
                    ++count;
                }
                s.save();
                this.logger.debug("Removed {} entries from the repository.", (Object)count);
            }
            catch (RepositoryException e) {
                this.logger.warn("Exception during repository cleanup.", (Throwable)e);
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
            ++this.cleanUpCounter;
            if (this.cleanUpCounter % 12L == 0L) {
                this.fullEmptyFolderCleanup();
            } else {
                this.simpleEmptyFolderCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleEmptyFolderCleanup() {
        this.logger.debug("Cleaning up repository: looking for empty folders");
        Session s = null;
        try {
            s = this.environment.createAdminSession();
            Calendar cleanUpDate = Calendar.getInstance();
            cleanUpDate.add(10, -1);
            for (int i = 0; i < 5; ++i) {
                Node hourNode;
                String hourPath;
                Node dir;
                StringBuilder sb = Utility.getAnonPath(cleanUpDate);
                String path = this.repositoryPath + '/' + sb.toString();
                if (s.nodeExists(path) && !(dir = s.getNode(path)).hasNodes()) {
                    dir.remove();
                    s.save();
                }
                if (path.endsWith("59") && s.nodeExists(hourPath = path.substring(0, path.length() - 3)) && !(hourNode = s.getNode(hourPath)).hasNodes()) {
                    hourNode.remove();
                    s.save();
                }
                cleanUpDate.add(12, -1);
            }
        }
        catch (RepositoryException e) {
            this.logger.warn("Exception during repository cleanup.", (Throwable)e);
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullEmptyFolderCleanup() {
        this.logger.debug("Cleaning up repository: removing ALL empty folders");
        Session s = null;
        try {
            Node startNode;
            s = this.environment.createAdminSession();
            String startPath = this.repositoryPath + "/anon";
            Node node = startNode = s.nodeExists(startPath) ? s.getNode(startPath) : null;
            if (startNode != null) {
                Calendar now = Calendar.getInstance();
                NodeIterator idIter = startNode.getNodes();
                while (idIter.hasNext()) {
                    Node idNode = idIter.nextNode();
                    NodeIterator yearIter = idNode.getNodes();
                    while (yearIter.hasNext()) {
                        Node yearNode = yearIter.nextNode();
                        int year = Integer.valueOf(yearNode.getName());
                        boolean oldYear = year < now.get(1);
                        NodeIterator monthIter = yearNode.getNodes();
                        while (monthIter.hasNext()) {
                            Node monthNode = monthIter.nextNode();
                            int month = Integer.valueOf(monthNode.getName());
                            boolean oldMonth = oldYear || month < now.get(2) + 1;
                            NodeIterator dayIter = monthNode.getNodes();
                            while (dayIter.hasNext()) {
                                Node dayNode = dayIter.nextNode();
                                int day = Integer.valueOf(dayNode.getName());
                                boolean oldDay = oldMonth || day < now.get(5);
                                NodeIterator hourIter = dayNode.getNodes();
                                while (hourIter.hasNext()) {
                                    boolean oldHour;
                                    Node hourNode = hourIter.nextNode();
                                    int hour = Integer.valueOf(hourNode.getName());
                                    boolean bl = oldHour = oldDay && (oldMonth || now.get(11) > 0) || hour < now.get(11) - 1;
                                    if (oldHour) {
                                        NodeIterator minuteIter = hourNode.getNodes();
                                        while (minuteIter.hasNext()) {
                                            Node minuteNode = minuteIter.nextNode();
                                            if (minuteNode.hasNodes()) continue;
                                            minuteNode.remove();
                                            s.save();
                                        }
                                    }
                                    if (!oldHour || hourNode.hasNodes()) continue;
                                    hourNode.remove();
                                    s.save();
                                }
                                if (!oldDay || dayNode.hasNodes()) continue;
                                dayNode.remove();
                                s.save();
                            }
                            if (!oldMonth || monthNode.hasNodes()) continue;
                            monthNode.remove();
                            s.save();
                        }
                        if (!oldYear || yearNode.hasNodes()) continue;
                        yearNode.remove();
                        s.save();
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.logger.warn("Exception during repository cleanup.", (Throwable)e);
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    private void loadJobsInTheBackground(long backgroundLoadDelay, long backgroundCheckDelay, long loadThreshold, long maxLoadJobs) {
        long startTime = System.currentTimeMillis();
        try {
            Thread.sleep(1000L * backgroundLoadDelay);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        if (this.running) {
            this.logger.debug("Starting background loading.");
            long loadSince = -1L;
            do {
                loadSince = this.loadJobs(loadSince, startTime, maxLoadJobs);
                if (!this.running || loadSince <= -1L) continue;
                do {
                    try {
                        Thread.sleep(1000L * backgroundCheckDelay);
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                } while (this.running && this.jobManager.getStatistics().getNumberOfJobs() > loadThreshold);
            } while (this.running && loadSince > -1L);
            this.logger.debug("Finished background loading.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadJobs(long since, long startTime, long maxLoadJobs) {
        long maxLoad;
        long eventCreated = since;
        long l = maxLoad = since == -1L ? maxLoadJobs : maxLoadJobs - this.jobManager.getStatistics().getNumberOfJobs();
        if (maxLoad > 0L) {
            this.logger.debug("Loading from repository since {} and max {}", (Object)since, (Object)maxLoad);
            Session session = null;
            try {
                session = this.environment.createAdminSession();
                QueryManager qManager = session.getWorkspace().getQueryManager();
                ValueFactory vf = session.getValueFactory();
                String selectorName = "nodetype";
                Calendar startDate = Calendar.getInstance();
                startDate.setTimeInMillis(startTime);
                QueryObjectModelFactory qomf = qManager.getQOMFactory();
                And constraint = qomf.and((Constraint)qomf.descendantNode("nodetype", this.repositoryPath), (Constraint)qomf.not((Constraint)qomf.propertyExistence("nodetype", "slingevent:finished")));
                constraint = qomf.and((Constraint)constraint, (Constraint)qomf.comparison((DynamicOperand)qomf.propertyValue("nodetype", "slingevent:created"), "jcr.operator.less.than", (StaticOperand)qomf.literal(vf.createValue(startDate))));
                if (since != -1L) {
                    Calendar beforeDate = Calendar.getInstance();
                    beforeDate.setTimeInMillis(since);
                    constraint = qomf.and((Constraint)constraint, (Constraint)qomf.comparison((DynamicOperand)qomf.propertyValue("nodetype", "slingevent:created"), "jcr.operator.greater.than", (StaticOperand)qomf.literal(vf.createValue(beforeDate))));
                }
                QueryObjectModel q = qomf.createQuery((Source)qomf.selector("slingevent:Job", "nodetype"), (Constraint)constraint, new Ordering[]{qomf.ascending((DynamicOperand)qomf.propertyValue("nodetype", "slingevent:created"))}, null);
                NodeIterator result = q.execute().getNodes();
                long count = 0L;
                while (result.hasNext() && count < maxLoad) {
                    Node eventNode = result.nextNode();
                    String propPath = eventNode.getPath() + '/' + "slingevent:created";
                    if (!session.itemExists(propPath)) continue;
                    eventCreated = eventNode.getProperty("slingevent:created").getLong();
                    if (!this.tryToLoadJob(eventNode, this.unloadedJobs)) continue;
                    ++count;
                }
                boolean done = false;
                while (result.hasNext() && !done) {
                    Node eventNode = result.nextNode();
                    String propPath = eventNode.getPath() + '/' + "slingevent:created";
                    if (!session.itemExists(propPath)) continue;
                    long created = eventNode.getProperty("slingevent:created").getLong();
                    if (created == eventCreated) {
                        if (!this.tryToLoadJob(eventNode, this.unloadedJobs)) continue;
                        ++count;
                        continue;
                    }
                    done = true;
                }
                if (!done && !result.hasNext()) {
                    eventCreated = -1L;
                }
                this.logger.debug("Loaded {} jobs and new since {}", (Object)count, (Object)eventCreated);
            }
            catch (RepositoryException re) {
                this.logger.error("Exception during initial loading of stored jobs.", (Throwable)re);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        return eventCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToLoadJob(Node eventNode, Set<String> unloadedJobSet) {
        try {
            String nodePath = eventNode.getPath();
            if (!eventNode.hasProperty("slingevent:finished")) {
                boolean shouldProcess = true;
                if (eventNode.hasProperty("event.job.run.local") && !eventNode.getProperty("slingevent:application").getString().equals(Environment.APPLICATION_ID)) {
                    shouldProcess = false;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Discarding job at {} : local job for a different application node.", (Object)nodePath);
                    }
                }
                org.osgi.service.event.Event event = null;
                try {
                    event = this.readEvent(eventNode, false);
                }
                catch (ClassNotFoundException cnfe) {
                    Set<String> set = unloadedJobSet;
                    synchronized (set) {
                        unloadedJobSet.add(nodePath);
                    }
                    this.ignoreException(cnfe);
                }
                catch (RepositoryException re) {
                    this.logger.error("Unable to load stored job from " + nodePath, (Throwable)re);
                }
                if (event == null) {
                    try {
                        event = this.readEvent(eventNode, true);
                        shouldProcess = false;
                    }
                    catch (ClassNotFoundException cnfe) {
                    }
                    catch (RepositoryException re) {
                        this.logger.error("Unable to load stored job from " + nodePath, (Throwable)re);
                    }
                }
                if (event != null) {
                    ((DefaultJobManager)this.jobManager).notifyAddJob(new JCRJobEvent(event, this));
                    if (shouldProcess) {
                        this.process(event);
                    }
                }
                return shouldProcess && event != null;
            }
            ((DefaultJobManager)this.jobManager).notifyRemoveJob(nodePath.substring(this.repositoryPath.length() + 1));
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to load stored job from " + eventNode, (Throwable)re);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistJobs() {
        this.logger.debug("Apache Sling Job Persistence Handler started on instance {}", (Object)Environment.APPLICATION_ID);
        Session writerSession = null;
        Node rootNode = null;
        try {
            writerSession = this.environment.createAdminSession();
            writerSession.getWorkspace().getObservationManager().addEventListener(new EventListener(){

                public void onEvent(EventIterator events) {
                    PersistenceHandler.this.onEvent(events);
                }
            }, 1, this.repositoryPath, true, null, null, true);
            rootNode = this.createPath(writerSession.getRootNode(), this.repositoryPath.substring(1), "sling:OrderedFolder");
            writerSession.save();
            try {
                this.processWriteQueue(rootNode);
            }
            catch (Throwable t) {
                this.logger.error("Writer thread stopped with exception: " + t.getMessage(), t);
                this.running = false;
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Error during session starting.", (Throwable)e);
            this.running = false;
        }
        finally {
            if (writerSession != null) {
                try {
                    writerSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Unable to remove event listener.", (Throwable)e);
                }
                writerSession.logout();
            }
        }
    }

    private void processWriteQueue(Node rootNode) {
        while (this.running) {
            org.osgi.service.event.Event event = null;
            try {
                event = this.writeQueue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (event == null || !this.running) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Persisting job {}", (Object)EventUtil.toString(event));
            }
            String jobId = (String)event.getProperty("event.job.id");
            String jobTopic = (String)event.getProperty("event.job.topic");
            String nodePath = Utility.getUniquePath(jobTopic, jobId);
            Node readAndProcess = null;
            if (jobId == null) {
                try {
                    readAndProcess = this.writeEvent(rootNode, event, nodePath);
                }
                catch (RepositoryException re) {
                    this.logger.error("Exception during writing new job '" + EventUtil.toString(event) + "' to repository at " + nodePath, (Throwable)re);
                }
            } else {
                try {
                    Node foundNode = null;
                    if (rootNode.hasNode(nodePath)) {
                        foundNode = rootNode.getNode(nodePath);
                    }
                    if (foundNode == null) {
                        try {
                            readAndProcess = this.writeEvent(rootNode, event, nodePath);
                        }
                        catch (ItemExistsException iee) {}
                    }
                }
                catch (RepositoryException re) {
                    this.logger.error("Exception during writing new job '" + EventUtil.toString(event) + "' to repository at " + nodePath, (Throwable)re);
                }
            }
            if (readAndProcess == null) continue;
            this.tryToLoadJob(readAndProcess, this.unloadedJobs);
        }
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node writeEvent(Node rootNode, org.osgi.service.event.Event e, String path) throws RepositoryException {
        Node eventNode = this.createPath(rootNode, path, "slingevent:Job");
        JCRHelper.writeEventProperties(eventNode, e);
        eventNode.setProperty("slingevent:created", Calendar.getInstance());
        eventNode.setProperty("slingevent:application", Environment.APPLICATION_ID);
        eventNode.setProperty("slingevent:topic", (String)e.getProperty("event.job.topic"));
        String jobId = (String)e.getProperty("event.job.id");
        if (jobId != null) {
            eventNode.setProperty("slingevent:id", jobId);
        }
        boolean refresh = true;
        try {
            rootNode.getSession().save();
            refresh = false;
        }
        finally {
            if (refresh) {
                try {
                    rootNode.getSession().refresh(false);
                }
                catch (RepositoryException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
        }
        return eventNode;
    }

    public org.osgi.service.event.Event forceReadEvent(Node eventNode) throws RepositoryException {
        try {
            return this.readEvent(eventNode, false);
        }
        catch (ClassNotFoundException cnfe) {
            this.ignoreException(cnfe);
            try {
                return this.readEvent(eventNode, true);
            }
            catch (ClassNotFoundException cnfe2) {
                this.ignoreException(cnfe2);
                throw new RepositoryException((Throwable)cnfe2);
            }
        }
    }

    private org.osgi.service.event.Event readEvent(Node eventNode, boolean forceLoad) throws RepositoryException, ClassNotFoundException {
        String topic = eventNode.getProperty("slingevent:topic").getString();
        ClassLoader cl = this.environment.getDynamicClassLoader();
        Dictionary<String, Object> eventProps = JCRHelper.readEventProperties(eventNode, cl, forceLoad);
        eventProps.put("slingevent:eventId", eventNode.getPath().substring(this.repositoryPath.length() + 1));
        if (eventProps.get("event.job.retries") != null) {
            eventProps.put("event.job.retries", Integer.valueOf(eventProps.get("event.job.retries").toString()));
        }
        if (eventProps.get("event.job.retrycount") != null) {
            eventProps.put("event.job.retrycount", Integer.valueOf(eventProps.get("event.job.retrycount").toString()));
        } else {
            eventProps.put("event.job.retrycount", new Integer(0));
        }
        eventProps.put("event.application", eventNode.getProperty("slingevent:application").getString());
        eventProps.put("slingevent:created", eventNode.getProperty("slingevent:created").getDate());
        try {
            org.osgi.service.event.Event event = new org.osgi.service.event.Event(topic, eventProps);
            return event;
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("Unable to read event: " + iae.getMessage(), (Throwable)iae);
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean checkJobTopic(org.osgi.service.event.Event job) {
        String jobTopic = (String)job.getProperty("event.job.topic");
        boolean topicIsCorrect = false;
        if (jobTopic != null) {
            try {
                org.osgi.service.event.Event testEvent = new org.osgi.service.event.Event(jobTopic, (Dictionary)null);
                topicIsCorrect = true;
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            if (!topicIsCorrect) {
                this.logger.warn("Discarding job {} : job has an illegal job topic {}", (Object)EventUtil.toString(job), (Object)jobTopic);
            }
        } else {
            this.logger.warn("Discarding job {} : job topic is missing", (Object)EventUtil.toString(job));
        }
        return topicIsCorrect;
    }

    private void store(org.osgi.service.event.Event event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Handling local job {}", (Object)EventUtil.toString(event));
        }
        if (this.checkJobTopic(event)) {
            try {
                this.writeQueue.put(event);
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToReloadUnloadedJobs() {
        boolean doIt = false;
        Set<String> set = this.unloadedJobs;
        synchronized (set) {
            if (this.unloadedJobs.size() > 0) {
                doIt = true;
            }
        }
        if (doIt) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Set set = PersistenceHandler.this.unloadedJobs;
                    synchronized (set) {
                        Session s = null;
                        HashSet<String> newUnloadedJobs = new HashSet<String>();
                        newUnloadedJobs.addAll(PersistenceHandler.this.unloadedJobs);
                        try {
                            s = PersistenceHandler.this.environment.createAdminSession();
                            for (String path : PersistenceHandler.this.unloadedJobs) {
                                newUnloadedJobs.remove(path);
                                try {
                                    if (!s.itemExists(path)) continue;
                                    Node eventNode = (Node)s.getItem(path);
                                    PersistenceHandler.this.tryToLoadJob(eventNode, newUnloadedJobs);
                                }
                                catch (RepositoryException re) {
                                    newUnloadedJobs.add(path);
                                    PersistenceHandler.this.ignoreException((Exception)((Object)re));
                                }
                            }
                        }
                        catch (RepositoryException re) {
                            PersistenceHandler.this.ignoreException((Exception)((Object)re));
                        }
                        finally {
                            if (s != null) {
                                s.logout();
                            }
                            PersistenceHandler.this.unloadedJobs.clear();
                            PersistenceHandler.this.unloadedJobs.addAll(newUnloadedJobs);
                        }
                    }
                }
            };
            Environment.THREAD_POOL.execute(t);
        }
    }

    private void process(org.osgi.service.event.Event event) {
        if (!this.checkJobTopic(event)) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received new job {}", (Object)EventUtil.toString(event));
        }
        String appId = (String)event.getProperty("event.application");
        if (event.getProperty("event.job.run.local") != null && appId != null && !Environment.APPLICATION_ID.equals(appId)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Discarding job {} : local job for a different application node.", (Object)EventUtil.toString(event));
            }
        } else {
            JCRJobEvent info = new JCRJobEvent(event, this);
            ((DefaultJobManager)this.jobManager).process(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(JobEvent info) {
        String path = this.getNodePath(info.uniqueId);
        Object object = this.backgroundLock;
        synchronized (object) {
            block8: {
                if (!this.running) {
                    return false;
                }
                try {
                    Node eventNode;
                    if (!this.backgroundSession.itemExists(path) || this.backgroundSession.itemExists(path + '/' + "slingevent:finished") || (eventNode = (Node)this.backgroundSession.getItem(path)).isLocked()) break block8;
                    try {
                        this.lockManager.lock(this.backgroundSession, path);
                    }
                    catch (RepositoryException re) {
                        return false;
                    }
                    ((DefaultJobManager)this.jobManager).notifyActiveJob(info.uniqueId);
                    return true;
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(JobEvent info) {
        String path = this.getNodePath(info.uniqueId);
        Object object = this.backgroundLock;
        synchronized (object) {
            if (this.running) {
                try {
                    if (this.backgroundSession.itemExists(path)) {
                        Node eventNode = (Node)this.backgroundSession.getItem(path);
                        this.tryToLoadJob(eventNode, this.unloadedJobs);
                    }
                }
                catch (RepositoryException re) {
                    this.ignoreException((Exception)((Object)re));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(JobEvent info) {
        String path = this.getNodePath(info.uniqueId);
        Object object = this.backgroundLock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            try {
                this.lockManager.unlock(this.backgroundSession, path);
            }
            catch (RepositoryException re) {
                this.ignoreException((Exception)((Object)re));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(JobEvent info) {
        String jobId = (String)info.event.getProperty("event.job.id");
        String path = this.getNodePath(info.uniqueId);
        Object object = this.backgroundLock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            try {
                ((DefaultJobManager)this.jobManager).notifyRemoveJob(info.uniqueId);
                if (this.backgroundSession.itemExists(path)) {
                    Node eventNode = (Node)this.backgroundSession.getItem(path);
                    if (jobId == null) {
                        eventNode.remove();
                    } else {
                        eventNode.setProperty("slingevent:finished", Calendar.getInstance());
                        eventNode.setProperty("slingevent:processor", Environment.APPLICATION_ID);
                    }
                    this.backgroundSession.save();
                    if (jobId != null && eventNode.isLocked()) {
                        this.lockManager.unlock(this.backgroundSession, path);
                    }
                }
            }
            catch (RepositoryException re) {
                this.ignoreException((Exception)((Object)re));
                try {
                    this.backgroundSession.refresh(false);
                }
                catch (RepositoryException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
        }
    }

    private String getNodePath(String jobId) {
        return this.repositoryPath + '/' + jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String jobId) {
        if (this.backgroundSession != null && jobId != null) {
            String path = this.getNodePath(jobId);
            Object object = this.backgroundLock;
            synchronized (object) {
                block11: {
                    try {
                        if (!this.backgroundSession.itemExists(path)) break block11;
                        Node eventNode = (Node)this.backgroundSession.getItem(path);
                        if (eventNode.isLocked()) {
                            this.logger.debug("Attempted to cancel a running job at {}", (Object)path);
                            return false;
                        }
                        try {
                            org.osgi.service.event.Event job = this.forceReadEvent(eventNode);
                            Utility.sendNotification(this.environment, "org/apache/sling/event/notification/job/CANCELLED", job, null);
                        }
                        catch (RepositoryException ignore) {
                            this.ignoreException((Exception)((Object)ignore));
                        }
                        eventNode.remove();
                        this.backgroundSession.save();
                        ((DefaultJobManager)this.jobManager).notifyRemoveJob(jobId);
                    }
                    catch (RepositoryException e) {
                        this.logger.error("Error during cancelling job at " + path, (Throwable)e);
                        try {
                            this.backgroundSession.refresh(false);
                        }
                        catch (RepositoryException ignore) {
                            this.ignoreException((Exception)((Object)ignore));
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reschedule(JobEvent info) {
        String path = this.getNodePath(info.uniqueId);
        Object object = this.backgroundLock;
        synchronized (object) {
            try {
                if (this.backgroundSession.itemExists(path)) {
                    Node eventNode = (Node)this.backgroundSession.getItem(path);
                    if (info.event.getProperty("event.job.retries") != null) {
                        eventNode.setProperty("event.job.retries", (long)((Integer)info.event.getProperty("event.job.retries")).intValue());
                    }
                    if (info.event.getProperty("event.job.retrycount") != null) {
                        eventNode.setProperty("event.job.retrycount", (long)((Integer)info.event.getProperty("event.job.retrycount")).intValue());
                    }
                    eventNode.setProperty("slingevent:processor", Environment.APPLICATION_ID);
                    this.backgroundSession.save();
                    this.lockManager.unlock(this.backgroundSession, path);
                    ((DefaultJobManager)this.jobManager).notifyRescheduleJob(info.uniqueId);
                    return true;
                }
            }
            catch (RepositoryException re) {
                this.ignoreException((Exception)((Object)re));
                try {
                    this.backgroundSession.refresh(false);
                }
                catch (RepositoryException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
        }
        ((DefaultJobManager)this.jobManager).notifyRemoveJob(info.uniqueId);
        return false;
    }

    private Node createPath(Node parentNode, String relativePath, String nodeType) throws RepositoryException {
        if (!parentNode.hasNode(relativePath)) {
            Node node = parentNode;
            int pos = relativePath.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(relativePath.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        try {
                            node.addNode(token, "sling:Folder");
                            node.getSession().save();
                        }
                        catch (RepositoryException re) {
                            node.getSession().refresh(false);
                        }
                    }
                    node = node.getNode(token);
                }
                relativePath = relativePath.substring(pos + 1);
            }
            if (!node.hasNode(relativePath)) {
                node.addNode(relativePath, nodeType);
            }
            return node.getNode(relativePath);
        }
        return parentNode.getNode(relativePath);
    }

    @Override
    public void run() {
        this.cleanup();
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Receiving event {}", (Object)EventUtil.toString(event));
        }
        if (EventUtil.isLocal(event)) {
            if (event.getTopic().equals("org/apache/sling/event/job")) {
                this.store(event);
            } else {
                this.tryToReloadUnloadedJobs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive(JCRJobEvent info) {
        String path = this.getNodePath(info.uniqueId);
        Session s = null;
        try {
            String finishedPath;
            s = this.environment.createAdminSession();
            if (s.itemExists(path) && !s.itemExists(finishedPath = path + '/' + "slingevent:finished")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (RepositoryException re) {
            this.ignoreException((Exception)((Object)re));
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
        return false;
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    protected void bindLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    protected void unbindLockManager(LockManager lockManager) {
        if (this.lockManager == lockManager) {
            this.lockManager = null;
        }
    }
}

