/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.JobStatusNotifier;
import org.apache.sling.event.impl.jobs.StatisticsImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.Statistics;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJobQueue
extends StatisticsImpl
implements JobStatusNotifier,
Queue {
    private static final long DEFAULT_WAIT_FOR_ACK_IN_MS = 60000L;
    private static final long MAX_SUSPEND_TIME = 3600000L;
    protected final Logger logger;
    protected final InternalQueueConfiguration configuration;
    private final EnvironmentComponent environment;
    protected volatile String queueName;
    protected volatile boolean running;
    private volatile boolean markedForRemoval = false;
    protected volatile boolean isWaiting = false;
    private final Map<String, JobEvent> startedJobsLists = new HashMap<String, JobEvent>();
    private final Map<String, JobEvent> processsingJobsLists = new HashMap<String, JobEvent>();
    private volatile long suspendedSince = -1L;
    private final Object suspendLock = new Object();

    public AbstractJobQueue(String name, InternalQueueConfiguration config, EnvironmentComponent environment) {
        this.queueName = name;
        this.configuration = config;
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + '.' + name));
        this.running = true;
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStateInfo() {
        Object object = this.suspendLock;
        synchronized (object) {
            return "isWaiting=" + this.isWaiting + ", markedForRemoval=" + this.markedForRemoval + ", suspendedSince=" + this.suspendedSince;
        }
    }

    public void start() {
        Thread queueThread = new Thread(new Runnable(){

            public void run() {
                while (AbstractJobQueue.this.running) {
                    AbstractJobQueue.this.logger.info("Starting job queue {}", (Object)AbstractJobQueue.this.queueName);
                    AbstractJobQueue.this.logger.debug("Configuration for job queue={}", (Object)AbstractJobQueue.this.configuration);
                    try {
                        AbstractJobQueue.this.runJobQueue();
                    }
                    catch (Throwable t) {
                        AbstractJobQueue.this.logger.error("Job queue " + AbstractJobQueue.this.queueName + " stopped with exception: " + t.getMessage() + ". Restarting.", t);
                    }
                }
            }
        }, "Apache Sling Job Queue " + this.queueName);
        queueThread.setDaemon(true);
        queueThread.start();
    }

    @Override
    public InternalQueueConfiguration getConfiguration() {
        return this.configuration;
    }

    public void close() {
        this.running = false;
        this.logger.debug("Shutting down job queue {}", (Object)this.queueName);
        this.logger.debug("Waking up sleeping queue {}", (Object)this.queueName);
        this.resume();
        if (this.isWaiting) {
            this.logger.debug("Waking up waiting queue {}", (Object)this.queueName);
            this.notifyFinished(null);
        }
        this.put(new JobEvent(null, null){

            public boolean lock() {
                return false;
            }

            public void unlock() {
            }

            public void finished() {
            }

            public void restart() {
            }

            public boolean remove() {
                return true;
            }

            public boolean reschedule() {
                return false;
            }

            public boolean isAlive() {
                return false;
            }
        });
        this.processsingJobsLists.clear();
        this.startedJobsLists.clear();
        this.logger.info("Stopped job queue {}", (Object)this.queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUnprocessedJobs() {
        if (this.running) {
            long tooOld = System.currentTimeMillis() - 60000L;
            ArrayList<JobEvent> restartJobs = new ArrayList<JobEvent>();
            Map<String, JobEvent> map = this.startedJobsLists;
            synchronized (map) {
                for (Map.Entry<String, JobEvent> entry : this.startedJobsLists.entrySet()) {
                    if (entry.getValue().started > tooOld) continue;
                    restartJobs.add(entry.getValue());
                }
            }
            if (restartJobs.size() > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            }
            for (JobEvent info : restartJobs) {
                boolean process = false;
                Map<String, JobEvent> map2 = this.startedJobsLists;
                synchronized (map2) {
                    process = this.startedJobsLists.remove(info.uniqueId) != null;
                }
                if (!process) continue;
                if (!info.reschedule()) {
                    this.decQueued();
                    this.checkForNotify(null);
                    continue;
                }
                this.logger.info("No acknowledge received for job {} stored at {}. Requeueing job.", (Object)EventUtil.toString(info.event), (Object)info.uniqueId);
                this.checkForNotify(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendAcknowledge(Event job) {
        JobEvent ack;
        String location = (String)job.getProperty("slingevent:eventId");
        Map<String, JobEvent> map = this.startedJobsLists;
        synchronized (map) {
            ack = this.startedJobsLists.remove(location);
        }
        if (ack != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received ack for job {}", (Object)EventUtil.toString(job));
            }
            long queueTime = ack.started - ack.queued;
            this.addActive(queueTime);
            Utility.sendNotification(this.environment, "org/apache/sling/event/notification/job/START", job, queueTime);
            Map<String, JobEvent> map2 = this.processsingJobsLists;
            synchronized (map2) {
                this.processsingJobsLists.put(location, ack);
            }
        } else {
            this.decQueued();
        }
        return ack != null;
    }

    private boolean handleReschedule(JobEvent jobEvent, boolean shouldReschedule) {
        boolean reschedule = shouldReschedule;
        if (shouldReschedule) {
            int retries = this.configuration.getMaxRetries();
            if (jobEvent.event.getProperty("event.job.retries") != null) {
                retries = (Integer)jobEvent.event.getProperty("event.job.retries");
            }
            int retryCount = 0;
            if (jobEvent.event.getProperty("event.job.retrycount") != null) {
                retryCount = (Integer)jobEvent.event.getProperty("event.job.retrycount");
            }
            if (retries != -1 && ++retryCount > retries) {
                reschedule = false;
            }
            if (reschedule) {
                EventPropertiesMap newProperties = new EventPropertiesMap(jobEvent.event);
                ((Dictionary)newProperties).put("event.job.retrycount", retryCount);
                ((Dictionary)newProperties).put("event.job.retries", retries);
                jobEvent.event = new Event(jobEvent.event.getTopic(), (Dictionary)newProperties);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed job {}", (Object)EventUtil.toString(jobEvent.event));
                }
                this.failedJob();
                jobEvent.queued = System.currentTimeMillis();
                Utility.sendNotification(this.environment, "org/apache/sling/event/notification/job/FAILED", jobEvent.event, null);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cancelled job {}", (Object)EventUtil.toString(jobEvent.event));
                }
                this.cancelledJob();
                Utility.sendNotification(this.environment, "org/apache/sling/event/notification/job/CANCELLED", jobEvent.event, null);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished job {}", (Object)EventUtil.toString(jobEvent.event));
            }
            long processingTime = System.currentTimeMillis() - jobEvent.started;
            this.finishedJob(processingTime);
            Utility.sendNotification(this.environment, "org/apache/sling/event/notification/job/FINISHED", jobEvent.event, processingTime);
        }
        return reschedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finishedJob(Event job, boolean shouldReschedule) {
        boolean finishSuccessful;
        JobEvent info;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received finish for job {}, shouldReschedule={}", (Object)EventUtil.toString(job), (Object)shouldReschedule);
        }
        if (!this.running) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Queue is not running anymore. Discarding finish for {}", (Object)EventUtil.toString(job));
            }
            return false;
        }
        String location = (String)job.getProperty("slingevent:eventId");
        Map<String, JobEvent> map = this.startedJobsLists;
        synchronized (map) {
            this.startedJobsLists.remove(location);
        }
        Map<String, JobEvent> map2 = this.processsingJobsLists;
        synchronized (map2) {
            info = this.processsingJobsLists.remove(location);
        }
        if (info == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("This job has never been started by this queue: {}", (Object)EventUtil.toString(job));
            }
            return false;
        }
        boolean reschedule = this.handleReschedule(info, shouldReschedule);
        if (!reschedule) {
            info.finished();
            finishSuccessful = true;
        } else {
            finishSuccessful = info.reschedule();
        }
        if (!finishSuccessful || !reschedule) {
            this.checkForNotify(null);
            return false;
        }
        this.checkForNotify(info);
        return true;
    }

    private void checkForNotify(JobEvent info) {
        JobEvent reprocessInfo = null;
        if (info != null) {
            reprocessInfo = this.reschedule(info);
        }
        this.notifyFinished(reprocessInfo);
    }

    protected boolean canBeMarkedForRemoval() {
        return this.isEmpty() && !this.isWaiting && !this.isSuspended();
    }

    public void markForRemoval() {
        if (this.canBeMarkedForRemoval()) {
            this.markedForRemoval = true;
        }
    }

    public boolean isMarkedForRemoval() {
        if (this.markedForRemoval) {
            if (this.canBeMarkedForRemoval()) {
                return true;
            }
            this.markedForRemoval = false;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.queueName;
    }

    public void process(JobEvent event) {
        this.put(event);
        event.queued = System.currentTimeMillis();
        this.incQueued();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSuspended() {
        Object object = this.suspendLock;
        synchronized (object) {
            while (this.suspendedSince != -1L) {
                try {
                    this.suspendLock.wait(3600000L);
                }
                catch (InterruptedException ignore) {
                    this.ignoreException(ignore);
                }
                if (System.currentTimeMillis() <= this.suspendedSince + 3600000L) continue;
                this.resume();
            }
        }
    }

    private void runJobQueue() {
        JobEvent info = null;
        while (this.running) {
            if (info == null) {
                info = this.take();
            }
            this.checkSuspended();
            if (info == null || !this.running) continue;
            info = this.start(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeJob(JobEvent info) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing job {}.", (Object)EventUtil.toString(info.event));
        }
        if (info.lock()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting job {}", (Object)EventUtil.toString(info.event));
            }
            boolean unlock = true;
            try {
                Event jobEvent = this.getJobEvent(info);
                EventAdmin localEA = this.environment.getEventAdmin();
                info.started = System.currentTimeMillis();
                Map<String, JobEvent> map = this.startedJobsLists;
                synchronized (map) {
                    this.startedJobsLists.put(info.uniqueId, info);
                }
                localEA.postEvent(jobEvent);
                unlock = false;
                boolean bl = true;
                return bl;
            }
            catch (Exception re) {
                this.logger.error("Exception during job processing.", (Throwable)re);
            }
            finally {
                if (unlock) {
                    info.unlock();
                }
            }
        }
        this.decQueued();
        return false;
    }

    private Event getJobEvent(JobEvent info) {
        String eventTopic = (String)info.event.getProperty("event.job.topic");
        EventPropertiesMap properties = new EventPropertiesMap(info.event);
        ((Dictionary)properties).put(JobStatusNotifier.CONTEXT_PROPERTY_NAME, new JobStatusNotifier.NotifierContext(this));
        ((Dictionary)properties).remove("event.distribute");
        ((Dictionary)properties).remove("event.application");
        if (((Dictionary)properties).get("event.job.priority") == null) {
            ((Dictionary)properties).put("event.job.priority", this.configuration.getPriority());
        }
        ((Dictionary)properties).put("event.job.queuename", info.queueName);
        return new Event(eventTopic, (Dictionary)properties);
    }

    protected void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    public void rename(String name) {
        this.logger.info("Queue reconfiguration: old queue {} is renamed to {}.", (Object)this.queueName, (Object)name);
        this.queueName = name;
    }

    protected abstract JobEvent reschedule(JobEvent var1);

    @Override
    public Statistics getStatistics() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.suspendedSince != -1L) {
                this.suspendedSince = -1L;
                this.suspendLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.suspendedSince == -1L) {
                this.suspendedSince = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuspended() {
        Object object = this.suspendLock;
        synchronized (object) {
            return this.suspendedSince != -1L;
        }
    }

    @Override
    public synchronized void removeAll() {
        boolean wasSuspended = this.isSuspended();
        this.suspend();
        final Collection<JobEvent> events = this.removeAllJobs();
        this.clearQueued();
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (JobEvent job : events) {
                    job.remove();
                }
            }
        }, "Queue RemoveAll Thread for " + this.queueName);
        t.setDaemon(true);
        t.start();
        if (!wasSuspended) {
            this.resume();
        }
    }

    @Override
    public void clear() {
        this.clearQueued();
    }

    @Override
    public Object getState(String key) {
        return null;
    }

    protected abstract void put(JobEvent var1);

    protected abstract JobEvent take();

    protected abstract boolean isEmpty();

    protected abstract Collection<JobEvent> removeAllJobs();

    protected abstract JobEvent start(JobEvent var1);

    protected abstract void notifyFinished(JobEvent var1);
}

