/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.Date;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;

public abstract class AbstractParallelJobQueue
extends AbstractJobQueue {
    protected volatile int jobCount;
    private final Scheduler scheduler;
    private final Object syncLock = new Object();

    public AbstractParallelJobQueue(String name, InternalQueueConfiguration config, EnvironmentComponent env, Scheduler scheduler) {
        super(name, config, env);
        this.scheduler = scheduler;
    }

    public String getStateInfo() {
        return super.getStateInfo() + ", jobCount=" + this.jobCount;
    }

    protected JobEvent start(JobEvent processInfo) {
        this.acquireSlot();
        if (!this.executeJob(processInfo)) {
            this.freeSlot();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireSlot() {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.jobCount >= this.configuration.getMaxParallel()) {
                this.isWaiting = true;
                this.logger.debug("Job queue {} is processing {} jobs - waiting for a free slot.", (Object)this.queueName, (Object)this.jobCount);
                while (this.isWaiting) {
                    try {
                        this.syncLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                }
                this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
            }
            ++this.jobCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSlot() {
        Object object = this.syncLock;
        synchronized (object) {
            --this.jobCount;
            if (this.isWaiting) {
                this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
                this.isWaiting = false;
                this.syncLock.notify();
            }
        }
    }

    protected boolean canBeMarkedForRemoval() {
        boolean result = super.canBeMarkedForRemoval();
        if (result) {
            result = this.jobCount == 0;
        }
        return result;
    }

    protected void notifyFinished(JobEvent rescheduleInfo) {
        this.freeSlot();
    }

    protected JobEvent reschedule(final JobEvent info) {
        long delay = this.configuration.getRetryDelayInMs();
        if (info.event.getProperty("event.job.retrydelay") != null) {
            delay = (Long)info.event.getProperty("event.job.retrydelay");
        }
        if (delay > 0L) {
            Date fireDate = new Date();
            fireDate.setTime(System.currentTimeMillis() + delay);
            String jobName = "Waiting:" + this.queueName + ":" + info.hashCode();
            Runnable t = new Runnable(){

                public void run() {
                    AbstractParallelJobQueue.this.put(info);
                }
            };
            try {
                this.scheduler.fireJobAt(jobName, (Object)t, null, fireDate);
            }
            catch (Exception e) {
                this.ignoreException(e);
                t.run();
            }
        } else {
            this.put(info);
        }
        return null;
    }
}

