/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractParallelJobQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopicRoundRobinJobQueue
extends AbstractParallelJobQueue {
    private final List<String> topics = new ArrayList<String>();
    private final Map<String, List<JobEvent>> topicMap = new HashMap<String, List<JobEvent>>();
    private int topicIndex;
    private int eventCount;
    private boolean isWaitingForNext = false;

    public TopicRoundRobinJobQueue(String name, InternalQueueConfiguration config, EnvironmentComponent env, Scheduler scheduler) {
        super(name, config, env, scheduler);
    }

    @Override
    public String getStateInfo() {
        return super.getStateInfo() + ", eventCount=" + this.eventCount + ", isWaitingForNext=" + this.isWaitingForNext;
    }

    @Override
    protected boolean canBeMarkedForRemoval() {
        boolean result = super.canBeMarkedForRemoval();
        if (result) {
            result = !this.isWaitingForNext;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void put(JobEvent event) {
        if (event.event == null) {
            return;
        }
        String topic = (String)event.event.getProperty("event.job.topic");
        Map<String, List<JobEvent>> map = this.topicMap;
        synchronized (map) {
            List<JobEvent> events = this.topicMap.get(topic);
            if (events == null) {
                events = new LinkedList<JobEvent>();
                this.topicMap.put(topic, events);
                this.topics.add(topic);
            }
            events.add(event);
            ++this.eventCount;
            if (this.isWaitingForNext) {
                this.isWaitingForNext = false;
                this.topicMap.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobEvent take() {
        JobEvent e = null;
        Map<String, List<JobEvent>> map = this.topicMap;
        synchronized (map) {
            if (this.eventCount == 0) {
                this.isWaitingForNext = true;
                while (this.isWaitingForNext) {
                    try {
                        this.topicMap.wait();
                    }
                    catch (InterruptedException ie) {
                        this.ignoreException(ie);
                    }
                }
            }
            if (this.eventCount > 0) {
                while (e == null) {
                    String topic = this.topics.get(this.topicIndex);
                    List<JobEvent> events = this.topicMap.get(topic);
                    if (events.size() > 0) {
                        e = events.remove(0);
                    }
                    ++this.topicIndex;
                    if (this.topicIndex != this.topics.size()) continue;
                    this.topicIndex = 0;
                }
                --this.eventCount;
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isEmpty() {
        Map<String, List<JobEvent>> map = this.topicMap;
        synchronized (map) {
            return this.eventCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, List<JobEvent>> map = this.topicMap;
        synchronized (map) {
            this.eventCount = 0;
            this.topics.clear();
            this.topicMap.clear();
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<JobEvent> removeAllJobs() {
        ArrayList<JobEvent> events = new ArrayList<JobEvent>();
        Map<String, List<JobEvent>> map = this.topicMap;
        synchronized (map) {
            for (List<JobEvent> l : this.topicMap.values()) {
                events.addAll(l);
            }
            this.eventCount = 0;
            this.topics.clear();
            this.topicMap.clear();
        }
        return events;
    }
}

