/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.util.Calendar;
import java.util.Dictionary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.AbstractRepositoryEventHandler;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributingEventHandler
extends AbstractRepositoryEventHandler
implements Runnable {
    private static final int DEFAULT_CLEANUP_PERIOD = 15;
    private static final String CONFIG_PROPERTY_CLEANUP_PERIOD = "cleanup.period";
    private int cleanupPeriod = 15;

    @Override
    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.cleanupPeriod = PropertiesUtil.toInteger(props.get(CONFIG_PROPERTY_CLEANUP_PERIOD), 15);
        super.activate(context);
    }

    protected Query getCleanUpQuery(Session s) throws RepositoryException {
        String selectorName = "nodetype";
        Calendar deleteBefore = Calendar.getInstance();
        deleteBefore.add(12, -this.cleanupPeriod);
        QueryObjectModelFactory qomf = s.getWorkspace().getQueryManager().getQOMFactory();
        QueryObjectModel q = qomf.createQuery((Source)qomf.selector(this.getEventNodeType(), "nodetype"), (Constraint)qomf.and((Constraint)qomf.descendantNode("nodetype", this.repositoryPath), (Constraint)qomf.comparison((DynamicOperand)qomf.propertyValue("nodetype", "slingevent:created"), "jcr.operator.less.than", (StaticOperand)qomf.literal(s.getValueFactory().createValue(deleteBefore)))), null, null);
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.cleanupPeriod > 0) {
            this.logger.debug("Cleaning up repository, removing all entries older than {} minutes.", (Object)this.cleanupPeriod);
            Session s = null;
            try {
                s = this.environment.createAdminSession();
                Query q = this.getCleanUpQuery(s);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Executing query {}", (Object)q.getStatement());
                }
                NodeIterator iter = q.execute().getNodes();
                int count = 0;
                while (iter.hasNext()) {
                    Node eventNode = iter.nextNode();
                    eventNode.remove();
                    ++count;
                }
                s.save();
                this.logger.debug("Removed {} entries from the repository.", (Object)count);
            }
            catch (RepositoryException e) {
                this.logger.warn("Exception during repository cleanup.", (Throwable)e);
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        }
    }

    @Override
    protected void processWriteQueue() {
        while (this.running) {
            org.osgi.service.event.Event event = null;
            try {
                event = (org.osgi.service.event.Event)this.writeQueue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (event == null || !this.running) continue;
            try {
                this.writeEvent(event, null);
            }
            catch (Exception e) {
                this.logger.error("Exception during writing the event to the repository.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInBackground() {
        while (this.running) {
            AbstractRepositoryEventHandler.EventInfo info = null;
            try {
                info = (AbstractRepositoryEventHandler.EventInfo)this.queue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (info == null || !this.running || info.nodePath == null) continue;
            Session session = null;
            try {
                session = this.environment.createAdminSession();
                Node eventNode = (Node)session.getItem(info.nodePath);
                if (!eventNode.isNodeType(this.getEventNodeType())) continue;
                EventAdmin localEA = this.environment.getEventAdmin();
                if (localEA != null) {
                    localEA.postEvent(this.readEvent(eventNode));
                    continue;
                }
                this.logger.error("Unable to post event as no event admin is available.");
            }
            catch (Exception ex) {
                this.logger.error("Exception during reading the event from the repository.", (Throwable)ex);
            }
            finally {
                if (session == null) continue;
                session.logout();
            }
        }
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        try {
            this.writeQueue.put(event);
        }
        catch (InterruptedException ex) {
            this.ignoreException(ex);
        }
    }

    public void onEvent(EventIterator iterator) {
        while (iterator.hasNext()) {
            Event event = iterator.nextEvent();
            try {
                AbstractRepositoryEventHandler.EventInfo info = new AbstractRepositoryEventHandler.EventInfo();
                info.nodePath = event.getPath();
                this.queue.put(info);
            }
            catch (InterruptedException ex) {
                this.ignoreException(ex);
            }
            catch (RepositoryException ex) {
                this.logger.error("Exception during reading the event from the repository.", (Throwable)ex);
            }
        }
    }

    @Override
    protected void addEventProperties(Node eventNode, Dictionary<String, Object> properties) throws RepositoryException {
        super.addEventProperties(eventNode, properties);
        properties.put("event.application", eventNode.getProperty("slingevent:application").getString());
    }

    @Override
    protected void startWriterSession() throws RepositoryException {
        super.startWriterSession();
        this.writerSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 1, this.repositoryPath, true, null, null, true);
    }
}

