/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.threads.ModifiableThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.service.component.ComponentContext;

public class EventingThreadPool
implements ThreadPool {
    private ThreadPoolManager threadPoolManager;
    private ThreadPool threadPool;
    private static final int DEFAULT_POOL_SIZE = 35;
    private static final String PROPERTY_POOL_SIZE = "minPoolSize";
    private static final String PROPERTY_PRIORITY = "priority";

    protected void activate(ComponentContext ctx) {
        ModifiableThreadPoolConfig config = new ModifiableThreadPoolConfig();
        config.setMinPoolSize(PropertiesUtil.toInteger(ctx.getProperties().get(PROPERTY_POOL_SIZE), 35));
        config.setMaxPoolSize(config.getMinPoolSize());
        config.setQueueSize(-1);
        config.setShutdownGraceful(true);
        config.setPriority(ThreadPoolConfig.ThreadPriority.valueOf((String)PropertiesUtil.toString(ctx.getProperties().get(PROPERTY_PRIORITY), "NORM")));
        config.setDaemon(true);
        this.threadPool = this.threadPoolManager.create((ThreadPoolConfig)config, "Apache Sling Eventing Thread Pool");
    }

    protected void deactivate(ComponentContext context) {
        this.threadPoolManager.release(this.threadPool);
    }

    public void execute(Runnable runnable) {
        this.threadPool.execute(runnable);
    }

    public ThreadPoolConfig getConfiguration() {
        return this.threadPool.getConfiguration();
    }

    public String getName() {
        return this.threadPool.getName();
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }
}

