/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.sling.event.jobs.JobsIterator;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobsIteratorImpl
implements JobsIterator {
    private final long size;
    private int index = 0;
    private final Iterator<Event> iter;

    public JobsIteratorImpl(List<Event> events) {
        this.size = events.size();
        this.iter = events.iterator();
    }

    @Override
    public long getPosition() {
        return this.index;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void skip(long skipNum) {
        if (skipNum < 0L) {
            throw new IllegalArgumentException();
        }
        if ((long)this.index + skipNum >= this.size) {
            throw new NoSuchElementException();
        }
        for (long i = 0L; i < skipNum; ++i) {
            this.iter.next();
        }
        this.index = (int)((long)this.index + skipNum);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Event next() {
        return this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }
}

