/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.Arrays;
import java.util.Map;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.config.ConfigurationConstants;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalQueueConfiguration
implements QueueConfiguration {
    private String name;
    private QueueConfiguration.Type type;
    private int retries;
    private long retryDelay;
    private boolean runLocal;
    private JobUtil.JobPriority priority;
    private int maxParallelProcesses;
    private String[] applicationIds;
    private int serviceRanking;
    private Matcher[] matchers;
    private String[] topics;
    private boolean valid = false;
    private String pid;

    public static InternalQueueConfiguration fromConfiguration(Map<String, Object> params) {
        InternalQueueConfiguration c = new InternalQueueConfiguration();
        c.activate(params);
        return c;
    }

    public InternalQueueConfiguration() {
    }

    protected void activate(Map<String, Object> params) {
        this.name = PropertiesUtil.toString(params.get("queue.name"), null);
        this.priority = JobUtil.JobPriority.valueOf(PropertiesUtil.toString(params.get("queue.priority"), "NORM"));
        this.type = QueueConfiguration.Type.valueOf(PropertiesUtil.toString(params.get("queue.type"), "UNORDERED"));
        this.runLocal = PropertiesUtil.toBoolean(params.get("queue.runlocal"), false);
        this.retries = PropertiesUtil.toInteger(params.get("queue.retries"), 10);
        this.retryDelay = PropertiesUtil.toLong(params.get("queue.retrydelay"), 2000L);
        int maxParallel = PropertiesUtil.toInteger(params.get("queue.maxparallel"), 15);
        this.maxParallelProcesses = maxParallel == -1 ? ConfigurationConstants.NUMBER_OF_PROCESSORS : maxParallel;
        String[] appIds = PropertiesUtil.toStringArray(params.get("queue.applicationids"));
        this.applicationIds = appIds == null || appIds.length == 0 || appIds.length == 1 && (appIds[0] == null || appIds[0].length() == 0) ? null : appIds;
        String[] topicsParam = PropertiesUtil.toStringArray(params.get("queue.topics"));
        if (topicsParam == null || topicsParam.length == 0 || topicsParam.length == 1 && (topicsParam[0] == null || topicsParam[0].length() == 0)) {
            this.matchers = null;
            this.topics = null;
        } else {
            Matcher[] newMatchers = new Matcher[topicsParam.length];
            for (int i = 0; i < topicsParam.length; ++i) {
                String value = topicsParam[i];
                if (value != null) {
                    value = value.trim();
                }
                if (value == null || value.length() <= 0) continue;
                newMatchers[i] = value.endsWith(".") ? new PackageMatcher(value) : (value.endsWith("*") ? new SubPackageMatcher(value) : new ClassMatcher(value));
            }
            this.matchers = newMatchers;
            this.topics = topicsParam;
        }
        this.serviceRanking = PropertiesUtil.toInteger(params.get("service.ranking"), 0);
        this.pid = (String)params.get("service.pid");
        this.valid = this.checkIsValid();
    }

    public InternalQueueConfiguration(Event jobEvent) {
        this.name = (String)jobEvent.getProperty("event.job.queuename");
        if (jobEvent.getProperty("event.job.queueordered") != null) {
            this.type = QueueConfiguration.Type.ORDERED;
            this.maxParallelProcesses = 1;
        } else {
            this.type = QueueConfiguration.Type.UNORDERED;
            int maxPar = 15;
            Object value = jobEvent.getProperty("event.job.parallel");
            if (value != null) {
                if (value instanceof Boolean) {
                    boolean result = (Boolean)value;
                    if (!result) {
                        maxPar = 1;
                    }
                } else if (value instanceof Number) {
                    int result = ((Number)value).intValue();
                    maxPar = result > 1 ? result : 1;
                } else {
                    String strValue = value.toString();
                    if ("no".equalsIgnoreCase(strValue) || "false".equalsIgnoreCase(strValue)) {
                        maxPar = 1;
                    } else {
                        try {
                            int result = Integer.valueOf(strValue);
                            maxPar = result > 1 ? result : 1;
                        }
                        catch (NumberFormatException ne) {
                            // empty catch block
                        }
                    }
                }
            }
            if (maxPar == -1) {
                maxPar = ConfigurationConstants.NUMBER_OF_PROCESSORS;
            }
            this.maxParallelProcesses = maxPar;
        }
        this.priority = JobUtil.JobPriority.valueOf("NORM");
        this.runLocal = false;
        this.retries = 10;
        this.retryDelay = 2000L;
        this.serviceRanking = 0;
        this.applicationIds = null;
        this.matchers = null;
        this.topics = new String[]{"<Custom:" + jobEvent.getProperty("event.job.topic") + ">"};
        this.valid = true;
    }

    private boolean checkIsValid() {
        boolean hasMatchers = false;
        if (this.matchers != null) {
            for (Matcher m : this.matchers) {
                if (m == null) continue;
                hasMatchers = true;
            }
        }
        if (!hasMatchers) {
            return false;
        }
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        if (this.retries < -1) {
            return false;
        }
        return this.type != QueueConfiguration.Type.UNORDERED && this.type != QueueConfiguration.Type.TOPIC_ROUND_ROBIN || this.maxParallelProcesses >= 1;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean match(JobEvent event) {
        String topic = (String)event.event.getProperty("event.job.topic");
        if (this.matchers != null) {
            for (Matcher m : this.matchers) {
                String rep;
                if (m == null || (rep = m.match(topic)) == null) continue;
                event.queueName = this.name.replace("{0}", rep);
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSkipped(JobEvent event) {
        if (this.type == QueueConfiguration.Type.IGNORE) {
            return true;
        }
        if (this.applicationIds != null) {
            boolean found = false;
            for (String id : this.applicationIds) {
                if (!Environment.APPLICATION_ID.equals(id)) continue;
                found = true;
            }
            if (!found) {
                return true;
            }
        }
        return this.runLocal && !event.event.getProperty("event.application").equals(Environment.APPLICATION_ID);
    }

    @Override
    public long getRetryDelayInMs() {
        return this.retryDelay;
    }

    @Override
    public int getMaxRetries() {
        return this.retries;
    }

    @Override
    public QueueConfiguration.Type getType() {
        return this.type;
    }

    @Override
    public JobUtil.JobPriority getPriority() {
        return this.priority;
    }

    @Override
    public int getMaxParallel() {
        return this.maxParallelProcesses;
    }

    @Override
    public boolean isLocalQueue() {
        return this.runLocal;
    }

    @Override
    public String[] getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public String[] getTopics() {
        return this.topics;
    }

    @Override
    public int getRanking() {
        return this.serviceRanking;
    }

    public String getPid() {
        return this.pid;
    }

    public String toString() {
        return "Queue-Configuration(" + this.hashCode() + ") : {" + "name=" + this.name + ", type=" + (Object)((Object)this.type) + ", topics=" + (this.matchers == null ? "[]" : Arrays.toString(this.matchers)) + ", maxParallelProcesses=" + this.maxParallelProcesses + ", retries=" + this.retries + ", retryDelayInMs= " + this.retryDelay + ", applicationIds= " + (this.applicationIds == null ? "[]" : Arrays.toString(this.applicationIds)) + ", serviceRanking=" + this.serviceRanking + ", pid=" + this.pid + ", isValid=" + this.isValid() + "}";
    }

    private static final class ClassMatcher
    implements Matcher {
        private final String className;

        public ClassMatcher(String name) {
            this.className = name;
        }

        public String match(String topic) {
            return this.className.equals(topic) ? "" : null;
        }
    }

    private static final class SubPackageMatcher
    implements Matcher {
        private final String packageName;

        public SubPackageMatcher(String name) {
            int lastPos = name.length() - 1;
            this.packageName = lastPos > 0 && name.charAt(lastPos - 1) == '/' ? name.substring(0, lastPos) : name.substring(0, lastPos) + '/';
        }

        public String match(String topic) {
            int pos = topic.lastIndexOf(47);
            return pos > -1 && topic.substring(0, pos + 1).startsWith(this.packageName) ? topic.substring(this.packageName.length()) : null;
        }
    }

    private static final class PackageMatcher
    implements Matcher {
        private final String packageName;

        public PackageMatcher(String name) {
            int lastPos = name.length() - 1;
            if (lastPos > 0 && name.charAt(lastPos - 1) == '/') {
                --lastPos;
            }
            this.packageName = name.substring(0, lastPos);
        }

        public String match(String topic) {
            int pos = topic.lastIndexOf(47);
            return pos > -1 && topic.substring(0, pos).equals(this.packageName) ? topic.substring(pos + 1) : null;
        }
    }

    private static interface Matcher {
        public String match(String var1);
    }
}

