/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedJobQueue
extends AbstractJobQueue {
    private volatile JobEvent jobEvent;
    private final SleepLock sleepLock = new SleepLock();
    private final BlockingQueue<JobEvent> queue = new LinkedBlockingQueue<JobEvent>();
    private final Object syncLock = new Object();

    public OrderedJobQueue(String name, InternalQueueConfiguration config, EnvironmentComponent env) {
        super(name, config, env);
    }

    @Override
    public String getStateInfo() {
        return super.getStateInfo() + ", isSleepingUntil=" + this.sleepLock.sleepingSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobEvent start(JobEvent processInfo) {
        JobEvent rescheduleInfo = null;
        Object object = this.syncLock;
        synchronized (object) {
            if (this.executeJob(processInfo)) {
                this.isWaiting = true;
                this.logger.debug("Job queue {} is waiting for finish.", (Object)this.queueName);
                while (this.isWaiting) {
                    try {
                        this.syncLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                }
                this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
                rescheduleInfo = this.jobEvent;
                this.jobEvent = null;
            }
        }
        return rescheduleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp(boolean discardJob) {
        SleepLock sleepLock = this.sleepLock;
        synchronized (sleepLock) {
            if (this.sleepLock.sleepingSince != -1L) {
                if (discardJob) {
                    this.sleepLock.jobEvent = null;
                }
                this.sleepLock.notify();
            }
        }
    }

    @Override
    public void resume() {
        this.wakeUp(false);
        super.resume();
    }

    @Override
    protected void put(JobEvent event) {
        try {
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
    }

    @Override
    protected JobEvent take() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            return null;
        }
    }

    @Override
    protected boolean isEmpty() {
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyFinished(JobEvent rescheduleInfo) {
        this.jobEvent = rescheduleInfo;
        this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
        Object object = this.syncLock;
        synchronized (object) {
            this.isWaiting = false;
            this.syncLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobEvent reschedule(JobEvent info) {
        long delay = this.configuration.getRetryDelayInMs();
        if (info.event.getProperty("event.job.retrydelay") != null) {
            delay = (Long)info.event.getProperty("event.job.retrydelay");
        }
        if (delay > 0L) {
            SleepLock sleepLock = this.sleepLock;
            synchronized (sleepLock) {
                this.sleepLock.sleepingSince = System.currentTimeMillis();
                this.sleepLock.jobEvent = info;
                this.logger.debug("Job queue {} is sleeping for {}ms.", (Object)this.queueName, (Object)delay);
                try {
                    this.sleepLock.wait(delay);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
                this.sleepLock.sleepingSince = -1L;
                JobEvent result = this.sleepLock.jobEvent;
                this.sleepLock.jobEvent = null;
                if (result == null) {
                    info.remove();
                }
                return result;
            }
        }
        return info;
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }

    @Override
    public synchronized void removeAll() {
        super.removeAll();
        this.jobEvent = null;
        this.wakeUp(true);
    }

    @Override
    protected Collection<JobEvent> removeAllJobs() {
        ArrayList<JobEvent> events = new ArrayList<JobEvent>();
        this.queue.drainTo(events);
        return events;
    }

    @Override
    public Object getState(String key) {
        if ("isSleepingUntil".equals(key)) {
            return this.sleepLock.sleepingSince;
        }
        return super.getState(key);
    }

    private static final class SleepLock {
        public volatile long sleepingSince = -1L;
        public volatile JobEvent jobEvent;

        private SleepLock() {
        }
    }
}

