/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.JobEvent;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractParallelJobQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParallelJobQueue
extends AbstractParallelJobQueue {
    private final BlockingQueue<JobEvent> queue = new LinkedBlockingQueue<JobEvent>();

    public ParallelJobQueue(String name, InternalQueueConfiguration config, EnvironmentComponent env, Scheduler scheduler) {
        super(name, config, env, scheduler);
    }

    @Override
    protected void put(JobEvent event) {
        try {
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
    }

    @Override
    protected JobEvent take() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            return null;
        }
    }

    @Override
    protected boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }

    @Override
    protected Collection<JobEvent> removeAllJobs() {
        ArrayList<JobEvent> events = new ArrayList<JobEvent>();
        this.queue.drainTo(events);
        return events;
    }
}

