/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event;

import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.sling.event.JobProcessor;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.jobs.JobUtil;
import org.osgi.service.event.Event;

public abstract class EventUtil {
    public static final String PROPERTY_DISTRIBUTE = "event.distribute";
    public static final String PROPERTY_APPLICATION = "event.application";
    @Deprecated
    public static final String PROPERTY_JOB_TOPIC = "event.job.topic";
    @Deprecated
    public static final String PROPERTY_JOB_ID = "event.job.id";
    @Deprecated
    public static final String PROPERTY_JOB_PARALLEL = "event.job.parallel";
    @Deprecated
    public static final String PROPERTY_JOB_RUN_LOCAL = "event.job.run.local";
    @Deprecated
    public static final String PROPERTY_JOB_RETRY_COUNT = "event.job.retrycount";
    @Deprecated
    public static final String PROPERTY_JOB_RETRIES = "event.job.retries";
    @Deprecated
    public static final String PROPERTY_JOB_RETRY_DELAY = "event.job.retrydelay";
    @Deprecated
    public static final String PROPERTY_JOB_QUEUE_NAME = "event.job.queuename";
    @Deprecated
    public static final String PROPERTY_JOB_QUEUE_ORDERED = "event.job.queueordered";
    @Deprecated
    public static final String PROPERTY_JOB_PRIORITY = "event.job.priority";
    @Deprecated
    public static final String TOPIC_JOB = "org/apache/sling/event/job";
    public static final String TOPIC_TIMED_EVENT = "org/apache/sling/event/timed";
    public static final String PROPERTY_TIMED_EVENT_TOPIC = "event.topic.timed";
    public static final String PROPERTY_TIMED_EVENT_ID = "event.timed.id";
    public static final String PROPERTY_TIMED_EVENT_SCHEDULE = "event.timed.scheduler";
    public static final String PROPERTY_TIMED_EVENT_PERIOD = "event.timed.period";
    public static final String PROPERTY_TIMED_EVENT_DATE = "event.timed.date";
    @Deprecated
    public static final String TOPIC_JOB_STARTED = "org/apache/sling/event/notification/job/START";
    @Deprecated
    public static final String TOPIC_JOB_FINISHED = "org/apache/sling/event/notification/job/FINISHED";
    @Deprecated
    public static final String TOPIC_JOB_FAILED = "org/apache/sling/event/notification/job/FAILED";
    @Deprecated
    public static final String TOPIC_JOB_CANCELLED = "org/apache/sling/event/notification/job/CANCELLED";
    @Deprecated
    public static final String PROPERTY_NOTIFICATION_JOB = "event.notification.job";

    public static Event createDistributableEvent(String topic, Dictionary<String, Object> properties) {
        Hashtable<String, Object> newProperties = new Hashtable<String, Object>();
        if (properties != null) {
            Enumeration<String> e = properties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                ((Dictionary)newProperties).put(key, properties.get(key));
            }
        }
        ((Dictionary)newProperties).put(PROPERTY_DISTRIBUTE, "");
        return new Event(topic, newProperties);
    }

    public static boolean shouldDistribute(Event event) {
        return event.getProperty(PROPERTY_DISTRIBUTE) != null;
    }

    public static boolean isLocal(Event event) {
        String appId = EventUtil.getApplicationId(event);
        return appId == null || appId.equals(Environment.APPLICATION_ID);
    }

    public static String getApplicationId(Event event) {
        return (String)event.getProperty(PROPERTY_APPLICATION);
    }

    public static String toString(Event e) {
        if (e == null) {
            return "<null>";
        }
        StringBuilder buffer = new StringBuilder(e.getClass().getName());
        buffer.append('(');
        buffer.append(e.hashCode());
        buffer.append(") [topic=");
        buffer.append(e.getTopic());
        buffer.append(", properties=");
        String[] names = e.getPropertyNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(names[i]);
                buffer.append('=');
                Object value = e.getProperty(names[i]);
                if (value instanceof Calendar) {
                    buffer.append(value.getClass().getName());
                    buffer.append('(');
                    buffer.append(((Calendar)value).getTime());
                    buffer.append(')');
                    continue;
                }
                buffer.append(value);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Deprecated
    public static boolean isJobEvent(Event event) {
        return JobUtil.isJobEvent(event);
    }

    @Deprecated
    public static boolean acknowledgeJob(Event job) {
        return JobUtil.acknowledgeJob(job);
    }

    @Deprecated
    public static void finishedJob(Event job) {
        JobUtil.finishedJob(job);
    }

    @Deprecated
    public static boolean rescheduleJob(Event job) {
        return JobUtil.rescheduleJob(job);
    }

    @Deprecated
    public static void processJob(Event job, JobProcessor processor) {
        JobUtil.processJob(job, processor);
    }

    public static enum JobPriority {
        NORM,
        MIN,
        MAX;

    }
}

