/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.event.impl.support.TopicMatcher;
import org.apache.sling.event.impl.support.TopicMatcherHelper;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.LoggerFactory;

@Component(label="%job.consumermanager.name", description="%job.consumermanager.description", metatype=true)
@Service(value={JobConsumerManager.class})
@Reference(referenceInterface=JobConsumer.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
@Property(name="org.apache.sling.installer.configuration.persist", boolValue={false}, propertyPrivate=true)
public class JobConsumerManager {
    @Property(unbounded=PropertyUnbounded.ARRAY, value={"*"})
    private static final String PROPERTY_WHITELIST = "job.consumermanager.whitelist";
    @Property(unbounded=PropertyUnbounded.ARRAY)
    private static final String PROPERTY_BLACKLIST = "job.consumermanager.blacklist";
    private final Map<String, List<ConsumerInfo>> topicToConsumerMap = new HashMap<String, List<ConsumerInfo>>();
    private boolean supportsBridgedEvents;
    private ServiceRegistration propagationService;
    private String topics;
    private TopicMatcher[] whitelistMatchers;
    private TopicMatcher[] blacklistMatchers;
    private volatile long changeCount;
    private BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> getRegistrationProperties() {
        Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
        ((Dictionary)serviceProps).put("instance.properties", "org.apache.sling.event.jobs.consumer.topics");
        JobConsumerManager jobConsumerManager = this;
        synchronized (jobConsumerManager) {
            ((Dictionary)serviceProps).put("changeCount", this.changeCount++);
        }
        return serviceProps;
    }

    @Activate
    protected void activate(BundleContext bc, Map<String, Object> props) {
        this.bundleContext = bc;
        this.modified(bc, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(BundleContext bc, Map<String, Object> props) {
        boolean enable;
        boolean wasEnabled = this.propagationService != null;
        this.whitelistMatchers = TopicMatcherHelper.buildMatchers(PropertiesUtil.toStringArray(props.get(PROPERTY_WHITELIST)));
        this.blacklistMatchers = TopicMatcherHelper.buildMatchers(PropertiesUtil.toStringArray(props.get(PROPERTY_BLACKLIST)));
        boolean bl = enable = this.whitelistMatchers != null && this.blacklistMatchers != TopicMatcherHelper.MATCH_ALL;
        if (wasEnabled != enable) {
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                this.calculateTopics(enable);
            }
            if (enable) {
                LoggerFactory.getLogger(this.getClass()).info("Registering property provider with: {}", (Object)this.topics);
                this.propagationService = bc.registerService(PropertyProvider.class.getName(), (Object)new PropertyProvider(){

                    public String getProperty(String name) {
                        if ("org.apache.sling.event.jobs.consumer.topics".equals(name)) {
                            return JobConsumerManager.this.topics;
                        }
                        return null;
                    }
                }, this.getRegistrationProperties());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("Unregistering property provider with");
                this.propagationService.unregister();
                this.propagationService = null;
            }
        } else if (enable) {
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                this.calculateTopics(true);
            }
            LoggerFactory.getLogger(this.getClass()).info("Updating property provider with: {}", (Object)this.topics);
            this.propagationService.setProperties(this.getRegistrationProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        if (this.propagationService != null) {
            this.propagationService.unregister();
            this.propagationService = null;
        }
        this.bundleContext = null;
        Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
        synchronized (map) {
            this.topicToConsumerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobConsumer getConsumer(String topic) {
        Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
        synchronized (map) {
            String category;
            List<ConsumerInfo> categoryConsumers;
            List<ConsumerInfo> consumers = this.topicToConsumerMap.get(topic);
            if (consumers != null) {
                return consumers.get(0).getConsumer(this.bundleContext);
            }
            int pos = topic.lastIndexOf(47);
            if (pos > 0 && (categoryConsumers = this.topicToConsumerMap.get(category = topic.substring(0, pos + 1).concat("*"))) != null) {
                return categoryConsumers.get(0).getConsumer(this.bundleContext);
            }
        }
        return null;
    }

    public String getTopics() {
        return this.topics;
    }

    public boolean supportsBridgedEvents() {
        return this.supportsBridgedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindJobConsumer(ServiceReference serviceReference) {
        String[] topics = PropertiesUtil.toStringArray(serviceReference.getProperty("job.topics"));
        if (topics != null && topics.length > 0) {
            ConsumerInfo info = new ConsumerInfo(serviceReference);
            boolean changed = false;
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                for (String t : topics) {
                    String topic;
                    if (t == null || (topic = t.trim()).length() <= 0) continue;
                    List<ConsumerInfo> consumers = this.topicToConsumerMap.get(topic);
                    if (consumers == null) {
                        consumers = new ArrayList<ConsumerInfo>();
                        this.topicToConsumerMap.put(topic, consumers);
                        changed = true;
                    }
                    consumers.add(info);
                    Collections.sort(consumers);
                }
                this.supportsBridgedEvents = this.topicToConsumerMap.containsKey("/");
                if (changed) {
                    this.calculateTopics(this.propagationService != null);
                }
            }
            if (changed && this.propagationService != null) {
                LoggerFactory.getLogger(this.getClass()).info("Updating property provider with: {}", (Object)this.topics);
                this.propagationService.setProperties(this.getRegistrationProperties());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJobConsumer(ServiceReference serviceReference) {
        String[] topics = PropertiesUtil.toStringArray(serviceReference.getProperty("job.topics"));
        if (topics != null && topics.length > 0) {
            ConsumerInfo info = new ConsumerInfo(serviceReference);
            boolean changed = false;
            Map<String, List<ConsumerInfo>> map = this.topicToConsumerMap;
            synchronized (map) {
                for (String t : topics) {
                    List<ConsumerInfo> consumers;
                    String topic;
                    if (t == null || (topic = t.trim()).length() <= 0 || (consumers = this.topicToConsumerMap.get(topic)) == null) continue;
                    consumers.remove(info);
                    if (consumers.size() != 0) continue;
                    this.topicToConsumerMap.remove(topic);
                    changed = true;
                }
                this.supportsBridgedEvents = this.topicToConsumerMap.containsKey("/");
                if (changed) {
                    this.calculateTopics(this.propagationService != null);
                }
            }
            if (changed && this.propagationService != null) {
                LoggerFactory.getLogger(this.getClass()).info("Updating property provider with: {}", (Object)this.topics);
                this.propagationService.setProperties(this.getRegistrationProperties());
            }
        }
    }

    private boolean match(String topic, TopicMatcher[] matchers) {
        for (TopicMatcher m : matchers) {
            if (m.match(topic) == null) continue;
            return true;
        }
        return false;
    }

    private void calculateTopics(boolean enabled) {
        if (enabled) {
            ArrayList<String> topicList = new ArrayList<String>();
            for (String topic : this.topicToConsumerMap.keySet()) {
                if (!this.match(topic, this.whitelistMatchers) || this.blacklistMatchers != null && this.match(topic, this.blacklistMatchers)) continue;
                topicList.add(topic);
            }
            Collections.sort(topicList);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String topic : topicList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(topic);
            }
            this.topics = sb.toString();
        } else {
            this.topics = null;
        }
    }

    private static final class ConsumerInfo
    implements Comparable<ConsumerInfo> {
        public final ServiceReference serviceReference;
        private JobConsumer consumer;
        public final int ranking;
        public final long serviceId;

        public ConsumerInfo(ServiceReference serviceReference) {
            this.serviceReference = serviceReference;
            Object sr = serviceReference.getProperty("service.ranking");
            this.ranking = sr == null || !(sr instanceof Integer) ? 0 : (Integer)sr;
            this.serviceId = (Long)serviceReference.getProperty("service.id");
        }

        @Override
        public int compareTo(ConsumerInfo o) {
            if (this.ranking < o.ranking) {
                return 1;
            }
            if (this.ranking > o.ranking) {
                return -1;
            }
            return this.serviceId < o.serviceId ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConsumerInfo) {
                return ((ConsumerInfo)obj).serviceId == this.serviceId;
            }
            return false;
        }

        public int hashCode() {
            return this.serviceReference.hashCode();
        }

        public JobConsumer getConsumer(BundleContext bundleContext) {
            if (this.consumer == null) {
                this.consumer = (JobConsumer)bundleContext.getService(this.serviceReference);
            }
            return this.consumer;
        }
    }
}

