/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.event.jobs.Queue;

public class JobImpl
implements Job {
    public static final String PROPERTY_RESOURCE_PATH = "slingevent:path";
    public static final String PROPERTY_BRIDGED_EVENT = "slingevent:eventadmin";
    private final ValueMap properties;
    private final String topic;
    private final String path;
    private final String name;
    private final String jobId;
    private final boolean isBridgedEvent;
    private final List<Exception> readErrorList;

    public JobImpl(String topic, String name, String jobId, Map<String, Object> properties) {
        this.topic = topic;
        this.name = name;
        this.jobId = jobId;
        this.path = (String)properties.remove(PROPERTY_RESOURCE_PATH);
        this.isBridgedEvent = properties.get(PROPERTY_BRIDGED_EVENT) != null;
        this.readErrorList = (List)properties.remove(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
        this.properties = new ValueMapDecorator(properties);
        this.properties.put((Object)"slingevent:eventId", (Object)jobId);
    }

    public String getResourcePath() {
        return this.path;
    }

    public boolean isBridgedEvent() {
        return this.isBridgedEvent;
    }

    public boolean hasReadErrors() {
        return this.readErrorList != null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void retry() {
        int retries = (Integer)((Object)this.getProperty("event.job.retrycount", (Object)Integer.class));
        this.properties.put((Object)"event.job.retrycount", (Object)(retries + 1));
        this.properties.remove((Object)"event.job.started.time");
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.jobId;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get((Object)name);
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        return (T)this.properties.get(name, type);
    }

    @Override
    public <T> T getProperty(String name, T defaultValue) {
        return (T)this.properties.get(name, defaultValue);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public JobUtil.JobPriority getJobPriority() {
        return (JobUtil.JobPriority)((Object)this.getProperty("event.job.priority"));
    }

    @Override
    public int getRetryCount() {
        return (Integer)this.getProperty("event.job.retrycount");
    }

    @Override
    public int getNumberOfRetries() {
        return (Integer)this.getProperty("event.job.retries");
    }

    @Override
    public String getQueueName() {
        return (String)this.getProperty("event.job.queuename");
    }

    @Override
    public String getTargetInstance() {
        return (String)this.getProperty("event.job.application");
    }

    @Override
    public Calendar getProcessingStarted() {
        return (Calendar)this.getProperty("event.job.started.time");
    }

    @Override
    public Calendar getCreated() {
        return (Calendar)this.getProperty("slingevent:created");
    }

    @Override
    public String getCreatedInstance() {
        return (String)this.getProperty("slingevent:application");
    }

    public void updateQueueInfo(Queue queue) {
        this.properties.put((Object)"event.job.queuename", (Object)queue.getName());
        this.properties.put((Object)"event.job.retries", (Object)queue.getConfiguration().getMaxRetries());
        this.properties.put((Object)"event.job.priority", (Object)queue.getConfiguration().getPriority());
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove((Object)name);
        } else {
            this.properties.put((Object)name, value);
        }
    }

    public String toString() {
        return "JobImpl [properties=" + this.properties + ", topic=" + this.topic + ", path=" + this.path + ", name=" + this.name + ", jobId=" + this.jobId + ", isBridgedEvent=" + this.isBridgedEvent + "]";
    }
}

