/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.support.Environment;

public class JobManagerConfiguration {
    public static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/jobs";
    public static final String CONFIG_PROPERTY_REPOSITORY_PATH = "repository.path";
    public static final long DEFAULT_BACKGROUND_LOAD_DELAY = 30L;
    public static final String CONFIG_PROPERTY_BACKGROUND_LOAD_DELAY = "load.delay";
    public static final boolean DEFAULT_DISABLE_DISTRIBUTION = false;
    public static final String PROPERTY_DISABLE_DISTRIBUTION = "job.consumermanager.disableDistribution";
    private String jobsBasePathWithSlash;
    private String assignedJobsPath;
    private String unassignedJobsPath;
    private String localJobsPath;
    private String localJobsPathWithSlash;
    private String locksPath;
    private String previousVersionAnonPath;
    private String previousVersionIdentifiedPath;
    private String locksPathWithSlash;
    private long backgroundLoadDelay;
    private boolean disabledDistribution;
    private final AtomicLong jobCounter = new AtomicLong(0L);

    public JobManagerConfiguration(Map<String, Object> props) {
        this.update(props);
        this.jobsBasePathWithSlash = PropertiesUtil.toString(props.get(CONFIG_PROPERTY_REPOSITORY_PATH), DEFAULT_REPOSITORY_PATH) + '/';
        this.assignedJobsPath = this.jobsBasePathWithSlash + "assigned";
        this.unassignedJobsPath = this.jobsBasePathWithSlash + "unassigned";
        this.locksPath = this.jobsBasePathWithSlash + "locks";
        this.locksPathWithSlash = this.locksPath.concat("/");
        this.localJobsPath = this.assignedJobsPath.concat("/").concat(Environment.APPLICATION_ID);
        this.localJobsPathWithSlash = this.localJobsPath.concat("/");
        this.previousVersionAnonPath = this.jobsBasePathWithSlash + "anon";
        this.previousVersionIdentifiedPath = this.jobsBasePathWithSlash + "identified";
    }

    public void update(Map<String, Object> props) {
        this.disabledDistribution = PropertiesUtil.toBoolean(props.get(PROPERTY_DISABLE_DISTRIBUTION), false);
        this.backgroundLoadDelay = PropertiesUtil.toLong(props.get(CONFIG_PROPERTY_BACKGROUND_LOAD_DELAY), 30L);
    }

    public String getAssginedJobsPath() {
        return this.assignedJobsPath;
    }

    public String getUnassignedJobsPath() {
        return this.unassignedJobsPath;
    }

    public String getLocalJobsPath() {
        return this.localJobsPath;
    }

    public String getLocksPath() {
        return this.locksPath;
    }

    public long getBackgroundLoadDelay() {
        return this.backgroundLoadDelay;
    }

    public String getUniquePath(String targetId, String topic, String jobId, Map<String, Object> jobProperties) {
        boolean isBridged = jobProperties != null ? jobProperties.containsKey("slingevent:eventadmin") : false;
        String topicName = isBridged ? "slingevent:eventadmin" : topic.replace('/', '.');
        StringBuilder sb = new StringBuilder();
        if (targetId != null) {
            sb.append(this.assignedJobsPath);
            sb.append('/');
            sb.append(targetId);
        } else {
            sb.append(this.unassignedJobsPath);
        }
        sb.append('/');
        sb.append(topicName);
        sb.append('/');
        sb.append(jobId);
        return sb.toString();
    }

    public String getUniqueId(String jobTopic) {
        String convTopic = jobTopic.replace('/', '.');
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(now.get(1));
        sb.append('/');
        sb.append(now.get(2) + 1);
        sb.append('/');
        sb.append(now.get(5));
        sb.append('/');
        sb.append(now.get(11));
        sb.append('/');
        sb.append(now.get(12));
        sb.append('/');
        sb.append(convTopic);
        sb.append('_');
        sb.append(Environment.APPLICATION_ID);
        sb.append('_');
        sb.append(this.jobCounter.getAndIncrement());
        return sb.toString();
    }

    public boolean isLocalJob(String jobPath) {
        return jobPath.startsWith(this.localJobsPathWithSlash);
    }

    public boolean isJob(String jobPath) {
        return jobPath.startsWith(this.jobsBasePathWithSlash);
    }

    public boolean isLock(String lockPath) {
        return lockPath.startsWith(this.locksPathWithSlash);
    }

    public String getPreviousVersionAnonPath() {
        return this.previousVersionAnonPath;
    }

    public String getPreviousVersionIdentifiedPath() {
        return this.previousVersionIdentifiedPath;
    }

    public boolean disableDistribution() {
        return this.disabledDistribution;
    }
}

