/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.jobs.BackgroundLoader;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.MaintenanceTask;
import org.apache.sling.event.impl.jobs.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.jmx.QueueStatusEvent;
import org.apache.sling.event.impl.jobs.jmx.QueuesMBeanImpl;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.apache.sling.event.impl.jobs.queues.OrderedJobQueue;
import org.apache.sling.event.impl.jobs.queues.ParallelJobQueue;
import org.apache.sling.event.impl.jobs.queues.TopicRoundRobinJobQueue;
import org.apache.sling.event.impl.jobs.stats.StatisticsImpl;
import org.apache.sling.event.impl.jobs.stats.TopicStatisticsImpl;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.event.jobs.JobsIterator;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.apache.sling.event.jobs.jmx.QueuesMBean;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, name="org.apache.sling.event.impl.jobs.jcr.PersistenceHandler")
@Service(value={JobManager.class, EventHandler.class, TopologyEventListener.class, Runnable.class})
@Properties(value={@Property(name="repository.path", value={"/var/eventing/jobs"}), @Property(name="scheduler.period", longValue={60L}), @Property(name="scheduler.concurrent", boolValue={false}), @Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/event/notification/job/*", "org/osgi/framework/BundleEvent/STARTED", "org/osgi/framework/BundleEvent/UPDATED"})})
public class JobManagerImpl
extends StatisticsImpl
implements JobManager,
EventHandler,
TopologyEventListener,
Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private EnvironmentComponent environment;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private QueueConfigurationManager queueConfigManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private JobConsumerManager jobConsumerManager;
    @Reference
    private QueuesMBean queuesMBean;
    private JobManagerConfiguration configuration;
    private volatile TopologyCapabilities topologyCapabilities;
    private MaintenanceTask maintenanceTask;
    private BackgroundLoader backgroundLoader;
    private final Object queuesLock = new Object();
    private final Map<String, AbstractJobQueue> queues = new ConcurrentHashMap<String, AbstractJobQueue>();
    private volatile long schedulerRuns;
    private final StatisticsImpl baseStatistics = new StatisticsImpl();
    private final ConcurrentMap<String, TopicStatistics> topicStatistics = new ConcurrentHashMap<String, TopicStatistics>();
    private final Set<String> directlyAddedPaths = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(Map<String, Object> props) throws LoginException {
        this.configuration = new JobManagerConfiguration(props);
        this.maintenanceTask = new MaintenanceTask(this.configuration, this.resourceResolverFactory);
        this.backgroundLoader = new BackgroundLoader(this, this.configuration, this.resourceResolverFactory);
        ResourceResolver resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        try {
            ResourceHelper.getOrCreateBasePath(resolver, this.configuration.getLocalJobsPath());
            ResourceHelper.getOrCreateBasePath(resolver, this.configuration.getUnassignedJobsPath());
            ResourceHelper.getOrCreateBasePath(resolver, this.configuration.getLocksPath());
        }
        catch (PersistenceException pe) {
            this.ignoreException((Exception)((Object)pe));
        }
        finally {
            resolver.close();
        }
        this.logger.info("Apache Sling Job Manager started on instance {}", (Object)Environment.APPLICATION_ID);
    }

    @Modified
    protected void update(Map<String, Object> props) {
        this.configuration.update(props);
        TopologyCapabilities caps = this.topologyCapabilities;
        if (caps != null) {
            caps.update(this.configuration.disableDistribution());
        }
    }

    @Deactivate
    protected void deactivate() {
        this.logger.info("Apache Sling Job Manager stopping on instance {}", (Object)Environment.APPLICATION_ID);
        this.backgroundLoader.deactivate();
        this.backgroundLoader = null;
        this.maintenanceTask = null;
        this.configuration = null;
        for (AbstractJobQueue jbq : this.queues.values()) {
            jbq.close();
            ((QueuesMBeanImpl)this.queuesMBean).sendEvent(new QueueStatusEvent(null, jbq));
        }
        this.queues.clear();
        this.logger.info("Apache Sling Job Manager stopped on instance {}", (Object)Environment.APPLICATION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintain() {
        MaintenanceTask maintenanceTask;
        boolean doFullCleanUp;
        ++this.schedulerRuns;
        this.logger.debug("Job manager maintenance: Starting #{}", (Object)this.schedulerRuns);
        this.logger.debug("Checking for unprocessed jobs...");
        for (AbstractJobQueue abstractJobQueue : this.queues.values()) {
            abstractJobQueue.checkForUnprocessedJobs();
        }
        boolean bl = doFullCleanUp = this.schedulerRuns % 5L == 0L;
        if (doFullCleanUp) {
            this.logger.debug("Checking for idle queues...");
            Object object = this.queuesLock;
            synchronized (object) {
                Iterator<Map.Entry<String, AbstractJobQueue>> i = this.queues.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, AbstractJobQueue> current = i.next();
                    AbstractJobQueue jbq2 = current.getValue();
                    if (!jbq2.tryToClose()) continue;
                    this.logger.debug("Removing idle job queue {}", (Object)jbq2);
                    this.baseStatistics.add(jbq2);
                    i.remove();
                    ((QueuesMBeanImpl)this.queuesMBean).sendEvent(new QueueStatusEvent(null, jbq2));
                }
            }
        }
        if ((maintenanceTask = this.maintenanceTask) != null) {
            maintenanceTask.run(this.topologyCapabilities, this.queueConfigManager, this.schedulerRuns - 1L);
        }
        this.logger.debug("Job manager maintenance: Finished #{}", (Object)this.schedulerRuns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(JobImpl job) {
        JobConsumer consumer = this.jobConsumerManager.getConsumer(job.getTopic());
        boolean reassign = false;
        String reassignTargetId = null;
        if (!(consumer != null || job.isBridgedEvent() && this.jobConsumerManager.supportsBridgedEvents())) {
            reassign = true;
        }
        QueueConfigurationManager.QueueInfo queueInfo = this.queueConfigManager.getQueueInfo(job.getTopic());
        InternalQueueConfiguration config = queueInfo.queueConfiguration;
        if (config.getType() == QueueConfiguration.Type.DROP) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping job due to configuration of queue {} : {}", (Object)queueInfo.queueName, (Object)Utility.toString(job));
            }
            this.remove(job);
        } else if (config.getType() == QueueConfiguration.Type.IGNORE) {
            if (!reassign && this.logger.isDebugEnabled()) {
                this.logger.debug("Ignoring job due to configuration of queue {} : {}", (Object)queueInfo.queueName, (Object)Utility.toString(job));
            }
        } else if (reassign) {
            TopologyCapabilities caps = this.topologyCapabilities;
            reassignTargetId = caps == null ? null : caps.detectTarget(job.getTopic(), job.getProperties(), queueInfo);
        } else {
            AbstractJobQueue queue = null;
            Object object = this.queuesLock;
            synchronized (object) {
                queue = this.queues.get(queueInfo.queueName);
                if (queue != null && queue.getConfiguration() != config) {
                    this.outdateQueue(queue);
                    queue = null;
                }
                if (queue == null) {
                    if (config.getType() == QueueConfiguration.Type.ORDERED) {
                        queue = new OrderedJobQueue(queueInfo.queueName, config, this.jobConsumerManager, this.eventAdmin);
                    } else if (config.getType() == QueueConfiguration.Type.UNORDERED) {
                        queue = new ParallelJobQueue(queueInfo.queueName, config, this.jobConsumerManager, this.eventAdmin, this.scheduler);
                    } else if (config.getType() == QueueConfiguration.Type.TOPIC_ROUND_ROBIN) {
                        queue = new TopicRoundRobinJobQueue(queueInfo.queueName, config, this.jobConsumerManager, this.eventAdmin, this.scheduler);
                    }
                    if (queue == null) {
                        this.logger.warn("Ignoring event due to unknown queue type of queue {} : {}", (Object)queueInfo.queueName, (Object)Utility.toString(job));
                        this.remove(job);
                    } else {
                        this.queues.put(queueInfo.queueName, queue);
                        ((QueuesMBeanImpl)this.queuesMBean).sendEvent(new QueueStatusEvent(queue, null));
                        queue.start();
                    }
                }
            }
            if (queue != null) {
                job.updateQueueInfo(queue);
                JobHandler handler = new JobHandler(job, this);
                queue.process(handler);
            }
        }
        if (reassign) {
            this.maintenanceTask.reassignJob(job, reassignTargetId);
        }
    }

    @Override
    public void run() {
        this.maintain();
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    private void outdateQueue(AbstractJobQueue queue) {
        this.queues.remove(queue.getName());
        if (queue.tryToClose()) {
            this.baseStatistics.add(queue);
            ((QueuesMBeanImpl)this.queuesMBean).sendEvent(new QueueStatusEvent(null, queue));
        } else {
            queue.outdate();
            String newName = queue.getName();
            int index = 0;
            while (this.queues.containsKey(newName)) {
                newName = queue.getName() + '$' + String.valueOf(index++);
            }
            this.queues.put(newName, queue);
            ((QueuesMBeanImpl)this.queuesMBean).sendEvent(new QueueStatusEvent(queue, queue));
        }
    }

    @Override
    public synchronized void reset() {
        this.baseStatistics.reset();
        for (AbstractJobQueue jq : this.queues.values()) {
            jq.reset();
        }
        this.topicStatistics.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        Object object = this.queuesLock;
        synchronized (object) {
            ArrayList<AbstractJobQueue> queues = new ArrayList<AbstractJobQueue>(this.queues.values());
            for (AbstractJobQueue queue : queues) {
                queue.clear();
                this.outdateQueue(queue);
            }
        }
        this.reset();
        this.backgroundLoader.restart();
    }

    @Override
    public boolean isJobProcessingEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        String topic;
        if ("org/apache/sling/api/resource/Resource/ADDED".equals(event.getTopic())) {
            String path = (String)event.getProperty("path");
            String rt = (String)event.getProperty("resourceType");
            if ((rt == null || "slingevent:Job".equals(rt)) && this.configuration.isLocalJob(path)) {
                Set<String> set = this.directlyAddedPaths;
                synchronized (set) {
                    if (this.directlyAddedPaths.remove(path)) {
                        return;
                    }
                }
                this.backgroundLoader.loadJob(path);
            }
        } else if ("org/osgi/framework/BundleEvent/STARTED".equals(event.getTopic()) || "org/osgi/framework/BundleEvent/UPDATED".equals(event.getTopic())) {
            this.backgroundLoader.tryToReloadUnloadedJobs();
        } else if (EventUtil.isLocal(event) && (topic = (String)event.getProperty("event.job.topic")) != null) {
            TopicStatisticsImpl ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
            if (ts == null) {
                this.topicStatistics.putIfAbsent(topic, new TopicStatisticsImpl(topic));
                ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
            }
            if (event.getTopic().equals("org/apache/sling/event/notification/job/CANCELLED")) {
                ts.addCancelled();
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/FAILED")) {
                ts.addFailed();
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/FINISHED")) {
                Long time = (Long)event.getProperty("time");
                ts.addFinished(time == null ? -1L : time);
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/START")) {
                Long time = (Long)event.getProperty("time");
                ts.addActivated(time == null ? -1L : time);
            }
        }
    }

    JobImpl readJob(Resource resource) {
        JobImpl job = null;
        if (resource != null) {
            try {
                ValueMap vm = ResourceHelper.getValueMap(resource);
                String errorMessage = Utility.checkJobTopic(vm.get((Object)"event.job.topic"));
                String jobId = (String)vm.get("slingevent:eventId", String.class);
                if (errorMessage == null && jobId != null) {
                    String topic = (String)vm.get("event.job.topic", String.class);
                    Map<String, Object> jobProperties = ResourceHelper.cloneValueMap(vm);
                    jobProperties.put("slingevent:path", resource.getPath());
                    jobProperties.put("event.job.retries", vm.get("event.job.retries", Integer.class));
                    jobProperties.put("event.job.retrycount", vm.get("event.job.retrycount", Integer.class));
                    jobProperties.put("event.job.priority", (Object)JobUtil.JobPriority.valueOf((String)vm.get("event.job.priority", (Object)JobUtil.JobPriority.NORM.name())));
                    List readErrorList = (List)jobProperties.get(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
                    if (readErrorList != null) {
                        for (Exception e : readErrorList) {
                            this.logger.warn("Unable to read job from " + resource.getPath(), (Throwable)e);
                        }
                    }
                    job = new JobImpl(topic, (String)jobProperties.get("event.job.id"), jobId, jobProperties);
                } else {
                    if (errorMessage != null) {
                        this.logger.warn("{} : {}", (Object)errorMessage, (Object)resource.getPath());
                    } else if (jobId == null) {
                        this.logger.warn("Discarding job - no job id found : {}", (Object)resource.getPath());
                    }
                    try {
                        resource.getResourceResolver().delete(resource);
                        resource.getResourceResolver().commit();
                    }
                    catch (PersistenceException ignore) {
                        this.ignoreException((Exception)((Object)ignore));
                    }
                }
            }
            catch (InstantiationException ie) {
                this.ignoreException(ie);
            }
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProcessing() {
        this.backgroundLoader.stop();
        Object object = this.queuesLock;
        synchronized (object) {
            ArrayList<AbstractJobQueue> queues = new ArrayList<AbstractJobQueue>(this.queues.values());
            for (AbstractJobQueue queue : queues) {
                queue.clear();
                this.outdateQueue(queue);
            }
        }
        if (this.topologyCapabilities != null) {
            this.topologyCapabilities.deactivate();
        }
        this.topologyCapabilities = null;
    }

    private void startProcessing(TopologyView view) {
        this.topologyCapabilities = new TopologyCapabilities(view, this.configuration.disableDistribution());
        this.backgroundLoader.start();
    }

    public void handleTopologyEvent(TopologyEvent event) {
        this.logger.info("Received topology event {}", (Object)event);
        if (event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
            Map<String, String> newAllInstances = TopologyCapabilities.getAllInstancesMap(event.getNewView());
            if (this.topologyCapabilities != null && this.topologyCapabilities.isSame(newAllInstances)) {
                this.logger.info("No changes in capabilities - ignoring event");
                return;
            }
        }
        if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            this.stopProcessing();
        } else if (event.getType() == TopologyEvent.Type.TOPOLOGY_INIT || event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
            this.stopProcessing();
            this.startProcessing(event.getNewView());
        }
    }

    @Override
    public synchronized Statistics getStatistics() {
        this.copyFrom(this.baseStatistics);
        for (AbstractJobQueue jq : this.queues.values()) {
            this.add(jq);
        }
        return this;
    }

    @Override
    public Iterable<TopicStatistics> getTopicStatistics() {
        return this.topicStatistics.values();
    }

    @Override
    public Queue getQueue(String name) {
        return this.queues.get(name);
    }

    @Override
    public Iterable<Queue> getQueues() {
        final Iterator<AbstractJobQueue> jqI = this.queues.values().iterator();
        return new Iterable<Queue>(){

            @Override
            public Iterator<Queue> iterator() {
                return new Iterator<Queue>(){

                    @Override
                    public boolean hasNext() {
                        return jqI.hasNext();
                    }

                    @Override
                    public Queue next() {
                        return (Queue)jqI.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public JobsIterator queryJobs(JobManager.QueryType type, String topic, Map<String, Object> ... templates) {
        return this.queryJobs(type, topic, -1L, templates);
    }

    @Override
    public JobsIterator queryJobs(JobManager.QueryType type, String topic, long limit, Map<String, Object> ... templates) {
        final Collection<Job> list = this.findJobs(type, topic, limit, templates);
        final Iterator<Job> iter = list.iterator();
        return new JobsIterator(){
            private int index;

            @Override
            public Iterator<Event> iterator() {
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Event next() {
                ++this.index;
                Job job = (Job)iter.next();
                return Utility.toEvent(job);
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public void skip(long skipNum) {
                for (long m = skipNum; m > 0L && this.hasNext(); --m) {
                    this.next();
                }
            }

            @Override
            public long getSize() {
                return list.size();
            }

            @Override
            public long getPosition() {
                return this.index;
            }
        };
    }

    @Override
    public Event findJob(String topic, Map<String, Object> template) {
        Job job = this.getJob(topic, template);
        if (job != null) {
            return Utility.toEvent(job);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(String jobId) {
        this.logger.debug("Trying to remove job {}", (Object)jobId);
        boolean result = true;
        Job job = this.getJobById(jobId);
        this.logger.debug("Found removal job: {}", (Object)job);
        if (job != null) {
            if (job.getProcessingStarted() != null) {
                this.logger.debug("Unable to remove job - job is started: {}", (Object)job);
                result = false;
            } else {
                ResourceResolver resolver = null;
                try {
                    resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                    Resource jobResource = resolver.getResource(((JobImpl)job).getResourcePath());
                    if (jobResource != null) {
                        resolver.delete(jobResource);
                        resolver.commit();
                        this.logger.debug("Removed job with id: {}", (Object)jobId);
                    } else {
                        this.logger.debug("Unable to remove job with id - resource already removed: {}", (Object)jobId);
                    }
                }
                catch (LoginException le) {
                    this.ignoreException((Exception)((Object)le));
                    result = false;
                }
                catch (PersistenceException pe) {
                    this.ignoreException((Exception)((Object)pe));
                    result = false;
                }
                finally {
                    if (resolver != null) {
                        resolver.close();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void forceRemoveJob(String jobId) {
        this.removeJobById(jobId);
    }

    @Override
    public Job addJob(String topic, Map<String, Object> properties) {
        return this.addJob(topic, null, properties);
    }

    @Override
    public Job addJob(String topic, String name, Map<String, Object> properties) {
        String errorMessage = Utility.checkJobTopic(topic);
        if (errorMessage != null) {
            this.logger.warn("{}", (Object)errorMessage);
            return null;
        }
        Job result = this.addJobInteral(topic, name, properties);
        if (result == null && name != null) {
            result = this.getJobByName(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJobByName(String name) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append(ISO9075.encode("event.job.id"));
            buf.append(" = '");
            buf.append(name);
            buf.append("']");
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                JobImpl job;
                Resource jobResource = (Resource)result.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = this.readJob(jobResource)) == null) continue;
                JobImpl jobImpl = job;
                return jobImpl;
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJobById(String id) {
        this.logger.debug("Getting job by id: {}", (Object)id);
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append("slingevent:eventId");
            buf.append(" = '");
            buf.append(id);
            buf.append("']");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exceuting query: {}", (Object)buf.toString());
            }
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                JobImpl job;
                Resource jobResource = (Resource)result.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = this.readJob(jobResource)) == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found job with id {} = {}", (Object)id, (Object)job);
                }
                JobImpl jobImpl = job;
                return jobImpl;
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        this.logger.debug("Job not found with id: {}", (Object)id);
        return null;
    }

    @Override
    public Job getJob(String topic, Map<String, Object> template) {
        Collection<Job> iter = this.findJobs(JobManager.QueryType.ALL, topic, 1L, template);
        Iterator i = iter.iterator();
        if (i.hasNext()) {
            return (Job)i.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobById(String jobId) {
        boolean result = true;
        Job job = this.getJobById(jobId);
        if (job != null) {
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource jobResource = resolver.getResource(((JobImpl)job).getResourcePath());
                if (jobResource != null) {
                    resolver.delete(jobResource);
                    resolver.commit();
                }
            }
            catch (LoginException le) {
                this.ignoreException((Exception)((Object)le));
                result = false;
            }
            catch (PersistenceException pe) {
                this.ignoreException((Exception)((Object)pe));
                result = false;
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Job> findJobs(JobManager.QueryType type, String topic, long limit, Map<String, Object> ... templates) {
        ArrayList<Job> result = new ArrayList<Job>();
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append(ISO9075.encode("event.job.topic"));
            buf.append(" = '");
            buf.append(topic);
            buf.append("'");
            if (type == JobManager.QueryType.ACTIVE) {
                buf.append(" and @");
                buf.append(ISO9075.encode("event.job.started.time"));
            } else if (type == JobManager.QueryType.QUEUED) {
                buf.append(" and not(@");
                buf.append(ISO9075.encode("event.job.started.time"));
                buf.append(")");
            }
            if (templates != null && templates.length > 0) {
                buf.append(" and (");
                int index = 0;
                for (Map<String, Object> template : templates) {
                    if (index > 0) {
                        buf.append(" or ");
                    }
                    buf.append('(');
                    Iterator<Map.Entry<String, Object>> i = template.entrySet().iterator();
                    boolean first = true;
                    while (i.hasNext()) {
                        Map.Entry<String, Object> current = i.next();
                        String propName = ISO9075.encode(current.getKey());
                        if (first) {
                            first = false;
                            buf.append('@');
                        } else {
                            buf.append(" and @");
                        }
                        buf.append(propName);
                        buf.append(" = '");
                        buf.append(current.getValue());
                        buf.append("'");
                    }
                    buf.append(')');
                    ++index;
                }
                buf.append(')');
            }
            buf.append("] order by @");
            buf.append("slingevent:created");
            buf.append(" ascending");
            Iterator iter = resolver.findResources(buf.toString(), "xpath");
            long count = 0L;
            while (iter.hasNext() && (limit < 1L || count < limit)) {
                JobImpl job;
                Resource jobResource = (Resource)iter.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = this.readJob(jobResource)) == null) continue;
                ++count;
                result.add(job);
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        catch (LoginException le) {
            this.ignoreException((Exception)((Object)le));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(JobHandler info) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource jobResource = resolver.getResource(info.getJob().getResourcePath());
            if (jobResource != null) {
                try {
                    resolver.delete(jobResource);
                    resolver.commit();
                }
                catch (PersistenceException pe) {
                    // empty catch block
                }
            }
        }
        catch (LoginException loginException) {
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean reschedule(JobHandler info) {
        block10: {
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource jobResource = resolver.getResource(info.getJob().getResourcePath());
                if (jobResource != null) {
                    ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                    mvm.put((Object)"event.job.retrycount", info.getJob().getProperty("event.job.retrycount"));
                    mvm.remove((Object)"event.job.started.time");
                    try {
                        resolver.commit();
                        boolean bl = true;
                        return bl;
                    }
                    catch (PersistenceException pe) {}
                }
                break block10;
                {
                    catch (LoginException loginException) {
                    }
                }
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(JobImpl job) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource jobResource = resolver.getResource(job.getResourcePath());
            if (jobResource != null) {
                Utility.sendNotification(this.eventAdmin, "org/apache/sling/event/notification/job/CANCELLED", job, null);
                try {
                    resolver.delete(jobResource);
                    resolver.commit();
                }
                catch (PersistenceException pe) {
                    // empty catch block
                }
            }
        }
        catch (LoginException loginException) {
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(JobHandler info) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource jobResource = resolver.getResource(info.getJob().getResourcePath());
            if (jobResource != null) {
                ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                mvm.put((Object)"event.job.started.time", (Object)Calendar.getInstance());
                mvm.put((Object)"event.job.queuename", (Object)info.getJob().getQueueName());
                mvm.put((Object)"event.job.retries", (Object)info.getJob().getNumberOfRetries());
                mvm.put((Object)"event.job.priority", (Object)info.getJob().getJobPriority().name());
                resolver.commit();
                boolean bl = true;
                return bl;
            }
        }
        catch (PersistenceException ignore) {
            this.ignoreException((Exception)((Object)ignore));
        }
        catch (LoginException ignore) {
            this.ignoreException((Exception)((Object)ignore));
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lock(String id) {
        boolean hasLock;
        block15: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Trying to get lock for {}", (Object)id);
            }
            hasLock = false;
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                String lockName = ResourceHelper.filterName(id);
                StringBuilder sb = new StringBuilder(this.configuration.getLocksPath());
                sb.append('/');
                sb.append(lockName);
                String path = sb.toString();
                Resource lockResource = resolver.getResource(path);
                if (lockResource != null) break block15;
                resolver.refresh();
                try {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("lock.created", Calendar.getInstance());
                    props.put("lock.created.app", Environment.APPLICATION_ID);
                    props.put("sling:resourceType", "slingevent:Lock");
                    lockResource = ResourceHelper.getOrCreateResource(resolver, path, props);
                    if (!lockResource.getName().equals(lockName)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Created SNS lock resource on instance {} - discarding", (Object)Environment.APPLICATION_ID);
                        }
                        resolver.delete(lockResource);
                        resolver.commit();
                    } else {
                        ValueMap vm = (ValueMap)lockResource.adaptTo(ValueMap.class);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Got lock resource on instance {} with {}", (Object)Environment.APPLICATION_ID, vm.get((Object)"lock.created.app"));
                        }
                        if (vm.get((Object)"lock.created.app").equals(Environment.APPLICATION_ID)) {
                            hasLock = true;
                        }
                    }
                }
                catch (PersistenceException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
            catch (LoginException ignore) {
                this.ignoreException((Exception)((Object)ignore));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Lock for {} = {}", (Object)id, (Object)hasLock);
        }
        return hasLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job addJobInteral(String jobTopic, String jobName, Map<String, Object> jobProperties) {
        QueueConfigurationManager.QueueInfo info = this.queueConfigManager.getQueueInfo(jobTopic);
        if (info.queueConfiguration.getType() == QueueConfiguration.Type.DROP) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping job due to configuration of queue {} : {}", (Object)info.queueName, (Object)Utility.toString(jobTopic, jobName, jobProperties));
            }
            Utility.sendNotification(this.eventAdmin, "org/apache/sling/event/notification/job/CANCELLED", jobTopic, jobName, jobProperties, null);
        } else {
            if (jobName != null && !this.lock(jobName)) {
                this.logger.debug("Discarding duplicate job {}", (Object)Utility.toString(jobTopic, jobName, jobProperties));
                return null;
            }
            if (info.queueConfiguration.getType() != QueueConfiguration.Type.IGNORE) {
                TopologyCapabilities caps = this.topologyCapabilities;
                String string = info.targetId = caps == null ? null : caps.detectTarget(jobTopic, jobProperties, info);
            }
            if (this.logger.isDebugEnabled()) {
                if (info.targetId != null) {
                    this.logger.debug("Persisting job {} into queue {}, target={}", new Object[]{Utility.toString(jobTopic, jobName, jobProperties), info.queueName, info.targetId});
                } else {
                    this.logger.debug("Persisting job {} into queue {}", (Object)Utility.toString(jobTopic, jobName, jobProperties), (Object)info.queueName);
                }
            }
            ResourceResolver resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                JobImpl job = this.writeJob(resolver, jobTopic, jobName, jobProperties, info);
                if (job != null && this.configuration.isLocalJob(job.getResourcePath())) {
                    this.backgroundLoader.addJob(job);
                }
                JobImpl jobImpl = job;
                return jobImpl;
            }
            catch (PersistenceException re) {
                this.logger.error("Exception during persisting new job '" + Utility.toString(jobTopic, jobName, jobProperties) + "'", (Throwable)re);
            }
            catch (LoginException le) {
                this.logger.error("Exception during persisting new job '" + Utility.toString(jobTopic, jobName, jobProperties) + "'", (Throwable)le);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobImpl writeJob(ResourceResolver resolver, String jobTopic, String jobName, Map<String, Object> jobProperties, QueueConfigurationManager.QueueInfo info) throws PersistenceException {
        String jobId = this.configuration.getUniqueId(jobTopic);
        String path = this.configuration.getUniquePath(info.targetId, jobTopic, jobId, jobProperties);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (jobProperties != null) {
            for (Map.Entry<String, Object> entry : jobProperties.entrySet()) {
                String propName = entry.getKey();
                if (ResourceHelper.ignoreProperty(propName)) continue;
                properties.put(propName, entry.getValue());
            }
        }
        properties.put("slingevent:eventId", jobId);
        properties.put("event.job.topic", jobTopic);
        if (jobName != null) {
            properties.put("event.job.id", jobName);
        }
        properties.put("event.job.queuename", info.queueConfiguration.getName());
        properties.put("event.job.retrycount", 0);
        properties.put("event.job.retries", info.queueConfiguration.getMaxRetries());
        properties.put("event.job.priority", info.queueConfiguration.getPriority().name());
        properties.put("slingevent:created", Calendar.getInstance());
        properties.put("slingevent:application", Environment.APPLICATION_ID);
        if (info.targetId != null) {
            properties.put("event.job.application", info.targetId);
        } else {
            properties.remove("event.job.application");
        }
        properties.put("sling:resourceType", "slingevent:Job");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Storing new job {} at {}", properties, (Object)path);
        }
        Set<String> set = this.directlyAddedPaths;
        synchronized (set) {
            this.directlyAddedPaths.add(path);
        }
        ResourceHelper.getOrCreateResource(resolver, path, properties);
        properties.put("event.job.priority", (Object)info.queueConfiguration.getPriority());
        properties.put("slingevent:path", path);
        return new JobImpl(jobTopic, jobName, jobId, properties);
    }

    public void reassign(JobHandler handler) {
        JobImpl job = handler.getJob();
        QueueConfigurationManager.QueueInfo queueInfo = this.queueConfigManager.getQueueInfo(job.getTopic());
        InternalQueueConfiguration config = queueInfo.queueConfiguration;
        if (config.getType() == QueueConfiguration.Type.DROP) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping job due to configuration of queue {} : {}", (Object)queueInfo.queueName, (Object)Utility.toString(handler.getJob()));
            }
            handler.remove();
        } else {
            String targetId = null;
            if (config.getType() != QueueConfiguration.Type.IGNORE) {
                TopologyCapabilities caps = this.topologyCapabilities;
                targetId = caps == null ? null : caps.detectTarget(job.getTopic(), job.getProperties(), queueInfo);
            }
            this.maintenanceTask.reassignJob(handler.getJob(), targetId);
        }
    }

    public TopologyCapabilities getTopologyCapabilities() {
        return this.topologyCapabilities;
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindQueueConfigManager(QueueConfigurationManager queueConfigurationManager) {
        this.queueConfigManager = queueConfigurationManager;
    }

    protected void unbindQueueConfigManager(QueueConfigurationManager queueConfigurationManager) {
        if (this.queueConfigManager == queueConfigurationManager) {
            this.queueConfigManager = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindJobConsumerManager(JobConsumerManager jobConsumerManager) {
        this.jobConsumerManager = jobConsumerManager;
    }

    protected void unbindJobConsumerManager(JobConsumerManager jobConsumerManager) {
        if (this.jobConsumerManager == jobConsumerManager) {
            this.jobConsumerManager = null;
        }
    }

    protected void bindQueuesMBean(QueuesMBean queuesMBean) {
        this.queuesMBean = queuesMBean;
    }

    protected void unbindQueuesMBean(QueuesMBean queuesMBean) {
        if (this.queuesMBean == queuesMBean) {
            this.queuesMBean = null;
        }
    }
}

