/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.jobs.Job;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class Utility {
    public static final String PROPERTY_LOCK_CREATED = "lock.created";
    public static final String PROPERTY_LOCK_CREATED_APP = "lock.created.app";
    public static final String RESOURCE_TYPE_LOCK = "slingevent:Lock";
    public static final String PROPERTY_TIME = "time";

    public static String checkJobTopic(Object jobTopic) {
        String message;
        if (jobTopic != null) {
            if (jobTopic instanceof String) {
                boolean topicIsCorrect = false;
                try {
                    new Event((String)jobTopic, (Dictionary)null);
                    topicIsCorrect = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                message = !topicIsCorrect ? "Discarding job - job has an illegal job topic" : null;
            } else {
                message = "Discarding job - job topic is not of type string";
            }
        } else {
            message = "Discarding job - job topic is missing";
        }
        return message;
    }

    public static void sendNotification(EventAdmin eventAdmin, String eventTopic, String jobTopic, String jobName, Map<String, Object> jobProperties, Long time) {
        if (eventAdmin != null) {
            Map<String, Object> jobProps = jobProperties == null ? new HashMap<String, Object>() : jobProperties;
            JobImpl job = new JobImpl(jobTopic, jobName, "<unknown>", jobProps);
            Utility.sendNotificationInternal(eventAdmin, eventTopic, job, time);
        }
    }

    public static void sendNotification(EventAdmin eventAdmin, String eventTopic, Job job, Long time) {
        if (eventAdmin != null) {
            JobImpl jobCopy = new JobImpl(job.getTopic(), job.getName(), job.getId(), ((JobImpl)job).getProperties());
            Utility.sendNotificationInternal(eventAdmin, eventTopic, jobCopy, time);
        }
    }

    private static void sendNotificationInternal(EventAdmin eventAdmin, String eventTopic, Job job, Long time) {
        Hashtable<String, Object> eventProps = new Hashtable<String, Object>();
        ((Dictionary)eventProps).put("slingevent:eventId", job.getId());
        ((Dictionary)eventProps).put("event.job.topic", job.getTopic());
        if (job.getName() != null) {
            ((Dictionary)eventProps).put("event.job.id", job.getName());
        }
        for (String name : job.getPropertyNames()) {
            ((Dictionary)eventProps).put(name, job.getProperty(name));
        }
        ((Dictionary)eventProps).remove(":sling:jobs:asynchandler");
        ((Dictionary)eventProps).put("timestamp", System.currentTimeMillis());
        if (time != null) {
            ((Dictionary)eventProps).put(PROPERTY_TIME, time);
        }
        ((Dictionary)eventProps).put("event.notification.job", Utility.toEvent(job));
        eventAdmin.postEvent(new Event(eventTopic, eventProps));
    }

    public static Event toEvent(Job job) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        eventProps.putAll(((JobImpl)job).getProperties());
        if (job.getName() != null) {
            eventProps.put("event.job.id", job.getName());
        }
        eventProps.put("slingevent:eventId", job.getId());
        eventProps.remove(":sling:jobs:asynchandler");
        return new Event(job.getTopic(), eventProps);
    }

    private static void appendProperties(StringBuilder sb, Map<String, Object> properties) {
        if (properties != null) {
            sb.append(", properties=");
            boolean first = true;
            for (String propName : properties.keySet()) {
                if (propName.equals("slingevent:eventId") || propName.equals("event.job.id") || propName.equals("event.job.topic")) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(propName);
                sb.append('=');
                Object value = properties.get(propName);
                if (value instanceof Calendar) {
                    sb.append(value.getClass().getName());
                    sb.append('(');
                    sb.append(((Calendar)value).getTime());
                    sb.append(')');
                    continue;
                }
                sb.append(value);
            }
        }
    }

    public static String toString(String jobTopic, String name, Map<String, Object> properties) {
        StringBuilder sb = new StringBuilder("Sling Job ");
        sb.append("[topic=");
        sb.append(jobTopic);
        if (name != null) {
            sb.append(", name=");
            sb.append(name);
        }
        Utility.appendProperties(sb, properties);
        sb.append("]");
        return sb.toString();
    }

    public static String toString(Job job) {
        StringBuilder sb = new StringBuilder("Sling Job ");
        sb.append("[topic=");
        sb.append(job.getTopic());
        sb.append(", id=");
        sb.append(job.getId());
        if (job.getName() != null) {
            sb.append(", name=");
            sb.append(job.getName());
        }
        Utility.appendProperties(sb, ((JobImpl)job).getProperties());
        sb.append("]");
        return sb.toString();
    }
}

