/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.jobs.config.ConfigurationConstants;
import org.apache.sling.event.impl.support.TopicMatcher;
import org.apache.sling.event.impl.support.TopicMatcherHelper;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.event.jobs.QueueConfiguration;

@Component(metatype=true, name="org.apache.sling.event.jobs.QueueConfiguration", label="%queue.name", description="%queue.description", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={InternalQueueConfiguration.class})
@Properties(value={@Property(name="queue.name"), @Property(name="queue.type", value={"UNORDERED"}, options={@PropertyOption(name="UNORDERED", value="Parallel"), @PropertyOption(name="ORDERED", value="Ordered"), @PropertyOption(name="TOPIC_ROUND_ROBIN", value="Topic Round Robin"), @PropertyOption(name="IGNORE", value="Ignore"), @PropertyOption(name="DROP", value="Drop")}), @Property(name="queue.topics", unbounded=PropertyUnbounded.ARRAY), @Property(name="queue.maxparallel", intValue={15}), @Property(name="queue.retries", intValue={10}), @Property(name="queue.retrydelay", longValue={2000L}), @Property(name="queue.priority", value={"NORM"}, options={@PropertyOption(name="NORM", value="Norm"), @PropertyOption(name="MIN", value="Min"), @PropertyOption(name="MAX", value="Max")}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false, label="%queue.ranking.name", description="%queue.ranking.description")})
public class InternalQueueConfiguration
implements QueueConfiguration,
Comparable<InternalQueueConfiguration> {
    private String name;
    private QueueConfiguration.Type type;
    private int retries;
    private long retryDelay;
    private JobUtil.JobPriority priority;
    private int maxParallelProcesses;
    private int serviceRanking;
    private TopicMatcher[] matchers;
    private String[] topics;
    private boolean valid = false;
    private String pid;

    public static InternalQueueConfiguration fromConfiguration(Map<String, Object> params) {
        InternalQueueConfiguration c = new InternalQueueConfiguration();
        c.activate(params);
        return c;
    }

    @Activate
    protected void activate(Map<String, Object> params) {
        this.name = PropertiesUtil.toString(params.get("queue.name"), null);
        this.priority = JobUtil.JobPriority.valueOf(PropertiesUtil.toString(params.get("queue.priority"), "NORM"));
        this.type = QueueConfiguration.Type.valueOf(PropertiesUtil.toString(params.get("queue.type"), "UNORDERED"));
        this.retries = PropertiesUtil.toInteger(params.get("queue.retries"), 10);
        this.retryDelay = PropertiesUtil.toLong(params.get("queue.retrydelay"), 2000L);
        int maxParallel = PropertiesUtil.toInteger(params.get("queue.maxparallel"), 15);
        this.maxParallelProcesses = maxParallel == -1 ? ConfigurationConstants.NUMBER_OF_PROCESSORS : maxParallel;
        String[] topicsParam = PropertiesUtil.toStringArray(params.get("queue.topics"));
        this.matchers = TopicMatcherHelper.buildMatchers(topicsParam);
        this.topics = this.matchers == null ? null : topicsParam;
        this.serviceRanking = PropertiesUtil.toInteger(params.get("service.ranking"), 0);
        this.pid = (String)params.get("service.pid");
        this.valid = this.checkIsValid();
    }

    private boolean checkIsValid() {
        boolean hasMatchers = false;
        if (this.matchers != null) {
            for (TopicMatcher m : this.matchers) {
                if (m == null) continue;
                hasMatchers = true;
                break;
            }
        }
        if (!hasMatchers) {
            return false;
        }
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        if (this.retries < -1) {
            return false;
        }
        return this.type != QueueConfiguration.Type.UNORDERED && this.type != QueueConfiguration.Type.TOPIC_ROUND_ROBIN || this.maxParallelProcesses >= 1;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String match(String topic) {
        if (this.matchers != null) {
            for (TopicMatcher m : this.matchers) {
                String rep;
                if (m == null || (rep = m.match(topic)) == null) continue;
                return this.name.replace("{0}", rep);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getRetryDelayInMs() {
        return this.retryDelay;
    }

    @Override
    public int getMaxRetries() {
        return this.retries;
    }

    @Override
    public QueueConfiguration.Type getType() {
        return this.type;
    }

    @Override
    public JobUtil.JobPriority getPriority() {
        return this.priority;
    }

    @Override
    public int getMaxParallel() {
        return this.maxParallelProcesses;
    }

    @Override
    @Deprecated
    public boolean isLocalQueue() {
        return false;
    }

    @Override
    public String[] getTopics() {
        return this.topics;
    }

    @Override
    public int getRanking() {
        return this.serviceRanking;
    }

    public String getPid() {
        return this.pid;
    }

    @Override
    @Deprecated
    public String[] getApplicationIds() {
        return null;
    }

    public String toString() {
        return "Queue-Configuration(" + this.hashCode() + ") : {" + "name=" + this.name + ", type=" + (Object)((Object)this.type) + ", topics=" + (this.matchers == null ? "[]" : Arrays.toString(this.matchers)) + ", maxParallelProcesses=" + this.maxParallelProcesses + ", retries=" + this.retries + ", retryDelayInMs= " + this.retryDelay + ", serviceRanking=" + this.serviceRanking + ", pid=" + this.pid + ", isValid=" + this.isValid() + "}";
    }

    @Override
    public int compareTo(InternalQueueConfiguration other) {
        if (this.serviceRanking < other.serviceRanking) {
            return 1;
        }
        if (this.serviceRanking > other.serviceRanking) {
            return -1;
        }
        return 0;
    }
}

