/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%job.events.name", description="%job.events.description", name="org.apache.sling.event.impl.jobs.DefaultJobManager", metatype=true)
@Service(value={MainQueueConfiguration.class})
@Properties(value={@Property(name="queue.priority", value={"NORM"}, options={@PropertyOption(name="NORM", value="Norm"), @PropertyOption(name="MIN", value="Min"), @PropertyOption(name="MAX", value="Max")}), @Property(name="queue.retries", intValue={10}), @Property(name="queue.retrydelay", longValue={2000L}), @Property(name="queue.maxparallel", intValue={15})})
public class MainQueueConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private InternalQueueConfiguration mainConfiguration;

    @Activate
    protected void activate(Map<String, Object> props) {
        this.update(props);
    }

    @Modified
    protected void update(Map<String, Object> props) {
        HashMap<String, Object> queueProps = new HashMap<String, Object>(props);
        queueProps.put("queue.topics", "*");
        queueProps.put("queue.name", "<main queue>");
        queueProps.put("queue.type", (Object)QueueConfiguration.Type.UNORDERED);
        int maxParallel = PropertiesUtil.toInteger(queueProps.get("queue.maxparallel"), 15);
        if (maxParallel < 2) {
            this.logger.debug("Ignoring invalid setting of {} for {}. Setting to minimum value: 2", (Object)maxParallel, (Object)"queue.maxparallel");
            queueProps.put("queue.maxparallel", 2);
        }
        this.mainConfiguration = InternalQueueConfiguration.fromConfiguration(queueProps);
    }

    public InternalQueueConfiguration getMainConfiguration() {
        return this.mainConfiguration;
    }
}

