/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.deprecated;

import java.util.Dictionary;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventHandler.class, JobConsumer.class})
@Properties(value={@Property(name="event.topics", value={"org/apache/sling/event/job"}), @Property(name="job.topics", value={"/"})})
public class EventAdminBridge
implements EventHandler,
JobConsumer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<Event> writeQueue = new LinkedBlockingQueue<Event>();
    private volatile boolean running;
    @Reference
    private JobManager jobManager;
    private static String[] IGNORED_CONFIG_PROPERTIES = new String[]{"event.job.parallel", "event.job.run.local", "event.job.retries", "event.job.queuename", "event.job.queueordered", "event.job.priority"};

    @Activate
    protected void activate() {
        this.running = true;
        Thread writerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                EventAdminBridge.this.addJobs();
            }
        }, "Apache Sling Job Event Bridge");
        writerThread.setDaemon(true);
        writerThread.start();
    }

    @Deactivate
    protected void deactivate() {
        this.running = false;
        try {
            this.writeQueue.put(new Event("deactivate", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
        }
        this.logger.info("Apache Sling Job Event Bridge stopped on instance {}", (Object)Environment.APPLICATION_ID);
    }

    private void addJobs() {
        this.logger.info("Apache Sling Job Event Bridge started on instance {}", (Object)Environment.APPLICATION_ID);
        try {
            this.processWriteQueue();
        }
        catch (Throwable t) {
            this.logger.error("Bridge thread stopped with exception: " + t.getMessage(), t);
            this.running = false;
        }
    }

    private void processWriteQueue() {
        while (this.running) {
            Event event = null;
            try {
                event = this.writeQueue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
            }
            if (event == null || !this.running) continue;
            JobManager jm = this.jobManager;
            if (jm == null) {
                try {
                    this.writeQueue.put(event);
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    this.ignoreException(ie);
                }
                continue;
            }
            String jobTopic = (String)event.getProperty("event.job.topic");
            String jobName = (String)event.getProperty("event.job.id");
            EventPropertiesMap props = new EventPropertiesMap(event);
            props.put("slingevent:eventadmin", Boolean.TRUE);
            for (String ignoredProp : IGNORED_CONFIG_PROPERTIES) {
                if (!props.containsKey(ignoredProp)) continue;
                this.logger.info("Job {} is using deprecated and ignored property {}", (Object)EventUtil.toString(event), (Object)ignoredProp);
                props.remove(ignoredProp);
            }
            this.jobManager.addJob(jobTopic, jobName, props);
        }
    }

    public void handleEvent(Event event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Receiving event {}", (Object)EventUtil.toString(event));
        }
        if (EventUtil.isLocal(event)) {
            String errorMessage;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Handling local job {}", (Object)EventUtil.toString(event));
            }
            if ((errorMessage = Utility.checkJobTopic(event.getProperty("event.job.topic"))) == null) {
                try {
                    this.writeQueue.put(event);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
            } else {
                this.logger.warn(errorMessage + " : {}", (Object)EventUtil.toString(event));
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public JobConsumer.JobResult process(Job job) {
        return JobConsumer.JobResult.CANCEL;
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }
}

