/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractJobQueue;
import org.osgi.service.event.EventAdmin;

public final class OrderedJobQueue
extends AbstractJobQueue {
    private volatile JobHandler jobHandler;
    private final SleepLock sleepLock = new SleepLock();
    private final Set<JobHandler> queue = new TreeSet<JobHandler>(new Comparator<JobHandler>(){

        @Override
        public int compare(JobHandler o1, JobHandler o2) {
            if (o1.getJob() == null) {
                if (o2.getJob() == null) {
                    return 0;
                }
                return -1;
            }
            if (o2.getJob() == null) {
                return 1;
            }
            return o1.getJob().getCreated().compareTo(o2.getJob().getCreated());
        }
    });
    private final Object syncLock = new Object();

    public OrderedJobQueue(String name, InternalQueueConfiguration config, JobConsumerManager jobConsumerManager, EventAdmin eventAdmin) {
        super(name, config, jobConsumerManager, eventAdmin);
    }

    @Override
    public String getStateInfo() {
        return super.getStateInfo() + ", isSleepingUntil=" + this.sleepLock.sleepingSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobHandler start(JobHandler handler) {
        JobHandler rescheduleHandler = null;
        Object object = this.syncLock;
        synchronized (object) {
            if (this.executeJob(handler)) {
                this.isWaiting = true;
                this.logger.debug("Job queue {} is waiting for finish.", (Object)this.queueName);
                while (this.isWaiting) {
                    try {
                        this.syncLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                    }
                }
                this.logger.debug("Job queue {} is continuing.", (Object)this.queueName);
                rescheduleHandler = this.jobHandler;
                this.jobHandler = null;
            }
        }
        return rescheduleHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp(boolean discardJob) {
        SleepLock sleepLock = this.sleepLock;
        synchronized (sleepLock) {
            if (this.sleepLock.sleepingSince != -1L) {
                if (discardJob) {
                    this.sleepLock.jobHandler = null;
                }
                this.sleepLock.notify();
            }
        }
    }

    @Override
    public void resume() {
        this.wakeUp(false);
        super.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void put(JobHandler handler) {
        Set<JobHandler> set = this.queue;
        synchronized (set) {
            this.queue.add(handler);
            this.queue.notify();
            this.isWaitingForNext = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobHandler take() {
        Set<JobHandler> set = this.queue;
        synchronized (set) {
            while (this.queue.isEmpty()) {
                this.isWaitingForNext = true;
                try {
                    this.queue.wait();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
                this.isWaitingForNext = false;
            }
            Iterator<JobHandler> i = this.queue.iterator();
            JobHandler result = i.next();
            i.remove();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isEmpty() {
        Set<JobHandler> set = this.queue;
        synchronized (set) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyFinished(JobHandler rescheduleHandler) {
        this.jobHandler = rescheduleHandler;
        this.logger.debug("Notifying job queue {} to continue processing.", (Object)this.queueName);
        Object object = this.syncLock;
        synchronized (object) {
            this.isWaiting = false;
            this.syncLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobHandler reschedule(JobHandler handler) {
        long delay = this.configuration.getRetryDelayInMs();
        if (handler.getJob().getProperty("event.job.retrydelay") != null) {
            delay = (Long)((Object)handler.getJob().getProperty("event.job.retrydelay", Long.class));
        }
        if (delay > 0L) {
            SleepLock sleepLock = this.sleepLock;
            synchronized (sleepLock) {
                this.sleepLock.sleepingSince = System.currentTimeMillis();
                this.sleepLock.jobHandler = handler;
                this.logger.debug("Job queue {} is sleeping for {}ms.", (Object)this.queueName, (Object)delay);
                try {
                    this.sleepLock.wait(delay);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                }
                this.sleepLock.sleepingSince = -1L;
                JobHandler result = this.sleepLock.jobHandler;
                this.sleepLock.jobHandler = null;
                if (result == null) {
                    handler.remove();
                }
                return result;
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Set<JobHandler> set = this.queue;
        synchronized (set) {
            this.queue.clear();
        }
        super.clear();
    }

    @Override
    public synchronized void removeAll() {
        super.removeAll();
        this.jobHandler = null;
        this.wakeUp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<JobHandler> removeAllJobs() {
        ArrayList<JobHandler> events = new ArrayList<JobHandler>();
        Set<JobHandler> set = this.queue;
        synchronized (set) {
            events.addAll(this.queue);
            this.queue.clear();
        }
        return events;
    }

    @Override
    public Object getState(String key) {
        if ("isSleepingUntil".equals(key)) {
            return this.sleepLock.sleepingSince;
        }
        return super.getState(key);
    }

    private static final class SleepLock {
        public volatile long sleepingSince = -1L;
        public volatile JobHandler jobHandler;

        private SleepLock() {
        }
    }
}

