/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.queues.AbstractParallelJobQueue;
import org.osgi.service.event.EventAdmin;

public final class TopicRoundRobinJobQueue
extends AbstractParallelJobQueue {
    private final List<String> topics = new ArrayList<String>();
    private final Map<String, List<JobHandler>> topicMap = new HashMap<String, List<JobHandler>>();
    private int topicIndex;
    private int eventCount;

    public TopicRoundRobinJobQueue(String name, InternalQueueConfiguration config, JobConsumerManager jobConsumerManager, EventAdmin eventAdmin, Scheduler scheduler) {
        super(name, config, jobConsumerManager, eventAdmin, scheduler);
    }

    @Override
    public String getStateInfo() {
        return super.getStateInfo() + ", eventCount=" + this.eventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void put(JobHandler event) {
        if (event.getJob() == null) {
            return;
        }
        String topic = event.getJob().getTopic();
        Map<String, List<JobHandler>> map = this.topicMap;
        synchronized (map) {
            List<JobHandler> events = this.topicMap.get(topic);
            if (events == null) {
                events = new LinkedList<JobHandler>();
                this.topicMap.put(topic, events);
                this.topics.add(topic);
            }
            events.add(event);
            ++this.eventCount;
            if (this.isWaitingForNext) {
                this.isWaitingForNext = false;
                this.topicMap.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobHandler take() {
        JobHandler e = null;
        Map<String, List<JobHandler>> map = this.topicMap;
        synchronized (map) {
            if (this.eventCount == 0) {
                this.isWaitingForNext = true;
                while (this.isWaitingForNext) {
                    try {
                        this.topicMap.wait();
                    }
                    catch (InterruptedException ie) {
                        this.ignoreException(ie);
                    }
                }
            }
            if (this.eventCount > 0) {
                while (e == null) {
                    String topic = this.topics.get(this.topicIndex);
                    List<JobHandler> events = this.topicMap.get(topic);
                    if (events.size() > 0) {
                        e = events.remove(0);
                    }
                    ++this.topicIndex;
                    if (this.topicIndex != this.topics.size()) continue;
                    this.topicIndex = 0;
                }
                --this.eventCount;
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isEmpty() {
        Map<String, List<JobHandler>> map = this.topicMap;
        synchronized (map) {
            return this.eventCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, List<JobHandler>> map = this.topicMap;
        synchronized (map) {
            this.eventCount = 0;
            this.topics.clear();
            this.topicMap.clear();
            this.topicIndex = 0;
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<JobHandler> removeAllJobs() {
        ArrayList<JobHandler> events = new ArrayList<JobHandler>();
        Map<String, List<JobHandler>> map = this.topicMap;
        synchronized (map) {
            for (List<JobHandler> l : this.topicMap.values()) {
                events.addAll(l);
            }
            this.eventCount = 0;
            this.topics.clear();
            this.topicMap.clear();
            this.topicIndex = 0;
        }
        return events;
    }
}

