/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.threads.ModifiableThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPoolManager;

@Component(label="%event.pool.name", description="%event.pool.description", metatype=true)
@Service(value={EventingThreadPool.class})
public class EventingThreadPool
implements ThreadPool {
    @Reference
    private ThreadPoolManager threadPoolManager;
    private ThreadPool threadPool;
    private static final int DEFAULT_POOL_SIZE = 35;
    @Property(intValue={35})
    private static final String PROPERTY_POOL_SIZE = "minPoolSize";

    public EventingThreadPool() {
    }

    public EventingThreadPool(ThreadPoolManager tpm, int poolSize) {
        this.threadPoolManager = tpm;
    }

    public void release() {
        this.deactivate();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> props) {
        int maxPoolSize = PropertiesUtil.toInteger(props.get(PROPERTY_POOL_SIZE), 35);
        this.configure(maxPoolSize);
    }

    private void configure(int maxPoolSize) {
        ModifiableThreadPoolConfig config = new ModifiableThreadPoolConfig();
        config.setMinPoolSize(maxPoolSize);
        config.setMaxPoolSize(config.getMinPoolSize());
        config.setQueueSize(-1);
        config.setShutdownGraceful(true);
        config.setPriority(ThreadPoolConfig.ThreadPriority.NORM);
        config.setDaemon(true);
        this.threadPool = this.threadPoolManager.create((ThreadPoolConfig)config, "Apache Sling Eventing Thread Pool");
    }

    @Deactivate
    protected void deactivate() {
        this.threadPoolManager.release(this.threadPool);
    }

    public void execute(Runnable runnable) {
        this.threadPool.execute(runnable);
    }

    public ThreadPoolConfig getConfiguration() {
        return this.threadPool.getConfiguration();
    }

    public String getName() {
        return this.threadPool.getName();
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }
}

