/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundLoader
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private final ResourceResolverFactory resourceResolverFactory;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private volatile boolean running = false;
    private final JobManagerImpl jobManager;
    private final Object loadLock = new Object();
    private final Object stopLock = new Object();
    private final Set<String> unloadedJobs = new HashSet<String>();
    private final BlockingQueue<Object> actionQueue = new LinkedBlockingQueue<Object>();
    private boolean firstRun = true;
    private boolean useSearch = true;
    private static final String END_TOKEN = "*";

    public BackgroundLoader(JobManagerImpl jobManagerImpl, JobManagerConfiguration configuration2, ResourceResolverFactory resourceResolverFactory2) {
        this.resourceResolverFactory = resourceResolverFactory2;
        this.configuration = configuration2;
        this.jobManager = jobManagerImpl;
        this.active.set(true);
        this.logger.debug("Activating Sling Job Background Loader");
        Thread loaderThread = new Thread((Runnable)this, "Apache Sling Job Background Loader");
        loaderThread.setDaemon(true);
        loaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        this.logger.debug("Deactivating Sling Job Background Loader");
        this.active.set(false);
        Object object = this.loadLock;
        synchronized (object) {
            this.running = false;
            this.loadLock.notify();
        }
        this.stop();
        object = this.stopLock;
        synchronized (object) {
            this.stopLock.notify();
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.loadLock;
        synchronized (object) {
            this.logger.debug("Starting Sling Job Background Loader");
            this.running = true;
            this.actionQueue.clear();
            this.unloadedJobs.clear();
            this.loadLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.loadLock;
        synchronized (object) {
            this.logger.debug("Stopping Sling Job Background Loader");
            this.running = false;
        }
        try {
            this.actionQueue.put(END_TOKEN);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    public void restart() {
        if (this.isRunning()) {
            this.logger.debug("Restarting Sling Job Background Loader");
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug("Started Sling Job Background Thread");
        try {
            while (this.active.get()) {
                long startTime;
                Object object = this.loadLock;
                synchronized (object) {
                    while (this.active.get() && !this.running) {
                        this.logger.debug("Sling Job Background Thread is waiting to be started");
                        try {
                            this.loadLock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.active.set(false);
                        }
                    }
                    startTime = System.currentTimeMillis();
                }
                if (this.isRunning()) {
                    this.logger.debug("Sling Job Background Thread is waiting for system to be ready");
                    object = this.stopLock;
                    synchronized (object) {
                        try {
                            this.stopLock.wait(1000L * this.configuration.getBackgroundLoadDelay());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            this.active.set(false);
                        }
                    }
                }
                if (this.isRunning()) {
                    this.logger.debug("Sling Job Background Thread starts loading jobs");
                    this.loadJobsInTheBackground(startTime);
                }
                if (this.isRunning()) {
                    this.firstRun = false;
                }
                while (this.isRunning()) {
                    String path;
                    Object nextPathOrJob = null;
                    try {
                        nextPathOrJob = this.actionQueue.take();
                    }
                    catch (InterruptedException e) {
                        this.ignoreException(e);
                        Thread.currentThread().interrupt();
                        this.active.set(false);
                    }
                    if (nextPathOrJob instanceof JobImpl) {
                        this.jobManager.process((JobImpl)nextPathOrJob);
                        continue;
                    }
                    if (!(nextPathOrJob instanceof String) || END_TOKEN.equals(path = (String)nextPathOrJob) || !this.isRunning()) continue;
                    ResourceResolver resolver = null;
                    try {
                        resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                        Resource resource = resolver.getResource(path);
                        if (resource == null) {
                            this.logger.warn("No job resource found for path {}. Potential job will not be processed.", (Object)path);
                            continue;
                        }
                        if (!"slingevent:Job".equals(resource.getResourceType())) continue;
                        this.logger.debug("Reading local job from {}", (Object)path);
                        JobImpl job = this.jobManager.readJob(resource);
                        if (job == null) continue;
                        if (job.hasReadErrors()) {
                            Set<String> set = this.unloadedJobs;
                            synchronized (set) {
                                this.unloadedJobs.add(path);
                                continue;
                            }
                        }
                        this.jobManager.process(job);
                    }
                    catch (LoginException le) {
                        this.ignoreException((Exception)((Object)le));
                    }
                    finally {
                        if (resolver == null) continue;
                        resolver.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Unexpected error in background loader thread." + t.getMessage(), t);
        }
        this.logger.debug("Stopped Sling Job Background Thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobsInTheBackground(long startTime) {
        ResourceResolver resolver;
        this.logger.debug("Starting background loading...");
        long count = 0L;
        if (this.useSearch) {
            this.logger.debug("Using search for background loading...");
            resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Calendar startDate = Calendar.getInstance();
                startDate.setTimeInMillis(startTime);
                StringBuilder buf = new StringBuilder(64);
                buf.append("//element(*,");
                buf.append("slingevent:Job");
                buf.append(")[@");
                buf.append(ISO9075.encode("event.job.application"));
                buf.append(" = '");
                buf.append(Environment.APPLICATION_ID);
                buf.append("' and @");
                buf.append(ISO9075.encode("slingevent:created"));
                buf.append(" < xs:dateTime('");
                buf.append(ISO8601.format(startDate));
                buf.append("')");
                buf.append("] order by @");
                buf.append(ISO9075.encode("slingevent:created"));
                buf.append(" ascending");
                if (this.isRunning()) {
                    Iterator result = resolver.findResources(buf.toString(), "xpath");
                    while (this.isRunning() && result.hasNext()) {
                        Resource jobResource = (Resource)result.next();
                        if (!this.loadJobInTheBackground(jobResource)) continue;
                        ++count;
                    }
                }
            }
            catch (QuerySyntaxException qse) {
                this.ignoreException((Exception)((Object)qse));
            }
            catch (LoginException le) {
                this.ignoreException((Exception)((Object)le));
            }
            catch (UnsupportedOperationException t) {
                this.logger.error("Unexpected unsupported operation exception. This is most probably because of Apache Jackrabbit Oak complaining about to long running query. Switching to traversal now.");
                this.useSearch = false;
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
        if (!this.useSearch) {
            this.logger.debug("Using traversal for background loading...");
            resolver = null;
            try {
                resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource baseResource = resolver.getResource(this.configuration.getLocalJobsPath());
                Comparator<Resource> resourceComparator = new Comparator<Resource>(){

                    @Override
                    public int compare(Resource o1, Resource o2) {
                        int value2;
                        int value1 = Integer.valueOf(o1.getName());
                        if (value1 < (value2 = Integer.valueOf(o2.getName()).intValue())) {
                            return -1;
                        }
                        if (value1 > value2) {
                            return 1;
                        }
                        return 0;
                    }
                };
                if (baseResource != null) {
                    Calendar now = Calendar.getInstance();
                    now.setTimeInMillis(startTime);
                    Iterator topicIter = baseResource.listChildren();
                    while (this.isRunning() && topicIter.hasNext()) {
                        Resource topicResource = (Resource)topicIter.next();
                        this.logger.debug("Processing topic {}", (Object)topicResource.getName());
                        ArrayList<Resource> years = new ArrayList<Resource>();
                        Iterator yearIter = topicResource.listChildren();
                        while (this.isRunning() && yearIter.hasNext()) {
                            Resource yearResource = (Resource)yearIter.next();
                            years.add(yearResource);
                            this.logger.debug("Found year {}", (Object)yearResource.getName());
                        }
                        Collections.sort(years, resourceComparator);
                        for (Resource yearResource : years) {
                            int year = Integer.valueOf(yearResource.getName());
                            if (year > now.get(1)) {
                                this.logger.debug("Skipping year {}", (Object)year);
                                continue;
                            }
                            this.logger.debug("Processing year {}", (Object)year);
                            ArrayList<Resource> months = new ArrayList<Resource>();
                            Iterator monthIter = yearResource.listChildren();
                            while (this.isRunning() && monthIter.hasNext()) {
                                Resource monthResource = (Resource)monthIter.next();
                                months.add(monthResource);
                                this.logger.debug("Found month {}", (Object)monthResource.getName());
                            }
                            Collections.sort(months, resourceComparator);
                            for (Resource monthResource : months) {
                                int month = Integer.valueOf(monthResource.getName());
                                if (year == now.get(1) && month > now.get(2) + 1) {
                                    this.logger.debug("Skipping month {}", (Object)month);
                                    continue;
                                }
                                this.logger.debug("Processing month {}", (Object)month);
                                ArrayList<Resource> days = new ArrayList<Resource>();
                                Iterator dayIter = monthResource.listChildren();
                                while (this.isRunning() && dayIter.hasNext()) {
                                    Resource dayResource = (Resource)dayIter.next();
                                    days.add(dayResource);
                                    this.logger.debug("Found day {}", (Object)dayResource.getName());
                                }
                                Collections.sort(days, resourceComparator);
                                for (Resource dayResource : days) {
                                    int day = Integer.valueOf(dayResource.getName());
                                    if (year == now.get(1) && month == now.get(2) + 1 && day > now.get(5)) {
                                        this.logger.debug("Skipping day {}", (Object)day);
                                        continue;
                                    }
                                    this.logger.debug("Processing day {}", (Object)day);
                                    ArrayList<Resource> hours = new ArrayList<Resource>();
                                    Iterator hourIter = dayResource.listChildren();
                                    while (this.isRunning() && hourIter.hasNext()) {
                                        Resource hourResource = (Resource)hourIter.next();
                                        hours.add(hourResource);
                                        this.logger.debug("Found hour {}", (Object)hourResource.getName());
                                    }
                                    Collections.sort(hours, resourceComparator);
                                    for (Resource hourResource : hours) {
                                        int hour = Integer.valueOf(hourResource.getName());
                                        if (year == now.get(1) && month == now.get(2) + 1 && day == now.get(5) && hour > now.get(11)) {
                                            this.logger.debug("Skipping hour {}", (Object)hour);
                                            continue;
                                        }
                                        this.logger.debug("Processing hour {}", (Object)hour);
                                        ArrayList<Resource> minutes = new ArrayList<Resource>();
                                        Iterator minuteIter = hourResource.listChildren();
                                        while (this.isRunning() && minuteIter.hasNext()) {
                                            Resource minuteResource = (Resource)minuteIter.next();
                                            minutes.add(minuteResource);
                                            this.logger.debug("Found minute {}", (Object)minuteResource.getName());
                                        }
                                        Collections.sort(minutes, resourceComparator);
                                        for (Resource minuteResource : minutes) {
                                            int minute = Integer.valueOf(minuteResource.getName());
                                            if (year == now.get(1) && month == now.get(2) + 1 && day == now.get(5) && hour == now.get(11) && minute > now.get(12)) {
                                                this.logger.debug("Skipping minute {}", (Object)minute);
                                                continue;
                                            }
                                            this.logger.debug("Processing minute {}", (Object)minute);
                                            ArrayList<JobImpl> jobs = new ArrayList<JobImpl>();
                                            Iterator jobIter = minuteResource.listChildren();
                                            while (this.isRunning() && jobIter.hasNext()) {
                                                Resource jobResource = (Resource)jobIter.next();
                                                JobImpl job = this.jobManager.readJob(jobResource);
                                                if (job != null && job.getCreated().compareTo(now) <= 0) {
                                                    this.logger.debug("Found job {}", (Object)jobResource.getName());
                                                    jobs.add(job);
                                                    continue;
                                                }
                                                this.logger.debug("Skipping job {}", (Object)jobResource.getName());
                                            }
                                            Collections.sort(jobs, new Comparator<Job>(){

                                                @Override
                                                public int compare(Job o1, Job o2) {
                                                    return o1.getCreated().compareTo(o2.getCreated());
                                                }
                                            });
                                            for (JobImpl job : jobs) {
                                                Resource jobResource = resolver.getResource(job.getResourcePath());
                                                if (jobResource == null || !this.isRunning() || !this.loadJobInTheBackground(jobResource)) continue;
                                                ++count;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (LoginException le) {
                this.ignoreException((Exception)((Object)le));
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
        this.logger.info("Finished background loading of {} jobs.", (Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadJobInTheBackground(Resource jobResource) {
        JobImpl job;
        if (this.configuration.isLocalJob(jobResource.getPath()) && (job = this.jobManager.readJob(jobResource)) != null && (this.firstRun || job.getProcessingStarted() == null)) {
            if (job.getProcessingStarted() != null && this.isRunning()) {
                job.retry();
                try {
                    ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                    mvm.remove((Object)"event.job.started.time");
                    mvm.put((Object)"event.job.retrycount", (Object)job.getRetryCount());
                    jobResource.getResourceResolver().commit();
                }
                catch (PersistenceException ignore) {
                    this.ignoreException((Exception)((Object)ignore));
                }
            }
            if (job.hasReadErrors()) {
                Set<String> set = this.unloadedJobs;
                synchronized (set) {
                    this.unloadedJobs.add(job.getResourcePath());
                }
            } else if (this.isRunning()) {
                this.jobManager.process(job);
            }
            return true;
        }
        return false;
    }

    private boolean isRunning() {
        return this.active.get() && this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToReloadUnloadedJobs() {
        final HashSet<String> copyUnloadedJobs = new HashSet<String>();
        Set<String> set = this.unloadedJobs;
        synchronized (set) {
            copyUnloadedJobs.addAll(this.unloadedJobs);
            this.unloadedJobs.clear();
        }
        if (copyUnloadedJobs.size() > 0) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Iterator iter = copyUnloadedJobs.iterator();
                    while (iter.hasNext()) {
                        Object object = BackgroundLoader.this.loadLock;
                        synchronized (object) {
                            if (BackgroundLoader.this.isRunning()) {
                                try {
                                    BackgroundLoader.this.actionQueue.put(iter.next());
                                }
                                catch (InterruptedException e) {
                                    BackgroundLoader.this.ignoreException(e);
                                    Thread.currentThread().interrupt();
                                    BackgroundLoader.this.running = false;
                                }
                            }
                        }
                    }
                }
            };
            Environment.THREAD_POOL.execute(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJob(String path) {
        Object object = this.loadLock;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    this.actionQueue.put(path);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobImpl job) {
        Object object = this.loadLock;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    this.actionQueue.put(job);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

