/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.Queue;

public class JobHandler {
    private final JobImpl job;
    public long queued = -1L;
    public long started = -1L;
    private volatile boolean isStopped = false;
    private final JobManagerImpl jobManager;

    public JobHandler(JobImpl job, JobManagerImpl jobManager) {
        this.job = job;
        this.jobManager = jobManager;
    }

    public JobImpl getJob() {
        return this.job;
    }

    public boolean startProcessing(Queue queue) {
        this.isStopped = false;
        return this.jobManager.persistJobProperties(this.job, this.job.prepare(queue));
    }

    public void finished(Job.JobState state, boolean keepJobInHistory, long duration) {
        this.jobManager.finishJob(this.job, state, keepJobInHistory, duration);
    }

    public boolean reschedule() {
        return this.jobManager.reschedule(this.job);
    }

    public void cancel() {
        this.jobManager.finishJob(this.job, Job.JobState.DROPPED, true, -1L);
    }

    public void reassign() {
        this.jobManager.reassign(this.job);
    }

    public void persistJobProperties(String ... propNames) {
        if (propNames != null) {
            this.jobManager.persistJobProperties(this.job, propNames);
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void stop() {
        this.isStopped = true;
    }

    public int hashCode() {
        return this.job.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobHandler)) {
            return false;
        }
        return this.job.getId().equals(((JobHandler)obj).job.getId());
    }

    public String toString() {
        return "JobHandler(" + this.job.getId() + ")";
    }
}

