/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.MainQueueConfiguration;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@Component
@Service(value={QueueConfigurationManager.class})
public class QueueConfigurationManager {
    private volatile InternalQueueConfiguration[] orderedConfigs = new InternalQueueConfiguration[0];
    private ServiceTracker configTracker;
    private volatile int lastTrackerCount = -1;
    @Reference
    private MainQueueConfiguration mainQueueConfiguration;

    @Activate
    protected void activate(BundleContext bundleContext) throws LoginException, PersistenceException {
        this.configTracker = new ServiceTracker(bundleContext, InternalQueueConfiguration.class.getName(), null);
        this.configTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        if (this.configTracker != null) {
            this.configTracker.close();
            this.configTracker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalQueueConfiguration[] getConfigurations() {
        int count = this.configTracker.getTrackingCount();
        InternalQueueConfiguration[] configurations = this.orderedConfigs;
        if (this.lastTrackerCount < count) {
            QueueConfigurationManager queueConfigurationManager = this;
            synchronized (queueConfigurationManager) {
                configurations = this.orderedConfigs;
                if (this.lastTrackerCount < count) {
                    Object[] trackedConfigs = this.configTracker.getServices();
                    if (trackedConfigs == null || trackedConfigs.length == 0) {
                        configurations = new InternalQueueConfiguration[]{};
                    } else {
                        ArrayList<InternalQueueConfiguration> configs = new ArrayList<InternalQueueConfiguration>();
                        for (Object entry : trackedConfigs) {
                            InternalQueueConfiguration config = (InternalQueueConfiguration)entry;
                            configs.add(config);
                        }
                        Collections.sort(configs);
                        configurations = configs.toArray(new InternalQueueConfiguration[configs.size()]);
                    }
                    this.orderedConfigs = configurations;
                    this.lastTrackerCount = count;
                }
            }
        }
        return configurations;
    }

    public InternalQueueConfiguration getMainQueueConfiguration() {
        return this.mainQueueConfiguration.getMainConfiguration();
    }

    public QueueInfo getQueueInfo(String topic) {
        InternalQueueConfiguration[] configurations;
        for (InternalQueueConfiguration config : configurations = this.getConfigurations()) {
            String qn;
            if (!config.isValid() || (qn = config.match(topic)) == null) continue;
            QueueInfo result = new QueueInfo();
            result.queueConfiguration = config;
            result.queueName = ResourceHelper.filterName(qn);
            return result;
        }
        QueueInfo result = new QueueInfo();
        result.queueConfiguration = this.mainQueueConfiguration.getMainConfiguration();
        result.queueName = result.queueConfiguration.getName();
        return result;
    }

    public int getChangeCount() {
        return this.configTracker.getTrackingCount();
    }

    protected void bindMainQueueConfiguration(MainQueueConfiguration mainQueueConfiguration) {
        this.mainQueueConfiguration = mainQueueConfiguration;
    }

    protected void unbindMainQueueConfiguration(MainQueueConfiguration mainQueueConfiguration) {
        if (this.mainQueueConfiguration == mainQueueConfiguration) {
            this.mainQueueConfiguration = null;
        }
    }

    public static final class QueueInfo {
        public InternalQueueConfiguration queueConfiguration;
        public String queueName;
        public String targetId;
    }
}

